/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JApplet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Editor
extends JApplet {
    private static final long serialVersionUID = 1L;
    private EditorPanel editor;
    private Vector<String> tags = new Vector();
    private String php_ext;
    public URL codeBase;
    public String SERVER_NAME;
    public int port;
    public String protocol;
    public String cmpCode = "";
    protected boolean isHot = false;
    private Parameter parameter;
    public boolean isCodeSet = false;
    private Map<String, Vector<String>> attribs = new HashMap<String, Vector<String>>();

    @Override
    public void init() {
        String url;
        this.codeBase = this.getCodeBase();
        this.SERVER_NAME = this.codeBase.getHost();
        this.port = this.getDocumentBase().getPort();
        this.protocol = this.getDocumentBase().getProtocol();
        if (this.SERVER_NAME.length() > 0) {
            url = this.port != -1 ? this.protocol + "://" + this.SERVER_NAME + ":" + this.port + "/webEdition/editor/initEditor.html" : this.protocol + "://" + this.SERVER_NAME + "/webEdition/editor/initEditor.html";
            this.showUrl(url);
        }
        this.parameter = Parameter.getInstance();
        String p = this.getParameter("weTagColor");
        if (p != null && p.length() > 0) {
            this.parameter.setWeTagColor(p);
        }
        if ((p = this.getParameter("weAttributeColor")) != null && p.length() > 0) {
            this.parameter.setWeAttributeColor(p);
        }
        if ((p = this.getParameter("HTMLTagColor")) != null && p.length() > 0) {
            this.parameter.setHTMLTagColor(p);
        }
        if ((p = this.getParameter("HTMLAttributeColor")) != null && p.length() > 0) {
            this.parameter.setHTMLAttributeColor(p);
        }
        if ((p = this.getParameter("piColor")) != null && p.length() > 0) {
            this.parameter.setPiColor(p);
        }
        if ((p = this.getParameter("commentColor")) != null && p.length() > 0) {
            this.parameter.setCommentColor(p);
        }
        if ((p = this.getParameter("normalColor")) != null && p.length() > 0) {
            this.parameter.setNormalColor(p);
        }
        if ((p = this.getParameter("fontName")) != null && p.length() > 0) {
            this.parameter.setFontName(p);
        }
        if ((p = this.getParameter("fontSize")) != null && p.length() > 0) {
            this.parameter.setFontSize(Integer.valueOf(p));
        }
        if ((p = this.getParameter("contentType")) != null && p.length() > 0) {
            this.parameter.setContentType(p);
        }
        this.php_ext = this.getParameter("phpext");
        if (this.php_ext == null) {
            this.php_ext = ".php";
        }
        url = this.SERVER_NAME.length() > 0 ? (this.port != -1 ? this.protocol + "://" + this.SERVER_NAME + ":" + this.port + "/webEdition/editor/getAllTags" + this.php_ext : this.protocol + "://" + this.SERVER_NAME + "/webEdition/editor/getAllTags" + this.php_ext) : "http://wetrunk.holeg.hq.living-e.zz/webEdition/editor/getAllTags.php";
        this.tags = this.getFromServer(url, "tag");
        this.editor = new EditorPanel(this);
        this.getContentPane().add((Component)this.editor, "Center");
    }

    private Vector<String> getFromServer(String urlString, String nodeName) {
        URL url = null;
        Vector<String> out = new Vector<String>();
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e1) {
            System.out.println("Error creating URL " + urlString);
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            BufferedReader URLinput = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = "";
            String xmlContent = "";
            while ((line = URLinput.readLine()) != null) {
                xmlContent = xmlContent + line + "\n";
            }
            DocumentBuilder parser = null;
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                System.out.println("Error initializing XML parser");
            }
            try {
                Document doc = parser.parse(new InputSource(new StringReader(xmlContent)));
                NodeList nodes = doc.getElementsByTagName(nodeName);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element = (Element)nodes.item(i);
                    out.addElement(element.getAttribute("name") + "/" + element.getAttribute("needsEndtag"));
                }
            }
            catch (SAXException e) {
                System.out.println("Error parsing XML");
            }
        }
        catch (IOException e1) {
            System.out.println("Error connecting to url: " + urlString);
        }
        return out;
    }

    public Vector<String> getTags() {
        return this.tags;
    }

    public Vector<String> getAttribsForTag(String tagName) {
        if (!this.attribs.containsKey(tagName)) {
            String url = this.SERVER_NAME.length() > 0 ? (this.port != -1 ? this.protocol + "://" + this.SERVER_NAME + ":" + this.port + "/webEdition/editor/getAttribsForTag" + this.php_ext + "?tagName=" + tagName : this.protocol + "://" + this.SERVER_NAME + "/webEdition/editor/getAttribsForTag" + this.php_ext + "?tagName=" + tagName) : "http://wetrunk.holeg.intra/webEdition/editor/getAttribsForTag.php?tagName=" + tagName;
            Vector<String> attr = this.getFromServer(url, "attribute");
            this.attribs.put(tagName, attr);
        }
        return this.attribs.get(tagName);
    }

    public void setCode(String code) {
        this.editor.setCode(code);
        this.cmpCode = code;
        this.isCodeSet = true;
    }

    public void initUndoManager() {
        this.editor.initUndoManager();
    }

    public String getCode() {
        return this.editor.getCode();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    public void sendCtrlS() {
        if (this.SERVER_NAME.length() > 0) {
            String url = this.port != -1 ? this.protocol + "://" + this.SERVER_NAME + ":" + this.port + "/webEdition/we_lcmd" + this.php_ext + "?wecmd0=trigger_save_document" : this.protocol + "://" + this.SERVER_NAME + "/webEdition/we_lcmd" + this.php_ext + "?wecmd0=trigger_save_document";
            this.showUrl(url);
        }
    }

    public void showUrl(String url) {
        try {
            this.getAppletContext().showDocument(new URL(url), "load");
        }
        catch (MalformedURLException e1) {
            System.out.println("Error connecting to URL " + url);
        }
    }

    public EditorPanel getEditor() {
        return this.editor;
    }

    public boolean isHot() {
        return this.isHot;
    }

    public void setHot(boolean isHot) {
        this.isHot = isHot;
    }

    public void replaceSelection(String txt) {
        this.editor.pane.replaceSelection(txt);
    }

    public void insertAtStart(String txt) {
        this.editor.pane.setCaretPosition(0);
        this.editor.pane.replaceSelection(txt);
    }

    public void insertAtEnd(String txt) {
        this.editor.pane.setCaretPosition(this.editor.pane.getDocument().getEndPosition().getOffset() - 1);
        this.editor.pane.replaceSelection(txt);
    }
}

