/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class EditorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JTextPane pane;
    JScrollPane scrollPane;
    Font NrPanelFont;
    EditorPanel panel;
    LineNumberPanel lineNumbers;
    Editor applet;
    DefaultListModel suggestedTags;
    DefaultListModel attribsForTag;
    TagSuggestor tSuggestor;
    AttribSuggestor aSuggestor;
    String tagName = null;
    String attribName = null;
    Action defaultDownAction = null;
    SuggestorController suggestorController = null;
    private Parameter parameter;

    public EditorPanel(final Editor applet) {
        this.setLayout(new BorderLayout());
        this.applet = applet;
        this.suggestedTags = new DefaultListModel();
        this.attribsForTag = new DefaultListModel();
        this.panel = this;
        StyleContext sc = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(sc);
        this.pane = new JTextPane(doc){
            private static final long serialVersionUID = 1L;

            public void paint(Graphics g) {
                super.paint(g);
                if (EditorPanel.this.tSuggestor.isVisible()) {
                    EditorPanel.this.tSuggestor.repaint();
                } else if (EditorPanel.this.aSuggestor.isVisible()) {
                    EditorPanel.this.aSuggestor.repaint();
                }
            }
        };
        JPanel p = new JPanel(new BorderLayout());
        p.add(this.pane);
        this.scrollPane = new JScrollPane(p);
        Parameter parameter = Parameter.getInstance();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(parameter.getFontSize() + 1);
        this.lineNumbers = new LineNumberPanel(this.pane);
        this.suggestorController = new SuggestorController(this.pane, applet, this.lineNumbers);
        this.tSuggestor = this.suggestorController.getTagSuggestor();
        this.aSuggestor = this.suggestorController.getAttribSuggestor();
        StyledEditorKit editorKit = new StyledEditorKit(){
            private static final long serialVersionUID = 1L;

            public Document createDefaultDocument() {
                return new SyntaxDocument(applet, EditorPanel.this.panel);
            }
        };
        parameter = Parameter.getInstance();
        String contentType = parameter.getContentType();
        if (contentType.equals("text/weTmpl")) {
            this.pane.setEditorKitForContentType(contentType, editorKit);
            this.pane.setContentType(contentType);
        }
        ActionMap am = this.pane.getActionMap();
        am.put("insert-break", new IndentBreakAction());
        this.defaultDownAction = am.get("caret-down");
        this.add((Component)this.lineNumbers, "West");
        class MyAdjustmentListener
        implements AdjustmentListener {
            MyAdjustmentListener() {
            }

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                EditorPanel.this.tSuggestor.hideSuggestor();
                EditorPanel.this.aSuggestor.hideSuggestor();
            }
        }
        MyAdjustmentListener listener = new MyAdjustmentListener();
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(listener);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(listener);
        this.add(this.tSuggestor);
        this.add(this.aSuggestor);
        this.add(this.scrollPane);
        this.pane.setFont(new Font(parameter.getFontName(), 0, parameter.getFontSize()));
        this.setTabs(this.pane, 4);
        this.pane.addKeyListener(new KeyAdapter(){
            boolean ctrlPressed = false;

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    this.ctrlPressed = false;
                }
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    this.ctrlPressed = true;
                }
                if (this.ctrlPressed && e.getKeyCode() == 83) {
                    applet.sendCtrlS();
                }
            }
        });
        this.pane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (EditorPanel.this.tSuggestor.isVisible()) {
                    EditorPanel.this.tSuggestor.hideSuggestor();
                }
                if (EditorPanel.this.aSuggestor.isVisible()) {
                    EditorPanel.this.aSuggestor.hideSuggestor();
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void setTabs(JTextPane textPane, int charactersPerTab) {
        FontMetrics fm = textPane.getFontMetrics(textPane.getFont());
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = textPane.getDocument().getLength();
        textPane.getStyledDocument().setParagraphAttributes(0, length, attributes, false);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.tSuggestor.repaint();
    }

    public void initUndoManager() {
        CompoundUndoManager manager = new CompoundUndoManager(this.pane);
        UndoAction undoAction = new UndoAction(manager, this.lineNumbers);
        RedoAction redoAction = new RedoAction(manager, this.lineNumbers);
        this.pane.registerKeyboardAction(undoAction, KeyStroke.getKeyStroke("meta pressed Z"), 0);
        this.pane.registerKeyboardAction(undoAction, KeyStroke.getKeyStroke("ctrl pressed Z"), 0);
        this.pane.registerKeyboardAction(redoAction, KeyStroke.getKeyStroke("meta shift pressed Z"), 0);
        this.pane.registerKeyboardAction(redoAction, KeyStroke.getKeyStroke("ctrl shift pressed Z"), 0);
        this.pane.registerKeyboardAction(redoAction, KeyStroke.getKeyStroke("ctrl pressed Y"), 0);
    }

    public void setCode(String code) {
        this.pane.setText(code);
    }

    public String getCode() {
        return this.pane.getText();
    }

    public TagSuggestor getSuggestor() {
        return this.tSuggestor;
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private LineNumberPanel lineNumbers;
        private UndoManager manager;

        public RedoAction(UndoManager manager, LineNumberPanel ln) {
            this.manager = manager;
            this.lineNumbers = ln;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                this.manager.redo();
                this.lineNumbers.repaint();
            }
            catch (CannotRedoException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private UndoManager manager;
        private LineNumberPanel lineNumbers;

        public UndoAction(UndoManager manager, LineNumberPanel ln) {
            this.manager = manager;
            this.lineNumbers = ln;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                this.manager.undo();
                this.lineNumbers.repaint();
            }
            catch (CannotUndoException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

