/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class LineNumberPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JTextPane pane;
    JScrollPane scrollPane;
    Font NrPanelFont;
    boolean userChanges = true;

    public LineNumberPanel(JTextPane pane) {
        this.pane = pane;
        final LineNumberPanel _this = this;
        this.setMinimumSize(new Dimension(44, 0));
        this.setPreferredSize(new Dimension(44, 0));
        this.setMinimumSize(new Dimension(44, 0));
        this.NrPanelFont = new Font("courier", 0, 10);
        this.scrollPane = (JScrollPane)pane.getParent().getParent().getParent();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyAdjustmentListener
        implements AdjustmentListener {
            MyAdjustmentListener() {
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                _this.repaint();
            }
        }
        MyAdjustmentListener listener = new MyAdjustmentListener();
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(listener);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setClip(0, 2, 40, this.scrollPane.getViewport().getHeight());
        int start = Math.max(0, this.pane.viewToModel(this.scrollPane.getViewport().getViewPosition()));
        int end = this.pane.viewToModel(new Point(this.scrollPane.getViewport().getViewPosition().x + this.pane.getWidth(), this.scrollPane.getViewport().getViewPosition().y + this.pane.getHeight()));
        Document doc = this.pane.getDocument();
        int startline = doc.getDefaultRootElement().getElementIndex(start) + 1;
        int endline = doc.getDefaultRootElement().getElementIndex(end) + 1;
        g.setFont(this.NrPanelFont);
        int fontHeight = g.getFontMetrics(this.pane.getFont()).getHeight();
        int fontDesc = g.getFontMetrics(this.pane.getFont()).getMaxDescent();
        int starting_y = -1;
        try {
            starting_y = 1 + this.pane.modelToView((int)start).y - this.scrollPane.getViewport().getViewPosition().y + fontHeight - fontDesc;
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        catch (NullPointerException e1) {
            starting_y = 1 + fontHeight - fontDesc;
        }
        int y = starting_y;
        for (int line = startline; line <= endline; ++line) {
            int _w = g.getFontMetrics().stringWidth(Integer.toString(line));
            g.drawString(Integer.toString(line), 40 - _w, y);
            y += fontHeight;
        }
    }
}

