/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class SuggestorController {
    private JTextPane pane;
    private int caretPos = 0;
    private String lineText = "";
    private int weStartTagStartPos = -1;
    private int weEndTagStartPos = -1;
    private String tagName = "";
    private String selectTag = "";
    private String attribName = "";
    private Editor applet;
    private TagSuggestor tSuggestor;
    private AttribSuggestor aSuggestor;
    private LineNumberPanel lineNumbers;
    private DefaultListModel suggestedTags;
    private DefaultListModel attribsForTag;

    public SuggestorController(JTextPane aPane, Editor anApplet, LineNumberPanel someLineNumbers) {
        this.pane = aPane;
        this.applet = anApplet;
        this.lineNumbers = someLineNumbers;
        this.suggestedTags = new DefaultListModel();
        this.attribsForTag = new DefaultListModel();
        this.tSuggestor = new TagSuggestor(this.applet, this.pane, this.lineNumbers);
        this.tSuggestor.addSuggestorListener(new SuggestorListener(){

            public void entrySelected(SuggestorEvent e) {
                SuggestorController.this.tagName = e.getValue();
            }
        });
        this.aSuggestor = new AttribSuggestor(this.applet, this.pane, this.lineNumbers);
        Parameter parameter = Parameter.getInstance();
        String contentType = parameter.getContentType();
        if (contentType.equals("text/weTmpl")) {
            this.pane.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    SuggestorController.this.update();
                }

                public void keyTyped(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (SuggestorController.this.suggestorsVisible()) {
                        switch (e.getKeyCode()) {
                            case 27: {
                                SuggestorController.this.hideSuggestors();
                                return;
                            }
                            case 40: {
                                SuggestorController.this.handleArrowKeyDown(true);
                                return;
                            }
                        }
                    }
                }
            });
        }
    }

    public boolean suggestorsVisible() {
        return this.tSuggestor.isVisible() || this.aSuggestor.isVisible();
    }

    public TagSuggestor getTagSuggestor() {
        return this.tSuggestor;
    }

    public AttribSuggestor getAttribSuggestor() {
        return this.aSuggestor;
    }

    public void update() {
        String[] parts;
        int i;
        Document doc = this.pane.getDocument();
        Element rootElement = doc.getDefaultRootElement();
        int selectionStart = this.pane.getSelectionStart();
        int line = rootElement.getElementIndex(selectionStart);
        int start = rootElement.getElement(line).getStartOffset();
        int end = rootElement.getElement(line).getEndOffset();
        this.caretPos = this.pane.getCaretPosition() - start;
        int length = end - start;
        try {
            this.lineText = doc.getText(start, length);
        }
        catch (BadLocationException e1) {
            this.lineText = "";
            return;
        }
        if (this.shouldShowTagSuggestor()) {
            this.tSuggestor.setSuggestedValue(this.tagName);
            Vector<String> tags = this.applet.getTags();
            this.suggestedTags.clear();
            for (i = 0; i < tags.size(); ++i) {
                boolean isEndTag;
                String weTag = tags.get(i);
                parts = weTag.split("/");
                if (this.tagName.length() != 0 && (parts[0].length() < this.tagName.length() || !parts[0].substring(0, this.tagName.length()).equals(this.tagName)) || (!(isEndTag = this.cursorIsInWeEndTag()) || !parts[1].equals("true")) && isEndTag) continue;
                this.suggestedTags.addElement(parts[0]);
            }
            if (this.suggestedTags.size() > 0) {
                if (this.pane.getSelectedText() == null) {
                    this.tSuggestor.showSuggestor(this.suggestedTags);
                    if (this.selectTag != null && this.selectTag.length() > 0) {
                        this.tSuggestor.selectEntry(this.selectTag);
                        this.handleArrowKeyDown(false);
                    }
                }
            } else {
                this.hideSuggestors();
            }
        } else if (this.tSuggestor.isVisible()) {
            this.tSuggestor.hideSuggestor();
        }
        if (this.shouldShowAttribSuggestor()) {
            this.aSuggestor.setSuggestedValue(this.attribName);
            Vector<String> attribs = this.applet.getAttribsForTag(this.tagName);
            this.attribsForTag.clear();
            for (i = 0; i < attribs.size(); ++i) {
                String weAttrib = attribs.get(i);
                parts = weAttrib.split("/");
                if (this.attribName.length() != 0 && (parts[0].length() < this.attribName.length() || !parts[0].substring(0, this.attribName.length()).equals(this.attribName))) continue;
                this.attribsForTag.addElement(parts[0]);
            }
            if (this.attribsForTag.size() > 0) {
                this.aSuggestor.showSuggestor(this.attribsForTag);
            } else {
                this.hideSuggestors();
            }
        } else if (this.aSuggestor.isVisible()) {
            this.aSuggestor.hideSuggestor();
        }
    }

    private boolean shouldShowTagSuggestor() {
        if (this.cursorIsInWeStartTag() && this.lineText.lastIndexOf(" ", this.caretPos - 1) <= this.weStartTagStartPos) {
            this.tagName = this.lineText.substring(this.weStartTagStartPos + 4, this.caretPos);
            this.selectTag = "";
            return true;
        }
        if (this.cursorIsInWeEndTag() && this.lineText.lastIndexOf(" ", this.caretPos - 1) <= this.weEndTagStartPos) {
            this.tagName = this.lineText.substring(this.weEndTagStartPos + 5, this.caretPos);
            this.selectTag = this.tagName.length() == 0 ? this.findLastOpenStartTag() : "";
            return true;
        }
        return false;
    }

    private String findLastOpenStartTag() {
        String content = "";
        Document doc = this.pane.getDocument();
        try {
            content = doc.getText(0, doc.getLength()).substring(0, this.pane.getCaretPosition());
            Pattern p = Pattern.compile("</?we:([^ >]+)");
            Matcher m = p.matcher(content);
            Hashtable<String, Integer> h = new Hashtable<String, Integer>();
            while (m.find()) {
                String tagName = m.group(1);
                System.out.println("tagName:" + tagName);
                int count = h.containsKey(tagName) ? (Integer)h.get(tagName) : 0;
                count = m.group(0).substring(1, 2).equals("/") ? --count : ++count;
                h.put(tagName, count);
            }
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if ((Integer)h.get(key) <= 0 || !this.needsEndtag(key)) continue;
                return key;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean needsEndtag(String tagName) {
        Vector<String> tags = this.applet.getTags();
        for (int i = 0; i < tags.size(); ++i) {
            String weTag = tags.get(i);
            String[] parts = weTag.split("/");
            if (!parts[0].equals(tagName)) continue;
            return parts[1].equals("true");
        }
        return false;
    }

    private boolean shouldShowAttribSuggestor() {
        boolean isOpenQuot;
        int spacePos = this.lineText.lastIndexOf(" ", this.caretPos - 1);
        int numQuotesBetweenStartTagAndCaret = 0;
        int quotPos = this.lineText.lastIndexOf("\"", this.caretPos - 1);
        while (quotPos > this.weStartTagStartPos) {
            ++numQuotesBetweenStartTagAndCaret;
            quotPos = this.lineText.lastIndexOf("\"", quotPos - 1);
        }
        boolean bl = isOpenQuot = numQuotesBetweenStartTagAndCaret % 2 != 0;
        if (this.cursorIsInWeStartTag() && spacePos > this.weStartTagStartPos && !isOpenQuot) {
            this.attribName = this.lineText.substring(spacePos + 1, this.caretPos);
            return true;
        }
        this.attribName = "";
        return false;
    }

    private boolean cursorIsInWeStartTag() {
        int firstWeTagStartPosBeforeCursor = this.lineText.lastIndexOf("<we:", this.caretPos - 4);
        int firstEndTagPosBeforeCursor = this.lineText.lastIndexOf(">", this.caretPos - 1);
        if (firstWeTagStartPosBeforeCursor != -1 && (firstEndTagPosBeforeCursor == -1 || firstEndTagPosBeforeCursor < firstWeTagStartPosBeforeCursor)) {
            this.weStartTagStartPos = firstWeTagStartPosBeforeCursor;
            return true;
        }
        this.weStartTagStartPos = -1;
        return false;
    }

    private boolean cursorIsInWeEndTag() {
        int firstWeTagStartPosBeforeCursor = this.lineText.lastIndexOf("</we:", this.caretPos - 5);
        int firstEndTagPosBeforeCursor = this.lineText.lastIndexOf(">", this.caretPos - 1);
        if (firstWeTagStartPosBeforeCursor != -1 && (firstEndTagPosBeforeCursor == -1 || firstEndTagPosBeforeCursor < firstWeTagStartPosBeforeCursor)) {
            this.weEndTagStartPos = firstWeTagStartPosBeforeCursor;
            return true;
        }
        this.weEndTagStartPos = -1;
        return false;
    }

    public void debug() {
        System.out.println("this.caretPos:" + this.caretPos);
        System.out.println("this.lineText:" + this.lineText);
    }

    public void hideSuggestors() {
        this.tSuggestor.hideSuggestor();
        this.aSuggestor.hideSuggestor();
    }

    public void handleArrowKeyDown(boolean doSelectFirst) {
        this.pane.setFocusable(false);
        if (this.tSuggestor.isVisible()) {
            this.tSuggestor.list.setFocusable(true);
            this.tSuggestor.list.requestFocus();
            if (doSelectFirst) {
                this.tSuggestor.list.setSelectedIndex(0);
            }
            this.tSuggestor.list.repaint();
        } else if (this.aSuggestor.isVisible()) {
            this.aSuggestor.list.setFocusable(true);
            this.aSuggestor.list.requestFocus();
            if (doSelectFirst) {
                this.aSuggestor.list.setSelectedIndex(0);
            }
            this.aSuggestor.list.repaint();
        }
    }
}

