/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.eplugin.editor;

import com.livinge.eplugin.editor.WeEditor;
import com.livinge.eplugin.privileged.PrivilegedSave;
import com.livinge.eplugin.registry.MacRegistry;
import com.livinge.eplugin.registry.WinRegistry;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WeSettings {
    private String buildVersion = "5.1_9";
    private String defRegistryCompanyDir = "living-e";
    private String defRegistryProductDir = "editorPlugin";
    private String defEditorFile = "editor.xml";
    private String defSettingsFile = "setting.xml";
    private String defCacheDir = "cache";
    public String registryDir;
    private String editorFile;
    private String settingsFile;
    public String cacheDir;
    public String lastContentType = "";
    private Hashtable ParamList = new Hashtable();
    private Hashtable Settings = new Hashtable();
    private Vector DefaultEditorList = new Vector();
    private Vector SystemEditorList = new Vector();
    private Vector ContentTypes = new Vector();
    private Vector ContentTypeIcons = new Vector();
    private URL HostUrl;
    private Properties PluginProperties;
    public String AppDir = new String("webEdition");

    public WeSettings() {
        this.ContentTypes.add("text/plain");
        this.ContentTypes.add("text/js");
        this.ContentTypes.add("text/css");
        this.ContentTypes.add("text/html");
        this.ContentTypes.add("text/xml");
        this.ContentTypes.add("text/webedition");
        this.ContentTypes.add("text/weTmpl");
        this.ContentTypes.add("image/*");
        this.ContentTypes.add("video/quicktime");
        this.ContentTypes.add("application/x-shockwave-flash");
        this.ContentTypes.add("application/*");
        this.ContentTypeIcons.add("link.gif");
        this.ContentTypeIcons.add("prog.gif");
        this.ContentTypeIcons.add("prog.gif");
        this.ContentTypeIcons.add("prog.gif");
        this.ContentTypeIcons.add("link.gif");
        this.ContentTypeIcons.add("we_dokument.gif");
        this.ContentTypeIcons.add("prog.gif");
        this.ContentTypeIcons.add("image.gif");
        this.ContentTypeIcons.add("film.gif");
        this.ContentTypeIcons.add("film.gif");
        this.ContentTypeIcons.add("link.gif");
        this.Settings.put("askForEditor", "true");
        this.PluginProperties = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream("eplugin.properties");
            this.PluginProperties.load(is);
        }
        catch (IOException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String OS = System.getProperty("os.name").toLowerCase();
        String appDataPath = "";
        String sep = System.getProperty("file.separator");
        if (OS.matches("mac os x")) {
            appDataPath = System.getProperty("user.home") + sep + "Library" + sep + "Application Support" + sep;
        } else if (OS.matches("windows(.)*")) {
            Process p = null;
            try {
                p = OS.indexOf("windows 9") > -1 ? Runtime.getRuntime().exec("command.com /c echo %APPDATA%") : Runtime.getRuntime().exec("cmd.exe /c echo %APPDATA%");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                appDataPath = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            appDataPath = appDataPath.length() == 0 ? System.getProperty("user.home") + sep + "Application Data" + sep : appDataPath + sep;
            System.out.println(appDataPath);
        } else {
            System.out.println("Only Mac OSX and Windows are supported by the editor plugin!");
        }
        this.registryDir = appDataPath + this.defRegistryCompanyDir + sep + this.defRegistryProductDir + sep;
        this.editorFile = this.registryDir + System.getProperty("file.separator") + this.defEditorFile;
        this.settingsFile = this.registryDir + System.getProperty("file.separator") + this.defSettingsFile;
        this.loadSettings();
    }

    public void createCache() {
        String host = this.HostUrl.getHost();
        this.cacheDir = this.registryDir + this.defCacheDir + System.getProperty("file.separator") + host + System.getProperty("file.separator");
        this.createDir(this.registryDir);
        this.createDir(this.cacheDir);
    }

    private boolean createDir(String dir) {
        boolean exists = new File(dir).exists();
        if (!exists) {
            return new File(dir).mkdirs();
        }
        return false;
    }

    public void addEditor(WeEditor Editor, Vector List2) {
        boolean found = false;
        for (WeEditor we : List2) {
            if (!Editor.Path.equals(we.Path)) continue;
            found = true;
        }
        if (!found) {
            List2.add(Editor);
        }
    }

    public void addToDefaultEditors(WeEditor editor) {
        this.addEditor(editor, this.DefaultEditorList);
    }

    public void setParam(String name, String value) {
        try {
            this.ParamList.put(name, value);
        }
        catch (NullPointerException e) {
            System.out.print("Missing param: " + name + "--" + value + "\n");
        }
    }

    public boolean isParam(String name) {
        String val = (String)this.ParamList.get(name);
        return val != null;
    }

    public String getParam(String name) {
        return (String)this.ParamList.get(name);
    }

    public void saveDefaultEditorList() {
        String out = "";
        out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.getProperty("line.separator");
        out = out + "<webEdition>" + System.getProperty("line.separator");
        for (int i = 0; i < this.DefaultEditorList.size(); ++i) {
            WeEditor editor = (WeEditor)this.DefaultEditorList.elementAt(i);
            out = out + editor.object2xml();
        }
        out = out + "</webEdition>" + System.getProperty("line.separator");
        PrivilegedSave pSave = new PrivilegedSave(this.editorFile, out, "UTF-8");
        AccessController.doPrivileged(pSave);
    }

    public void loadEditorList(String filename, String ct) {
        this.loadDefaultEditorList();
        this.loadSystemEditorList(filename, ct);
    }

    protected void loadSystemEditorList(String filename, String ct) {
        this.SystemEditorList.removeAllElements();
        int index = filename.lastIndexOf(46);
        if (index > -1) {
            String ext = filename.substring(index + 1);
            if (System.getProperty("os.name").matches("Mac OS X") || System.getProperty("os.name").matches("Windows(.)*")) {
                Vector appList = new Vector();
                if (System.getProperty("os.name").matches("Mac OS X")) {
                    MacRegistry mr = new MacRegistry(this);
                    appList = mr.getAppList(ext);
                }
                if (System.getProperty("os.name").matches("Windows(.)*")) {
                    WinRegistry wr = new WinRegistry();
                    appList = wr.getAppList(ext);
                }
                if (appList.size() > 0) {
                    WeEditor ed = new WeEditor();
                    Iterator i = appList.iterator();
                    while (i.hasNext()) {
                        String path = i.next().toString();
                        String name = new File(path).getName().replaceAll(".app", "");
                        ed = new WeEditor();
                        ed.init(name, path, "", ct, "", "");
                        this.addEditor(ed, this.SystemEditorList);
                    }
                }
            }
        }
    }

    protected void loadDefaultEditorList() {
        this.DefaultEditorList.removeAllElements();
        if (!new File(this.editorFile).exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(this.editorFile));
            NodeList childs = document.getFirstChild().getChildNodes();
            int childCount = childs.getLength();
            this.DefaultEditorList = new Vector();
            for (int i = 0; i < childCount; ++i) {
                Node node = childs.item(i);
                if (node.getNodeName() != "Editor") continue;
                NodeList editorProps = node.getChildNodes();
                String Name = new String();
                String Path2 = new String();
                String Args = new String();
                String ContentType = new String();
                String DefaultFor = new String();
                String Encoding = new String();
                for (int j = 0; j < editorProps.getLength(); ++j) {
                    try {
                        if (editorProps.item(j).getNodeName() == "Name") {
                            Name = editorProps.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        if (editorProps.item(j).getNodeName() == "Path") {
                            Path2 = editorProps.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        if (editorProps.item(j).getNodeName() == "Args") {
                            Args = editorProps.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        if (editorProps.item(j).getNodeName() == "ContentType") {
                            ContentType = editorProps.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        if (editorProps.item(j).getNodeName() == "DefaultFor") {
                            DefaultFor = editorProps.item(j).getFirstChild().getNodeValue();
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    try {
                        if (editorProps.item(j).getNodeName() != "Encoding") continue;
                        Encoding = editorProps.item(j).getFirstChild().getNodeValue();
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                if (Path2.equals("")) continue;
                WeEditor ed = new WeEditor();
                ed.init(Name, Path2, Args, ContentType, DefaultFor, Encoding);
                this.addEditor(ed, this.DefaultEditorList);
            }
        }
        catch (SAXException sxe) {
        }
        catch (ParserConfigurationException pce) {
        }
        catch (IOException ioe) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasContentType(String list, String ct) {
        if (ct.trim().equals("")) {
            return true;
        }
        if (list.trim().equals("")) {
            return false;
        }
        String[] arr = list.split(",");
        for (int i = 0; i < arr.length; ++i) {
            String it = arr[i].trim();
            if (it.length() <= 0 || !it.equals(ct)) continue;
            return true;
        }
        return false;
    }

    public void clearList() {
        this.DefaultEditorList.removeAllElements();
        this.DefaultEditorList = new Vector();
        this.saveDefaultEditorList();
    }

    public Vector getEditorList(String ct) {
        Vector edList = new Vector();
        for (WeEditor ed : this.DefaultEditorList) {
            if (ed.Path.equals("") || !this.hasContentType(ed.ContentType, ct)) continue;
            this.addEditor(ed, edList);
        }
        for (WeEditor ed : this.SystemEditorList) {
            if (ed.Path.equals("") || !this.hasContentType(ed.ContentType, ct)) continue;
            this.addEditor(ed, edList);
        }
        return edList;
    }

    public boolean editorExists(String path) {
        Vector edList = this.getEditorList("");
        for (int i = 0; i < edList.size(); ++i) {
            if (!((WeEditor)edList.elementAt((int)i)).Path.equals(path)) continue;
            return true;
        }
        return false;
    }

    public WeEditor getDefaultEditor(String ct) {
        for (WeEditor ed : this.DefaultEditorList) {
            String[] edarr = ed.DefaultFor.split(",");
            for (int j = 0; j < edarr.length; ++j) {
                String it = edarr[j].trim();
                if (it.length() <= 0 || !it.equals(ct)) continue;
                return ed;
            }
        }
        return null;
    }

    public WeEditor getEditorAt(int index) {
        Vector edList = this.getEditorList("");
        return (WeEditor)edList.elementAt(index);
    }

    public Vector getContentTypes() {
        return (Vector)this.ContentTypes.clone();
    }

    public void setUrl(String url) {
        try {
            this.HostUrl = new URL(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URL getUrl() {
        return this.HostUrl;
    }

    public void setAppDir(String app) {
        this.AppDir = app;
    }

    public String getAppDir() {
        return this.AppDir;
    }

    public String getHost() {
        return this.HostUrl.toExternalForm();
    }

    public void removeFromDefaultEditorList(WeEditor editor) {
        this.DefaultEditorList.removeElement(editor);
        this.saveDefaultEditorList();
    }

    public boolean isInDefaultEditorList(WeEditor editor) {
        for (WeEditor ed : this.DefaultEditorList) {
            if (!editor.Path.equals(ed.Path)) continue;
            return true;
        }
        return false;
    }

    public void replaceEditor(WeEditor editor) {
        int i = 0;
        int size = this.DefaultEditorList.size();
        for (i = 0; i < size; ++i) {
            WeEditor ed = (WeEditor)this.DefaultEditorList.elementAt(i);
            if (ed.Path.equals(editor.Path)) break;
        }
        if (i < size) {
            this.DefaultEditorList.setElementAt(editor, i);
        }
    }

    public void saveSettings() {
        String out = "";
        out = "<?xml version=\"1.0\"?>" + System.getProperty("line.separator");
        out = out + "<webEdition>" + System.getProperty("line.separator");
        Enumeration e = this.Settings.keys();
        while (e.hasMoreElements()) {
            out = out + "\t<Setting>" + System.getProperty("line.separator");
            String key = (String)e.nextElement();
            out = out + "\t\t<Name>" + key + "</Name>" + System.getProperty("line.separator");
            out = out + "\t\t<Value>" + this.Settings.get(key) + "</Value>" + System.getProperty("line.separator");
            out = out + "\t</Setting>" + System.getProperty("line.separator");
        }
        out = out + "</webEdition>" + System.getProperty("line.separator");
        PrivilegedSave pSave = new PrivilegedSave(this.settingsFile, out);
        AccessController.doPrivileged(pSave);
    }

    public void loadSettings() {
        block13: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                File sFile = new File(this.settingsFile);
                if (!sFile.exists()) {
                    sFile.getParentFile().mkdirs();
                    sFile.createNewFile();
                    break block13;
                }
                if (sFile.length() <= 0L) break block13;
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(sFile);
                NodeList childs = document.getFirstChild().getChildNodes();
                int childCount = childs.getLength();
                for (int i = 0; i < childCount; ++i) {
                    Node node = childs.item(i);
                    if (node.getNodeName() != "Setting") continue;
                    NodeList settingProps = node.getChildNodes();
                    String Name = new String();
                    String Value = new String();
                    for (int j = 0; j < settingProps.getLength(); ++j) {
                        try {
                            if (settingProps.item(j).getNodeName() == "Name") {
                                Name = settingProps.item(j).getFirstChild().getNodeValue();
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            if (settingProps.item(j).getNodeName() != "Value") continue;
                            Value = settingProps.item(j).getFirstChild().getNodeValue();
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    if (Name.equals("")) continue;
                    this.Settings.put(Name, Value);
                }
            }
            catch (SAXException sxe) {
            }
            catch (ParserConfigurationException pce) {
            }
            catch (IOException ioe) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setSetting(String name, String value) {
        try {
            this.Settings.put(name, value);
        }
        catch (NullPointerException e) {
            System.out.print("Missing setting: " + name + "--" + value + "\n");
        }
    }

    public String getSetting(String name) {
        return (String)this.Settings.get(name);
    }

    public static String getDefaultEncoding() {
        return new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding().replaceFirst("Cp", "windows-");
    }

    public static boolean isCharsetSupported(String charset) {
        try {
            return Charset.isSupported(charset);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getVersion() {
        return this.buildVersion;
    }
}

