/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.eplugin.gui;

import com.livinge.eplugin.editor.WeEditor;
import com.livinge.eplugin.editor.WeSettings;
import com.livinge.eplugin.gui.EPEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class EPPropDialog
extends JFrame
implements ActionListener {
    static final long serialVersionUID = -1611200117062004003L;
    private WeSettings weSettings;
    private JTextField nameText;
    private JTextField pathText;
    private JTextField argsText;
    private JTextField contentTypeText;
    private JTextField defaultForText;
    private JButton cancelButton;
    private JButton saveButton;
    private JButton pathButton;
    private JComboBox contentTypeBox;
    private JComboBox defaultForBox;
    private JComboBox encodingBox;
    private EPEditorDialog parentFrame;

    public EPPropDialog(WeSettings wesettings, WeEditor editor, EPEditorDialog parent) {
        this.weSettings = wesettings;
        this.parentFrame = parent;
        String Name = "";
        String Path2 = "";
        String Args = "";
        String ContentType = "";
        String DefaultFor = "";
        String Encoding = WeSettings.getDefaultEncoding();
        Name = editor.Name;
        Path2 = editor.Path;
        Args = editor.Args;
        ContentType = editor.ContentType == null ? this.weSettings.lastContentType : editor.ContentType;
        DefaultFor = editor.DefaultFor;
        Encoding = editor.Encoding;
        EmptyBorder eb = new EmptyBorder(10, 10, 10, 10);
        CompoundBorder cb = new CompoundBorder(eb, BorderFactory.createEtchedBorder());
        int textFieldSize = 32;
        this.nameText = new JTextField(Name, textFieldSize);
        JLabel nameLabel = new JLabel(this.weSettings.getParam("lan_editor_name"));
        this.pathText = new JTextField(Path2, textFieldSize);
        JLabel pathLabel = new JLabel(this.weSettings.getParam("lan_path"));
        this.pathButton = new JButton("...");
        this.pathButton.addActionListener(this);
        this.argsText = new JTextField(Args, textFieldSize);
        JLabel argsLabel = new JLabel(this.weSettings.getParam("lan_args"));
        JPanel namePane = new JPanel();
        namePane.setLayout(new BoxLayout(namePane, 0));
        namePane.add(this.nameText);
        JPanel pathPane = new JPanel();
        pathPane.setLayout(new BoxLayout(pathPane, 0));
        pathPane.add(this.pathText);
        pathPane.add(this.pathButton);
        JPanel argsPane = new JPanel();
        argsPane.setLayout(new BoxLayout(argsPane, 0));
        argsPane.add(this.argsText);
        Vector contentTypes = new Vector();
        contentTypes = this.weSettings.getContentTypes();
        contentTypes.insertElementAt("", 0);
        this.contentTypeText = new JTextField(ContentType, textFieldSize);
        this.contentTypeText.setText(ContentType);
        this.contentTypeBox = new JComboBox(contentTypes);
        this.contentTypeBox.setPreferredSize(new Dimension(200, 10));
        this.contentTypeBox.addActionListener(this);
        JLabel contentTypeLabel = new JLabel(this.weSettings.getParam("lan_contenttypes"));
        JPanel contentTypePane = new JPanel();
        contentTypePane.setLayout(new BoxLayout(contentTypePane, 0));
        contentTypePane.add(this.contentTypeText);
        contentTypePane.add(Box.createRigidArea(new Dimension(5, 0)));
        contentTypePane.add(this.contentTypeBox);
        this.defaultForText = new JTextField(DefaultFor, textFieldSize);
        this.defaultForBox = new JComboBox();
        this.defaultForBox.setPreferredSize(new Dimension(200, 10));
        this.addItems(this.defaultForBox, "," + ContentType);
        this.defaultForBox.addActionListener(this);
        JLabel defaultForBoxLabel = new JLabel(this.weSettings.getParam("lan_defaultfor_label"));
        JPanel defaultForPane = new JPanel();
        defaultForPane.setLayout(new BoxLayout(defaultForPane, 0));
        defaultForPane.add(this.defaultForText);
        defaultForPane.add(Box.createRigidArea(new Dimension(5, 0)));
        defaultForPane.add(this.defaultForBox);
        this.encodingBox = new JComboBox();
        this.encodingBox.setPreferredSize(new Dimension(200, 10));
        Vector<Charset> supportedEnc = new Vector<Charset>(Charset.availableCharsets().values());
        supportedEnc.insertElementAt((Charset)((Object)""), 0);
        this.encodingBox = new JComboBox<Charset>(supportedEnc);
        String s = "";
        int count = -1;
        Iterator<Charset> it = supportedEnc.iterator();
        while (it.hasNext()) {
            if (s.equals(Encoding)) {
                this.encodingBox.setSelectedIndex(count);
                break;
            }
            ++count;
            s = ((Object)it.next()).toString();
        }
        this.encodingBox.addActionListener(this);
        JPanel encodingPane = new JPanel();
        encodingPane.setLayout(new BoxLayout(encodingPane, 0));
        encodingPane.add(this.encodingBox);
        JLabel encodingLabel = new JLabel(this.weSettings.getParam("lan_encoding"));
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BorderLayout());
        mainPane.setBorder(cb);
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new BoxLayout(centerPane, 3));
        centerPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 15));
        centerPane.setAlignmentY(0.0f);
        nameLabel.setAlignmentX(0.0f);
        namePane.setAlignmentX(0.0f);
        pathLabel.setAlignmentX(0.0f);
        pathPane.setAlignmentX(0.0f);
        argsLabel.setAlignmentX(0.0f);
        argsPane.setAlignmentX(0.0f);
        contentTypeLabel.setAlignmentX(0.0f);
        contentTypePane.setAlignmentX(0.0f);
        defaultForPane.setAlignmentX(0.0f);
        encodingPane.setAlignmentX(0.0f);
        centerPane.add(Box.createRigidArea(new Dimension(10, 10)));
        centerPane.add(nameLabel);
        centerPane.add(namePane);
        centerPane.add(Box.createRigidArea(new Dimension(10, 10)));
        centerPane.add(pathLabel);
        centerPane.add(pathPane);
        centerPane.add(argsLabel);
        centerPane.add(argsPane);
        centerPane.add(Box.createRigidArea(new Dimension(10, 10)));
        centerPane.add(contentTypeLabel);
        centerPane.add(contentTypePane);
        centerPane.add(Box.createRigidArea(new Dimension(10, 10)));
        centerPane.add(defaultForBoxLabel);
        centerPane.add(defaultForPane);
        centerPane.add(Box.createRigidArea(new Dimension(10, 10)));
        centerPane.add(encodingLabel);
        centerPane.add(encodingPane);
        mainPane.add((Component)centerPane, "Center");
        this.cancelButton = new JButton(this.weSettings.getParam("lan_close_button"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setAlignmentX(1.0f);
        this.saveButton = new JButton(this.weSettings.getParam("lan_save_button"));
        this.saveButton.addActionListener(this);
        this.saveButton.setAlignmentX(1.0f);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.saveButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.cancelButton);
        box.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 10));
        this.getContentPane().add((Component)mainPane, "North");
        this.getContentPane().add((Component)box, "South");
        int windowHeight = 320;
        int windowWidth = 320;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = windowWidth + 10;
        int h = windowHeight + 10;
        this.setLocation(screenSize.width / 3 - w / 2, screenSize.height / 2 - h / 2);
        this.setSize(w, h);
        this.setTitle(this.weSettings.getParam("lan_editor_prop"));
        this.setResizable(false);
    }

    private void addItems(JComboBox combo, String items) {
        String[] arr = items.split(",");
        for (int i = 0; i < arr.length; ++i) {
            String it = arr[i].trim();
            if (this.hasItem(combo, it)) continue;
            combo.addItem(new String(it));
        }
    }

    private boolean hasItem(JComboBox combo, String item) {
        int c = this.defaultForBox.getItemCount();
        for (int i = 0; i < c; ++i) {
            String s = (String)combo.getItemAt(i);
            if (!s.equals(item)) continue;
            return true;
        }
        return false;
    }

    private boolean inList(String list, String item) {
        String[] arr = list.split(",");
        for (int i = 0; i < arr.length; ++i) {
            String it = arr[i].trim();
            if (!item.equals(it)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        String text;
        JFileChooser fileSelector;
        int returnVal;
        if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
        if (e.getSource() == this.pathButton && (returnVal = (fileSelector = new JFileChooser()).showOpenDialog(this.pathButton.getParent())) == 0) {
            String selected = fileSelector.getSelectedFile().getPath();
            this.pathText.setText(selected);
        }
        if (e.getSource() == this.contentTypeBox) {
            String selected;
            text = this.contentTypeText.getText();
            if (!this.inList(text, selected = (String)this.contentTypeBox.getSelectedItem()) && !selected.matches("")) {
                text = !text.matches("") ? text + "," + selected : selected;
                this.addItems(this.defaultForBox, text);
                this.contentTypeText.setText(text);
            }
            this.contentTypeBox.setSelectedItem("");
        }
        if (e.getSource() == this.defaultForBox) {
            String selected;
            text = this.defaultForText.getText();
            if (!this.inList(text, selected = (String)this.defaultForBox.getSelectedItem()) && !selected.matches("")) {
                text = !text.matches("") ? text + "," + selected : selected;
                this.defaultForText.setText(text);
            }
            this.defaultForBox.setSelectedItem("");
        }
        if (e.getSource() == this.saveButton) {
            WeEditor editor = new WeEditor();
            Object enc = this.encodingBox.getSelectedItem();
            editor.init(this.nameText.getText(), this.pathText.getText(), this.argsText.getText(), this.contentTypeText.getText(), this.defaultForText.getText(), enc != null ? enc.toString() : "");
            if (this.weSettings.isInDefaultEditorList(editor)) {
                this.weSettings.replaceEditor(editor);
            } else {
                this.weSettings.addToDefaultEditors(editor);
            }
            this.weSettings.saveDefaultEditorList();
            this.dispose();
            this.parentFrame.reloadEditorList();
        }
    }
}

