<?php
/**
 * webEdition CMS
 *
 * This source is part of webEdition CMS. webEdition CMS is
 * free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * The GNU General Public License can be found at
 * http://www.gnu.org/copyleft/gpl.html.
 * A copy is found in the textfile
 * webEdition/licenses/webEditionCMS/License.txt
 *
 * @category   webEdition
 * @package    webEdition_language
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL
 */

$l_we_tag['a']['description'] = "Das we:a-Tag erzeugt ein HTML-Link-Tag, das auf ein webEdition-internes Dokument mit der unten angegebenen ID verweist. Der gesamte Inhalt zwischen Start- und Endtag wird verlinkt.";
$l_we_tag['a']['defaultvalue'] = "";
$l_we_tag['addDelNewsletterEmail']['description'] = "Dieses Tag erzeugt, schreibt oder entfernt eine Email aus der Newsletter-Empf&auml;nger-Liste. Die Empf&auml;nger-Listen werden als CSV-Datei gespeichert und k&ouml;nnen dann beim Versand im Newslettermodul verwendet werden.";
$l_we_tag['addDelShopItem']['description'] = "Das we:addDelShopItem-Tag erm&ouml;glicht das Hinzuf&uuml;gen oder Wegnehmen eines Artikels aus dem Warenkorb.";
$l_we_tag['addPercent']['description'] = "Das we:addPercent-Tag erm&ouml;glicht das Addieren eines gewissen Prozentsatzes, beispielsweise f&uuml;r die Mehrwertsteuer.";
$l_we_tag['addPercent']['defaultvalue'] = "";
$l_we_tag['answers']['description'] = "Dieses Tag dient der Ausgabe der Antwortm&ouml;glichkeiten eines Votings.";
$l_we_tag['answers']['defaultvalue'] = "";
$l_we_tag['author']['description'] = "Das we:author-Tag dient dazu, um den Autor der Seite anzuzeigen. Ist das Attribut 'type' nicht gesetzt, wird der Benutzername angezeigt. Wenn type=\"name\" ist, dann wird der Vor- und Nachname des Benutzers angezeigt. Ist 'type=\"initials\", dann werden die Initialen des Benutzers angezeigt. Ist kein Vor- und Nachname eingetragen, wird immer der Benutzername angezeigt.";
$l_we_tag['back']['description'] = "Das we:back-Tag erzeugt ein HTML-Link-Tag, das auf die vorherige we:listview-Seite verweist. Der gesamte Inhalt zwischen Start- und Endtag wird verlinkt.";
$l_we_tag['back']['defaultvalue'] = "";
$l_we_tag['banner']['description'] = "Mit dem Tag wird der Werbebanner des Banner Moduls eingebunden.";
$l_we_tag['bannerSelect']['description'] = "Mit diesem Tag wird ein DropDown-Men&uuml; (&lt;select&gt;) erzeugt, um Werbebanner auszuw&auml;hlen. Wenn customer auf true gesetzt ist (bei installierter Kundenverwaltung), werden nur die Banner des eingeloggten Kunden angezeigt.";
$l_we_tag['bannerSum']['description'] = "Das we:bannerSum-Tag gibt die Anzahl aller gezeigten oder geklickten Banner oder deren Klick-Rate aus. Das Tag funktioniert nur innerhalb einer listview mit type=\"banner\"!";
$l_we_tag['block']['description'] = "Mit dem we:block-Tag kann man erweiterbare Bl&ouml;cke/Listen erzeugen. Alles, was zwischen Start- und Endtag steht, wird im Bearbeitungsmodus durch einen Klick auf den Plus-Button angeh&auml;ngt, bzw. eingef&uuml;gt. Dies k&ouml;nnen beliebiges HTML sowie fast alle we:tags sein.";
$l_we_tag['block']['defaultvalue'] = "";
$l_we_tag['calculate']['description'] = "Das we:calculate-Tag erlaubt alle m&ouml;glichen mathematischen Operationen. (*, /, +, -,(), sqrt.....)";
$l_we_tag['calculate']['defaultvalue'] = "";
$l_we_tag['captcha']['description'] = "Dieses Tag dient dazu, ein Bild mit einem Zufallscode zu generieren.";
$l_we_tag['category']['description'] = "Das we:category Tag wird durch die Kategorie(n) ersetzt, die in der Ansicht \"Eigenschaft\" dem Dokument zugeordnet wurden. Wenn es mehrere Kategorien sind, werden sie durch Kommas getrennt. Wenn Sie ein anderes Trennzeichen verwenden m&ouml;chten, k&ouml;nnen Sie dies mit dem Attribut \"delimiter\" zuweisen. Bsp.: delimiter = \" \" (Hier wird ein Leerzeichen verwendet um die Kategorien zu trennen.)";
$l_we_tag['categorySelect']['description'] = "Mit diesem Tag wird ein DropDown-Men&uuml; (&lt;select&gt;) erzeugt, um Kategorien auszuw&auml;hlen. Wenn man gleich nach dem Starttag das Endtag setzt, dann werden automatisch alle in webEdition definierten Kategorien angezeigt.";
$l_we_tag['categorySelect']['defaultvalue'] = "";
$l_we_tag['charset']['description'] = "Das Tag we:charset generiert eine Meta-Angabe, die bestimmt mit welchem Zeichensatz die fertige Seite angezeigt wird. F&uuml;r deutsche Seiten wird normalerweise der Zeichensatz \"ISO-8859-15\" verwendet. Dieser Tag muss innerhalb der &lt;head&gt;&lt;/head&gt; Tags der HTML-Seite stehen.";
$l_we_tag['charset']['defaultvalue'] = "";
$l_we_tag['checkForm']['description'] = "Das Tag we:checkForm f&uuml;hrt eine Validierung eines Formulars per JavaScript durch. <br />Die Kombination der Parameter 'match' und 'type' legen den 'name',bzw. die 'id' des zu kontrollierenden Formulars fest.<br />'mandatory' und 'email' erwarten eine kommaseparierte Liste von Pflichtfeldern, bzw. Email-Adressen(Syntax-Check). In 'password' k&ouml;nnen kommasepariert 2 Feldnamen und eine Mindestl&auml;nge eingegeben werden, die auf Gleichheit, bzw die Mindestl&auml;nge &uuml;berpr&uuml;ft weden.<br />Mit onError kann im Fehlerfall eine eigene JavaScript-Funktion aufgerufen werden, die als Parameter arrays mit fehlenden Pflichtfeldern und den invaliden Email-Adressen erh&auml;lt, als dritter Parameter wird ein Flag &uuml;bergeben, ob die Passworteingabe korrekt war. Andernfalls wird der Standardwert im Fehlerfall ausgegeben.";
$l_we_tag['checkForm']['defaultvalue'] = "";
$l_we_tag['colorChooser']['description'] = "Das we:colorChooser Tag erzeugt ein Eingabefeld um Farbwerte auszuw&auml;hlen";
$l_we_tag['condition']['description'] = "Mit diesem Tag kann man in Verbindung mit &lt;we:conditionAdd&gt; f&uuml;r das Attribut condition bei &lt;we:listviews type=\"object\"&gt; eine Bedingung dynamisch erzeugen. Es ist zudem m&ouml;glich &lt;we:condition&gt; ineinander zu verschachteln, wenn man z. B. ODER und UND Verkn&uuml;pfungen miteinander mischen m&ouml;chte.";
$l_we_tag['condition']['defaultvalue'] = "&lt;we:conditionAdd field=\"Type\" var=\"type\" compare=\"=\"/&gt;";
$l_we_tag['conditionAdd']['description'] = "Dieses Tag f&uuml;gt der mit &lt;we:condition&gt; eingeleiteten Bedingung eine neue Regel/Vergleich hinzu.";
$l_we_tag['conditionAnd']['description'] = "Dieses Tag verkn&uuml;pft Regeln/Vergleiche mit anderen Regeln/Vergleichen innerhalb von &lt;we:condition&gt; mit einer UND Verkn&uuml;pfung. Beide Regeln/Vergleiche m&uuml;ssen erf&uuml;llt sein, damit die Bedingung wahr (true) wird.";
$l_we_tag['conditionOr']['description'] = "Dieses Tag verkn&uuml;pft Regeln/Vergleiche mit anderen Regeln/Vergleichen innerhalb von &lt;we:condition&gt; mit einer OR Verkn&uuml;pfung. Eine der beiden Regeln/Vergleiche mu&szlig; erf&uuml;llt sein, damit die Bedingung wahr (true) wird.";
$l_we_tag['content']['description'] = "&lt;we:content /&gt; wird nur innerhalb einer Hauptvorlage eingesetzt. Es markiert die Fl&auml;che, in die der Inhalt der Detailvorlage innerhalb der Hauptvorlage eingebunden wird.";
$l_we_tag['controlElement']['description'] = "Mit dem Tag we:controlElement k&ouml;nnen Schaltfl&auml;chen in der Bearbeiten-Ansicht eines Dokuments gezielt manipuliert werden. Buttons k&ouml;nnen ausgeblendet werden. Checkboxen k&ouml;nnen aktiviert, disabled und/oder versteckt werden.";
$l_we_tag['cookie']['description'] = "Dieser Tag wird vom Voting Modul ben&ouml;tigt und setzt einen Cookie, der Mehrfachabstimmungen eines Besuchers verhindert. Der Tag muss ganz am Anfang der Vorlage stehen, es d&uuml;rfen sich keine Zeichen (inkl. Leerzeichen und Zeilenumbruch) vor diesem Tag befinden.";
$l_we_tag['createShop']['description'] = "Das we:createShop-Tag wird auf jeder Seite ben&ouml;tigt, die Shop-Daten enthalten soll.";
$l_we_tag['css']['description'] = "Das we:css-Tag erzeugt ein HTML-Tag, das auf ein webEdition-internes CSS Stylesheet mit der unten angegebenen ID verweist. Dadurch k&ouml;nnen Sie Stylesheets in einer separaten Datei definieren.";
$l_we_tag['customer']['description'] = "Mit Hilfe dieses Tags kann man einen Kunden auf einer webEdition darstellen. Die Kundenfelder werden wie bei einer Listview und beim &lt;we:object&gt; Tag mit dem Tag &lt;we:field&gt; dargestellt.<br /><br />Durch Kombination der Attribute kann das Tag 3 verschiedene Funktionen erf&uuml;llen:<br />Wenn name gesetzt ist, dann kann der Redakteur einen Kunden per Customer-Selector ausw&auml;hlen. Dieser Kunde wird dann im Dokument unter dem in nam angegeben Feld gespeichert.<br />Wenn name nicht gesetzt ist, daf&uuml;r aber id, wird der Kunde mit dieser ID angezeigt<br />Wenn weder name noch id gesetzt ist, erwartet das Tag, dass die id des Kunden per Request Parameter &uuml;bermittelt wird. Dies tut zB. die Customer-Listview wenn das Attribut hyperlink=\"true\" im &lt;we:field&gt; Tag gesetzt ist. Der Name des Request Parameters lautet we_cid";
$l_we_tag['customer']['defaultvalue'] = "";
$l_we_tag['date']['description'] = "Das we:date-Tag zeigt, entsprechend dem Formatstring, das aktuelle Datum auf der Seite an. Wenn das Dokument statisch gespeichert wird, sollte der Typ auf &quot;js&quot; gesetzt werden, damit das Datum mit Javascript erzeugt wird.";
$l_we_tag['dateSelect']['description'] = "Das we:dateSelect-Tag gibt ein Auswahlfeld f&uuml;r ein Datum zur&uuml;ck, welches im Zusammenhang mit dem Tag we:processDateSelect in eine Variable als Unix Timestamp eingelesen werden kann.";
$l_we_tag['delete']['description'] = "Dieses Tag dient dazu, webEdition-Dokumente bzw. Objekte die &uuml;ber &lt;we:a edit=\"true\" delete=\"true\"&gt; aufgerufen wurden, zu l&ouml;schen.<br /><br />ACHTUNG: Dieses Tag sollte nur in Verbindung mit der Kundenverwaltung und den Attributen admin bzw. userid und/oder mit den Attributen doctype, pid und classid benutzt werden. Ansonsten ist es theoretisch m&ouml;glich, dass Unbefugte mit Aufruf des entsprechenden URL webEdition-Dokumente bzw. Objekte l&ouml;schen k&ouml;nnen.";
$l_we_tag['deleteShop']['description'] = "Das we:deleteShop-Tag l&ouml;scht den kompletten Warenkorb.";
$l_we_tag['description']['description'] = "Das we:description-Tag erzeugt ein description Meta-Tag. Falls das Beschreibungsfeld in der Ansicht \"Eigenschaften\" leer ist, wird der Inhalt zwischen Start- und Endtag als Standardbeschreibung eingetragen.";
$l_we_tag['description']['defaultvalue'] = "";
$l_we_tag['DID']['description'] = "Dieses Tag gibt die ID eines webEdition-Dokuments zur&uuml;ck.";
$l_we_tag['docType']['description'] = "Dieses Tag gibt den Dokumenttyp eines webEdition-Dokuments zur&uuml;ck.";
$l_we_tag['else']['description'] = "Dieses Tag leitet die Alternative ein, wenn die Bedingung eines if-Tags (z. B. &lt;we:ifEditmode&gt;, &lt;we:ifNotVar&gt;, &lt;we:ifNotEmpty&gt;, &lt;we:ifFieldNotEmpty&gt;, ) nicht zutrifft.";
$l_we_tag['field']['description'] = "Das we:field-Tag wird ben&ouml;tigt, um den Inhalt eines Datenbankfeldes des zugeh&ouml;rigen Listview-Eintrages anzuzeigen. Das we:field-Tag darf nur innerhalb des we:repeat Start- und Endtags stehen.";
$l_we_tag['flashmovie']['description'] = "Das we:flashmovie-Tag dient dazu, einen Flash Movie in den Inhalt des Dokumentes einzubauen. Im Bearbeitungsmodus eines Dokumentes, das diese Vorlage zugrunde liegen hat, ist ein Button \"bearbeiten\" sichtbar. Durch Anklicken dieses Buttons &ouml;ffnet sich ein Dateimanager, in dem man einen Flash Movie, der zuvor in webEdition angelegt wurde, ausw&auml;hlen kann.";
$l_we_tag['form']['description'] = "Das we:form Tag wird f&uuml;r Such- und Mailformulare eingesetzt. Es funktioniert wie das normale HTML-Form-Tag, jedoch werden zus&auml;tzliche Hidden-Fields vom Parser eingef&uuml;gt.";
$l_we_tag['form']['defaultvalue'] = "";
$l_we_tag['formfield']['description'] = "Dieses Tag dient zum Anlegen und Bearbeiten von Formularfeldern.";
$l_we_tag['formmail']['description'] = "Bei eingeschalteter Einstellung Formmail &uuml;ber webEdition-Dokument aufrufen, erfolgt die Einbindung des Formmail-Scripts &uuml;ber ein webEdition-Dokument. Hierf&uuml;r wird der neue (derzeit noch parameterlose) we-Tag formmail verwendet.<br />Wird die Captcha-Pr&uuml;fung eingesetzt, steht &lt;we:formmail/&gt; innerhalb des we-Tags ifCaptcha.";
$l_we_tag['hidden']['description'] = "Das we:hidden-Tag erzeugt ein hidden-input-Tag, mit den Inhalt der  gleichnamigen globalen PHP-Variablen. Dieses Tag wird normalerweise gebraucht, um eingehende Variablen weiterzuleiten.";
$l_we_tag['hidePages']['description'] = "Das we:hidePages-Tag erm&ouml;glicht es, bestimmte Modi eines Dokuments zu deaktivieren. Dieses Tag kann dazu eingesetzt werden, um den Zugriff auf die Eigenschaftsseite eines Dokuments zu verhindern. Dadurch kann dieses Dokument bspw. nicht mehr geparkt werden.";
$l_we_tag['href']['description'] = "Das we:href-Tag erzeugt eine Url, welche im Editmodus eingegeben werden kann.";
$l_we_tag['icon']['description'] = "Das we:icon-Tag erzeugt ein HTML-Tag, das auf ein webEdition internes Icon mit der unten angegebenen ID verweist. Dadurch k&ouml;nnen Sie ein Icon einbinden, welches beim Bookmarken Ihrer Homepage im Internet Explorer, Mozilla, Safari und Opera angezeigt wird.<br /><br />Bitte beachten Sie: Die Icon Datei sollte den Dateinamen \"favicon.ico\" haben und m&ouml;glichst direkt im Document-Root liegen.";
$l_we_tag['ifBack']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn es bei einer Listview auch eine vorherige Seite gibt. Gibt es keine vorherige Seite f?r die Listview, dann wird der umschlossene Inhalt nicht angezeigt.";
$l_we_tag['ifBack']['defaultvalue'] = "";
$l_we_tag['ifCaptcha']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen bzw. auszuf&uuml;hren, wenn der vom User eingegebene Code g&uuml;ltig ist.";
$l_we_tag['ifCaptcha']['defaultvalue'] = "";
$l_we_tag['ifCat']['description'] = "Das we:ifCat-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn die in \"categories\" eingetragenen Kategorien dem Dokument zugewiesen wurden.";
$l_we_tag['ifCat']['defaultvalue'] = "";
$l_we_tag['ifNotCat']['description'] = "Das we:ifNotCat-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn die in \"categories\" eingetragenen Kategorien nicht dem Dokument zugewiesen wurden.";
$l_we_tag['ifNotCat']['defaultvalue'] = "";
$l_we_tag['ifClient']['description'] = "Das we:ifClient-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn der Client (Browser) den vorgegebenen Anforderungen entspricht. Dieses Tag funktioniert nur bei dynamisch abgespeicherten Seiten!";
$l_we_tag['ifClient']['defaultvalue'] = "";
$l_we_tag['ifConfirmFailed']['description'] = "Nutzt man DoubleOptIn bei der Anmeldung zum Newslettermodul, kann mit &lt;we:ifConfirmFailed&gt; &uuml;berpr&uuml;ft werden, ob die gegebene E-Mail Adresse best&auml;tigt werden konnte.";
$l_we_tag['ifConfirmFailed']['defaultvalue'] = "";
$l_we_tag['ifCurrentDate']['description'] = "Dieses Tag highlighted den aktuellen Tag innerhalb einer Calendar-listview.";
$l_we_tag['ifCurrentDate']['defaultvalue'] = "";
$l_we_tag['ifDeleted']['description'] = "Dieses Tag dient dazu, um webEdition-Dokumente bzw. Objekte die &uuml;ber &lt;we:a edit=\"true\" delete=\"true\"&gt; aufgerufen wurden zu l&ouml;schen.&lt;br&gt;&lt;br&gt;&lt;strong&gt;ACHTUNG: Dieses Tag sollte nur in Verbindung mit der Kundenverwaltung und den Attributen admin bzw. userid und/oder mit den Attributen doctype, pid und classid benutzt werden. Ansonsten ist es theoretisch m&ouml;glich, dass Unbefugte mit Aufruf des entsprechenden URL webEdition-Dokumente bzw. Objekte l&ouml;schen k&ouml;nnen.&lt;/strong&gt;";
$l_we_tag['ifDeleted']['defaultvalue'] = "";
$l_we_tag['ifDoctype']['description'] = "Das we:ifDoctype-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn der in \"doctype\" eingetragene Dokument-Typ dem Dokument zugewiesen wurde.";
$l_we_tag['ifDoctype']['defaultvalue'] = "";
$l_we_tag['ifDoubleOptIn']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn es sich um den ersten Schritt eines Double Opt-In handelt.";
$l_we_tag['ifDoubleOptIn']['defaultvalue'] = "";
$l_we_tag['ifEditmode']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur innerhalb des Edit-Modus anzuzeigen.";
$l_we_tag['ifEditmode']['defaultvalue'] = "";
$l_we_tag['ifEmailExists']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn eine bestimmte E-Mail-Adresse bereits in der Newsletter-Adressliste vorhanden ist.";
$l_we_tag['ifEmailExists']['defaultvalue'] = "";
$l_we_tag['ifEmailInvalid']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn eine bestimmte E-Mail-Adresse syntaktisch falsch ist.";
$l_we_tag['ifEmailInvalid']['defaultvalue'] = "";
$l_we_tag['ifEmailNotExists']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn eine bestimmte E-Mail-Adresse noch nicht in der Newsletter-Adressliste vorhanden ist.";
$l_we_tag['ifEmailNotExists']['defaultvalue'] = "";
$l_we_tag['ifEmpty']['description'] = "Das we:ifEmpty-Tag bewirkt, dass alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn das Feld, das den in \"match\" eingetragenen Namen hat, leer ist. Im Attribut \"type\" muss der Typ des Feldes angegeben werden, wenn es sich um ein \"img\", \"flashmovie\" oder \"href\" Feld handelt.";
$l_we_tag['ifEmpty']['defaultvalue'] = "";
$l_we_tag['ifEqual']['description'] = "Das we:ifEqual-Tag vergleicht den Inhalt der beiden Felder \"name\" und \"eqname\". Ist der Inhalt der Felder gleich, wird alles, was zwischen Start- und Endtag steht, dargestellt. Wird das Tag innerhalb von we:list, we:block oder we:linklist benutzt, kann nur ein Feld innerhalb dieser Tags mit einem Feld au&szlig;erhalb verglichen werden. In diesem Fall m&uuml;ssen Sie im Attribut \"name\" den Namen des Feldes innerhalb der we:block, we:list oder we:linklist Tags benutzen. Im Attribut eqname mu&szlig; dann der Name eines Feldes au&szlig;erhalb der Tags benutzt werden. Ebenso kann sich das Tag innerhalb von dynamisch includierten webEdition-Seiten befinden. In diesem Fall wird in \"name\" ein Feld innerhalb der includierten Seite angegeben und in \"eqname\" der Name eines Feldes auf der Hauptseite. Wenn im Attribut \"value\" etwas eingetragen ist, wird \"eqname\" ignoriert und es wird mit dem in \"value\" eingetragenen Wert verglichen.";
$l_we_tag['ifEqual']['defaultvalue'] = "";
$l_we_tag['ifFemale']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt innerhalb eines Newsletters nur dann anzuzeigen, wenn die weibliche Anrede angezeigt werden soll.";
$l_we_tag['ifFemale']['defaultvalue'] = "";
$l_we_tag['ifField']['description'] = "Das we:ifField-Tag wird ben&ouml;tigt, um den umschlossenen Inhalt nur dann anzuzeigen, wenn der Wert des Datenbankfeldes des zugeh&ouml;rigen Listview-Eintrages gleich dem Wert des Attributes \"match\" ist. Das we:ifField-Tag darf nur innerhalb des we:repeat Start- und Endtags stehen.";
$l_we_tag['ifField']['defaultvalue'] = "";
$l_we_tag['ifFieldEmpty']['description'] = "Das we:ifFieldEmpty-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn das Feld einer we:listview, das den in \"match\" eingetragenen Namen hat, leer ist. Im Attribut \"type\" muss der Typ des Feldes angegeben werden, wenn es sich um ein \"img\", \"flashmovie\" oder \"href\" Feld handelt.";
$l_we_tag['ifFieldEmpty']['defaultvalue'] = "";
$l_we_tag['ifFieldNotEmpty']['description'] = "Das we:ifFieldNotEmpty-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn das Feld einer we:listview, das den in \"match\" eingetragenen Namen hat,  nicht leer ist. Im Attribut \"type\" muss der Typ des Feldes angegeben werden, wenn es sich um ein \"img\", \"flashmovie\" oder \"href\" Feld handelt.";
$l_we_tag['ifFieldNotEmpty']['defaultvalue'] = "";
$l_we_tag['ifFound']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn bei einer &lt;we:listview&gt; Eintr&auml;ge gefunden werden.";
$l_we_tag['ifFound']['defaultvalue'] = "";
$l_we_tag['ifHasChildren']['description'] = "Innerhalb des we:repeat Tags kann mit &lt;we:ifHasChildren&gt; abgefragt werden, ob der aktuelle Kategorie-Ordner Kategorien enth&auml;lt bzw. die Kategorie Kinder hat.";
$l_we_tag['ifHasChildren']['defaultvalue'] = "";
$l_we_tag['ifHasCurrentEntry']['description'] = "Mit we:ifHasCurrentEntry kann innerhalb eines we:navigationEntry type=\"folder\" Inhalt nur dann ausgegeben werden, wenn der auszugebende Navigationsordner den aktiven Eintrag besitzt.";
$l_we_tag['ifHasCurrentEntry']['defaultvalue'] = "";
$l_we_tag['ifHasEntries']['description'] = "Mit we:ifHasEntries kann innerhalb eines we:navigationEntry Inhalt nur ausgegeben werden, wenn der auszugebende Navigationseintrag Eintr&auml;ge besitzt";
$l_we_tag['ifHasEntries']['defaultvalue'] = "";
$l_we_tag['ifHasShopVariants']['description'] = "Mit &lt;we:ifHasShopVariants&gt; kann ein Inhalt bedingt nur dann angezeigt werden, wenn ein Dokument, Objekt auch Varianten enth&auml;lt. Damit kann bspw. kontrolliert werden, ob eine &lt;we:listview type=\"shopVariant\"&gt; &uuml;berhaupt angezeigt werden soll. <b>Dieses Tag wirkt in Dokumenten und in Objekt-Vorlagen die per Arbeitsbereich zugewiesen wurden, nicht jedoch in we:listview bzw. we:object Tags!</b>";
$l_we_tag['ifHasShopVariants']['defaultvalue'] = "";
$l_we_tag['ifHtmlMail']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn es sich um Inhalt f&uuml;r einen Newsletter im HTML-Format handelt.";
$l_we_tag['ifHtmlMail']['defaultvalue'] = "";
$l_we_tag['ifIsDomain']['description'] = "Das we:ifIsDomain-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn der Domainname des Servers den in \"domain\" eingetragenen Namen hat. Der Domainname muss dabei exakt identisch sein, inkl. eventuell f&uuml;hrendem \"www\".<br />Das Ergebnis ist nur auf der fertigen Webseite und in der Vorschau zu sehen, im Bearbeitungsmodus wird alles angezeigt.";
$l_we_tag['ifIsDomain']['defaultvalue'] = "";
$l_we_tag['ifIsNotDomain']['description'] = "Das we:ifIsDomain Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn der Domainname des Servers den in \"domain\" eingetragenen Namen nicht hat. Das Ergebnis ist nur auf der fertigen Webseite und in der Vorschau zu sehen, im Bearbeitungsmodus wird alles angezeigt.";
$l_we_tag['ifIsNotDomain']['defaultvalue'] = "";
$l_we_tag['ifLastCol']['description'] = "Werden die Tabellenfunktionen einer &lt;we:listview&gt; eingesetzt, kann mit &lt;we:ifLastCol&gt; die letzte Spalte einer Tabellenzeile erkannt werden.";
$l_we_tag['ifLastCol']['defaultvalue'] = "";
$l_we_tag['ifLoginFailed']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn ein Login-Versuch gescheitert ist.";
$l_we_tag['ifLoginFailed']['defaultvalue'] = "";
$l_we_tag['ifMailingListEmpty']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der Newsletterinteressent keinen Newsletter ausgew&auml;hlt hat.";
$l_we_tag['ifMailingListEmpty']['defaultvalue'] = "";
$l_we_tag['ifMale']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt innerhalb eines Newsletters nur dann anzuzeigen, wenn die m&auml;nnliche Anrede angezeigt werden soll.";
$l_we_tag['ifMale']['defaultvalue'] = "";
$l_we_tag['ifNew']['description'] = "Alles was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das zu bearbeitende Dokument/Objekt neu ist. Mit dem Attribut type wird bestimmt, ob es sich um ein Dokument oder Objekt handelt.";
$l_we_tag['ifNew']['defaultvalue'] = "";
$l_we_tag['ifNext']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn es bei einer Listview auch eine n&auml;chste Seite gibt. Gibt es keine n&auml;chste Seite, dann wird der umschlossene Inhalt nicht angezeigt.";
$l_we_tag['ifNext']['defaultvalue'] = "";
$l_we_tag['ifNoJavaScript']['description'] = "Dieses Tag dient dazu, den Browser auf ein webEdition-Dokument umzuleiten, falls im Browser des Users JavaScript deaktiviert bzw. nicht verf&uuml;gbar ist. Das Tag darf nur im Headerbereich der HTML-Seite (zwischen &lt;head&gt; und &lt;/head&gt;) verwendet werden.";
$l_we_tag['ifNotCaptcha']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der vom User eingegebene Code ung&uuml;ltig ist.";
$l_we_tag['ifNotCaptcha']['defaultvalue'] = "";
$l_we_tag['ifNotDeleted']['description'] = "Wenn ein Dokument/Objekt durch das Tag we:delete gel&ouml;scht wurde, wird alles zwischen Start- und Endtag angezeigt, wenn das L&ouml;schen nicht erfolgreich war.";
$l_we_tag['ifNotDeleted']['defaultvalue'] = "";
$l_we_tag['ifNotDoctype']['description'] = "Umschlossenen Inhalt nur anzeigen, wenn das Dokument nicht zu einem der im Attribut \"doctypes\" angegebenen Dokumenttypen geh&ouml;rt.";
$l_we_tag['ifNotDoctype']['defaultvalue'] = "";
$l_we_tag['ifNotEditmode']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur au&szlig;erhalb des Edit-Modus anzuzeigen.";
$l_we_tag['ifNotEditmode']['defaultvalue'] = "";
$l_we_tag['ifNotEmpty']['description'] = "Das we:ifNotEmpty-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn das Feld, das den in \"match\" eingetragenen Namen hat,  nicht leer ist. Im Attribut \"type\" muss der Typ des Feldes angegeben werden, wenn es sich um ein \"img\", \"flashmovie\" oder \"href\" Feld handelt.";
$l_we_tag['ifNotEmpty']['defaultvalue'] = "";
$l_we_tag['ifNotEqual']['description'] = "Das we:ifNotEqual-Tag vergleicht den Inhalt der beiden Felder \"name\" und \"eqname\". Ist der Inhalt der Felder gleich, wird alles, was zwischen Start- und Endtag steht, nicht dargestellt. Wird das Tag innerhalb von we:list, we:block oder we:linklist benutzt, kann nur ein Feld innerhalb dieser Tags mit einem Feld au&szlig;erhalb verglichen werden. In diesem Fall m&uuml;ssen Sie im Attribut \"name\" den Namen des Feldes innerhalb der we:block, we:list oder we:linklist Tags benutzen. Im Attribut eqname mu&szlig; dann der Name eines Feldes au&szlig;erhalb der Tags benutzt werden. Ebenso kann sich das Tag innerhalb von dynamisch includierten webEdition-Seiten befinden. In diesem Fall wird in \"name\" ein Feld innerhalb der includierten Seite angegeben und in \"eqname\" der Name eines Feldes auf der Hauptseite. Wenn im Attribut \"value\" etwas eingetragen ist, wird \"eqname\" ignoriert und es wird mit dem in \"value\" eingetragenen Wert verglichen.";
$l_we_tag['ifNotEqual']['defaultvalue'] = "";
$l_we_tag['ifNotField']['description'] = "Das we:ifNotField-Tag wird ben&ouml;tigt, um den umschlossenen Inhalt nur dann anzuzeigen, wenn der Wert des Datenbankfeldes des zugeh&ouml;rigen Listview-Eintrages nicht gleich dem Wert des Attributes \"match\" ist. Das we:ifNotField-Tag darf nur innerhalb des we:repeat Start- und Endtags stehen.";
$l_we_tag['ifNotField']['defaultvalue'] = "";
$l_we_tag['ifNotFound']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn bei einer &lt;we:listview&gt; keine Eintr&auml;ge gefunden werden.";
$l_we_tag['ifNotFound']['defaultvalue'] = "";
$l_we_tag['ifNotHtmlMail']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn es sich nicht um Inhalt f&uuml;r einen Newsletter im HTML-Format handelt.";
$l_we_tag['ifNotHtmlMail']['defaultvalue'] = "";
$l_we_tag['ifNotNew']['description'] = "Alles was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das zu bearbeitende Dokument/Objekt nicht neu ist. Mit dem Attribut type wird bestimmt, ob es sich um ein Dokument oder Objekt handelt.";
$l_we_tag['ifNotNew']['defaultvalue'] = "";
$l_we_tag['ifNotObject']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der jeweilige Eintrag innerhalb von &lt;we:listview type=\"search\"&gt; kein Objekt ist.";
$l_we_tag['ifNotObject']['defaultvalue'] = "";
$l_we_tag['ifNotPosition']['description'] = "Mit dem Tag we:ifNotPosition kann man eine Aktion definieren, die an einer bestimmten Position eines Blocks, einer Listview, einer Linklist oder einer Listdir NICHT ausgef&uuml;hrt wird. Der Parameter \"position\" erlaubt eine vielseitige Eingabe der Position. So ist es m&ouml;glich, die erste (first), letze (last), alle geraden (even), bzw ungeraden (odd), sowie einzelne Positionen (1,2,3, ...) abzupr&uuml;fen. Wird der type \"block\", \"linklist\" verwendet, muss zus&auml;tzlich der Name (reference) des entsprechenden Blocks/Linklist angegeben werden.";
$l_we_tag['ifNotPosition']['defaultvalue'] = "";
$l_we_tag['ifNotRegisteredUser']['description'] = "Pr&uuml;ft, ob ein User nicht registriert ist.";
$l_we_tag['ifNotRegisteredUser']['defaultvalue'] = "";
$l_we_tag['ifNotReturnPage']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nach dem &Auml;ndern/Erzeugen von einem webEdition-Dokument bzw. Objekt nur dann anzuzeigen, wenn der Wert des Attributs \"return\" von &lt;we:a edit=\"true\"&gt; gleich \"false\" ist oder das Attribut nicht gesetzt wurde.";
$l_we_tag['ifNotReturnPage']['defaultvalue'] = "";
$l_we_tag['ifNotSearch']['description'] = "Durch das we:ifNotSearch-Tag wird der Inhalt zwischen dem Start- und Endtag nur dann angezeigt, wenn kein Suchbegriff mit we:search &uuml;bermittelt wurde oder dieser leer ist. Ist das Attribut \"set\" auf true gesetzt, wird nur gepr&uuml;ft ob die Request-Variable von we:search nicht gesetzt ist.";
$l_we_tag['ifNotSearch']['defaultvalue'] = "";
$l_we_tag['ifNotSeeMode']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur ausserhalb des seeMode anzuzeigen.";
$l_we_tag['ifNotSeeMode']['defaultvalue'] = "";
$l_we_tag['ifNotSelf']['description'] = "Das we:ifNotSelf-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nicht angezeigt wird, wenn das Dokument eine der unten eingetragenen ID's hat. Befindet sich das Tag nicht innerhalb von we:linklist oder we:listdir Tags, dann ist \"id\" ein erforderlicher Eintrag!";
$l_we_tag['ifNotSelf']['defaultvalue'] = "";
$l_we_tag['ifNotSidebar']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur auszugeben, wenn der Seitenaufruf ausserhalb der Sidebar stattfindet.";
$l_we_tag['ifNotSidebar']['defaultvalue'] = "";
$l_we_tag['ifNotSubscribe']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der Eintrag in eine Newsletter-Adressliste nicht erfolgreich war und sollte in der Vorlage nach &lt;we:addDelNewsletterEmail&gt; stehen, aus der das webEdition-Dokument erzeugt wird, welches nach einem Eintrag in eine Newsletter-Adressliste aufgerufen wird.";
$l_we_tag['ifNotSubscribe']['defaultvalue'] = "";
$l_we_tag['ifNotTemplate']['description'] = "Zeigt dem umschlossenen Inhalt nur an, wenn das aktuelle Dokument nicht auf der angegebenen Vorlage beruht.<br /><br />Weitere Informationen finden Sie in der Dokumentation des Tags we:ifTemplate.";
$l_we_tag['ifNotTemplate']['defaultvalue'] = "";
$l_we_tag['ifNotTop']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn sich das Tag innerhalb einer includierten Datei befindet.";
$l_we_tag['ifNotTop']['defaultvalue'] = "";
$l_we_tag['ifNotUnsubscribe']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der Austrag aus einer Newsletter-Adressliste nicht erfolgreich war und sollte in der Vorlage nach &lt;we:addDelNewsletterEmail&gt; stehen, aus der das webEdition-Dokument erzeugt wird, welches nach dem Austrag aus einer Newsletter-Adressliste aufgerufen wird.";
$l_we_tag['ifNotUnsubscribe']['defaultvalue'] = "";
$l_we_tag['ifNotVar']['description'] = "Das we:ifNotVar-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nicht angezeigt wird, wenn die Variable mit dem Namen \"name\" gleich dem Wert ist, welcher in \"match\" eingetragen ist. Im Attribut \"type\" kann angegeben werden, um welchen Typ von Variable es sich handelt.";
$l_we_tag['ifNotVar']['defaultvalue'] = "";
$l_we_tag['ifNotVarSet']['description'] = "Mit diesem Tag kann man pr&uuml;fen, ob eine Variable mit dem Namen name nicht gesetzt ist. Achtung: Es ist ein Unterschied ob eine Variable leer ist oder nicht gesetzt wurde!";
$l_we_tag['ifNotVarSet']['defaultvalue'] = "";
$l_we_tag['ifNotVote']['description'] = "Alles, was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das Voting nicht gespeichert ist. Das Attribut type spezifiziert die Art des Fehlers.";
$l_we_tag['ifNotVote']['defaultvalue'] = "";
$l_we_tag['ifNotWebEdition']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt innerhalb von webEdition nicht anzuzeigen. Auf der fertig erzeugten Seite wird der umschlossene Inhalt angezeigt.";
$l_we_tag['ifNotWebEdition']['defaultvalue'] = "";
$l_we_tag['ifNotWorkspace']['description'] = "&Uuml;berpr&uuml;ft, ob sich ein Dokument NICHT in dem unter \"path\" angegeben Arbeitsbereich befindet.";
$l_we_tag['ifNotWorkspace']['defaultvalue'] = "";
$l_we_tag['ifNotWritten']['description'] = "Alle was zwischen Start- und Endtag steht, wird nur angezeigt, wenn es einen Fehler beim Schreiben eines Dokuments/Objekts mit dem Tag we:write gab. Bei einem Objekt mu&szlig; type=\"object\" sein.";
$l_we_tag['ifNotWritten']['defaultvalue'] = "";
$l_we_tag['ifObject']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der jeweilige Eintrag innerhalb von &lt;we:listview type=\"search\"&gt; ein Objekt ist.";
$l_we_tag['ifObject']['defaultvalue'] = "";
$l_we_tag['ifPosition']['description'] = "Mit dem Tag we:ifPosition ist es m&ouml;glich die aktuelle Position eines Blocks, einer Listview, einer Linklist oder einer Listdir zu kontrollieren. Der Parameter \"position\" erlaubt eine vielseitige Eingabe der Position. So ist es m&ouml;glich das Erste (first), Letze (last), alle geraden (even), bzw ungeraden (odd), sowie einzelne Positionen (1,2,3, ...) abzupr&uuml;fen. Wird der type \"block\", \"linklist\" verwendet, muss zus&auml;tzlich der Name (reference) des entsprechenden Blocks/Linklist angegeben werden.";
$l_we_tag['ifPosition']['defaultvalue'] = "";
$l_we_tag['ifRegisteredUser']['description'] = "Pr&uuml;ft, ob ein User registriert ist oder nicht.";
$l_we_tag['ifRegisteredUser']['defaultvalue'] = "";
$l_we_tag['ifRegisteredUserCanChange']['description'] = "Pr&uuml;ft, ob das aktuelle Dokument/Objekt von einem registrierten Kunden ver&auml;ndert werden kann. In einer listview wird das Dokument/Objekt des aktuellen listview-Eintrags benutzt.";
$l_we_tag['ifRegisteredUserCanChange']['defaultvalue'] = "";
$l_we_tag['ifReturnPage']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nach dem &Auml;ndern/Erzeugen eines webEdition-Dokuments bzw. Objekts nur dann anzuzeigen, wenn der Wert das Attributs \"return\" von &lt;we:a edit=\"document\"&gt; bzw. &lt;we:a edit=\"object\"&gt; gleich \"true\" ist.";
$l_we_tag['ifReturnPage']['defaultvalue'] = "";
$l_we_tag['ifSearch']['description'] = "Durch das we:ifSearch-Tag wird der Inhalt zwischen dem Start- und Endtag nur dann angezeigt, wenn ein Suchbegriff mit we:search  &uuml;bermittelt wurde und dieser nicht leer ist. Ist das Attribut \"set\" auf true gesetzt, wird nur gepr&uuml;ft ob die Request-Variable von we:search gesetzt ist.";
$l_we_tag['ifSearch']['defaultvalue'] = "";
$l_we_tag['ifSeeMode']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur innerhalb des seeMode anzuzeigen.";
$l_we_tag['ifSeeMode']['defaultvalue'] = "";
$l_we_tag['ifSelf']['description'] = "Durch das we:ifSelf-Tag wird der Inhalt zwischen dem Start- und Endtag nur dann angezeigt, wenn es sich um ein Dokument handelt, welches &uuml;bder das Attribut ID angegeben wird. Befindet sich das Tag nicht innerhalb von we:linklist oder we:listdir Tags, dann ist \"id\" ein erforderlicher Eintrag!";
$l_we_tag['ifSelf']['defaultvalue'] = "";
$l_we_tag['ifShopEmpty']['description'] = "Alles, was sich zwischen dam Start- und Endtag befindet, wird angezeigt, wenn der Warenkorb leer ist.";
$l_we_tag['ifShopEmpty']['defaultvalue'] = "";
$l_we_tag['ifShopNotEmpty']['description'] = "Alles, was sich zwischen dam Start- und Endtag befindet, wird angezeigt, wenn der Warenkorb nicht leer ist.";
$l_we_tag['ifShopNotEmpty']['defaultvalue'] = "";
$l_we_tag['ifShopPayVat']['description'] = "Mit we:ifShopPayVat wird ein Inhalt nur bedingt angezeigt, wenn ein eingeloggter Kunde Mehrwertsteuern entrichten muss. ";
$l_we_tag['ifShopPayVat']['defaultvalue'] = "";
$l_we_tag['ifShopVat']['description'] = "Mit we:ifShopTag kann man den Mehrwertsteuersatz, des aktuellen Artikels des Dokuments, bzw. des Warenkorbs pr&uuml;fen. Ist Id gesetzt, wird die des Mehrwertsteuersatzes des aktuellen (Dokument oder Warenkorb) Artikels mit der hier angegeben verglichen.";
$l_we_tag['ifShopVat']['defaultvalue'] = "";
$l_we_tag['ifSidebar']['description'] = "Dieses Tag dient dazu, den umschliessenden Inhalt nur auszugeben, wenn der Seitenaufruf innerhalb der Sidebar stattfindet.";
$l_we_tag['ifSidebar']['defaultvalue'] = "";
$l_we_tag['ifSubscribe']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der Eintrag in eine Newsletter-Adressliste erfolgreich war.";
$l_we_tag['ifSubscribe']['defaultvalue'] = "";
$l_we_tag['ifTemplate']['description'] = "Der umschlossene Inhalt wird angezeigt, wenn das aktuelle Dokument auf der angegebenen Vorlage beruht.";
$l_we_tag['ifTemplate']['defaultvalue'] = "";
$l_we_tag['ifTop']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn sich das Tag nicht innerhalb einer includierten Datei befindet.";
$l_we_tag['ifTop']['defaultvalue'] = "";
$l_we_tag['ifUnsubscribe']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur dann anzuzeigen, wenn der Austrag aus einer Newsletter-Adressliste erfolgreich war und sollte in der Vorlage nach &lt;we:addDelNewsletterEmail&gt; stehen.";
$l_we_tag['ifUnsubscribe']['defaultvalue'] = "";
$l_we_tag['ifUserInputEmpty']['description'] = "Alles was sich zwischen Start- und Endtag befindet, wird angezeigt, wenn ein UserInput-Feld, mit dem im Attribut match stehenden Namen, leer ist.";
$l_we_tag['ifUserInputEmpty']['defaultvalue'] = "";
$l_we_tag['ifUserInputNotEmpty']['description'] = "Alles was sich zwischen Start- und Endtag befindet, wird angezeigt, wenn ein UserInput-Feld, mit dem im Attribut match stehenden Namen, nicht leer ist.";
$l_we_tag['ifUserInputNotEmpty']['defaultvalue'] = "";
$l_we_tag['ifVar']['description'] = "Das we:ifVar-Tag bewirkt, da&szlig; alles, was zwischen dem Start- und Endtag steht, nur dann angezeigt wird, wenn die Variable mit dem Namen \"name\" gleich dem Wert ist, welcher in \"match\" eingetragen ist. Im Attribut \"type\" kann angegeben werden, um welchen Typ von Variable es sich handelt.";
$l_we_tag['ifVar']['defaultvalue'] = "";
$l_we_tag['ifVarEmpty']['description'] = "Pr&uuml;ft, ob eine Variable leer ist. Ist dies der Fall, wird alles zwischen Start- und Endtag angezeigt.";
$l_we_tag['ifVarEmpty']['defaultvalue'] = "";
$l_we_tag['ifVarNotEmpty']['description'] = "Pr&uuml;ft, ob eine Variable nicht leer ist. Ist dies der Fall, wird alles zwischen Start- und Endtag angezeigt.";
$l_we_tag['ifVarNotEmpty']['defaultvalue'] = "";
$l_we_tag['ifVarSet']['description'] = "Mit diesem Tag kann man pr&uuml;fen, ob eine Variable mit dem Namen name gesetzt ist. Achtung: Es ist ein Unterschied ob eine Variable leer ist oder nicht gesetzt wurde!";
$l_we_tag['ifVarSet']['defaultvalue'] = "";
$l_we_tag['ifVote']['description'] = "Alles, was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das Voting erfolgreich gespeichert ist.";
$l_we_tag['ifVote']['defaultvalue'] = "";
$l_we_tag['ifVoteActive']['description'] = "Alles, was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das Voting nicht abgelaufen ist.";
$l_we_tag['ifVoteActive']['defaultvalue'] = "";
$l_we_tag['ifWebEdition']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt nur innerhalb von webEdition anzuzeigen. Auf der fertig erzeugten Seite wird der umschlossene Inhalt nicht angezeigt.";
$l_we_tag['ifWebEdition']['defaultvalue'] = "";
$l_we_tag['ifWorkspace']['description'] = "&Uuml;berpr&uuml;ft, ob sich das Dokument in dem unter \"path\" bzw. \"id\" angegeben Arbeitsbereich befindet.";
$l_we_tag['ifWorkspace']['defaultvalue'] = "";
$l_we_tag['ifWritten']['description'] = "Alle was zwischen Start- und Endtag steht, wird nur angezeigt, wenn es keinen Fehler beim Schreiben eines Dokuments/Objekts mit dem Tag we:write gab. Bei einem Objekt mu&szlig; type=\"object\" sein.";
$l_we_tag['ifWritten']['defaultvalue'] = "";
$l_we_tag['img']['description'] = "Das we:img-Tag dient dazu, eine Grafik in den Inhalt eines Dokumentes einzubauen. Im Bearbeitungsmodus eines Dokumentes ist unter der Grafik ein Button \"edit\" sichtbar. Durch Anklicken des Buttons &ouml;ffnet sich der Dateimanager, aus dem man eine Grafik ausw&auml;hlen oder neu anlegen kann. Wenn die Attribute \"width\", \"height\", \"border\", \"hspace\", \"vspace\", \"alt\" oder \"align\" gesetzt werden, dann werden diese Einstellungen f&uuml;r die Grafik verwendet, ansonsten gelten die Einstellungen, welche bei der Grafik gemacht wurden. Wenn das Attribut id gesetzt ist, dann wird die Grafik mit dieser ID benutzt, falls noch keine andere Grafik ausgew&auml;hlt wurde. Das Attribut showimage erm&ouml;glicht es, das Bild im Bearbeiten-Modus nicht anzeigen zu lassen. Mit showinputs lassen sich die Eingabefelder f&uuml;r title und alt-text deaktivieren.";
$l_we_tag['include']['description'] = "Mit diesem-Tag k&ouml;nnen Sie ein webEdition-Dokument oder eine HTML-Seite in die Vorlage einbinden. Dies ist besonders f&uuml;r Navigationen oder Teile, die auf jeder Vorlage gleich sind, zu empfehlen. Wenn Sie mit dem we:include-Tag arbeiten, brauchen Sie eine &Auml;nderung der Navigation nicht in allen Vorlagen &auml;ndern, sondern nur im einzubindenden Dokument. Danach brauchen Sie nur einen \"rebuild\" auszuf&uuml;hren, und alle Seiten werden automatisch ge&auml;ndert. Haben Sie nur dynamisch erzeugte Seiten, kann der \"rebuild\" entfallen. Anstelle des we:include Tags wird die Seite mit der unten angegebenen ID eingef&uuml;gt. Mit dem Attribut \"gethttp\" k&ouml;nnen Sie bestimmen, ob die Seite per http geholt werden soll oder nicht. Das Attribut seeMode bestimmt, ob die Datei im seeMode als Include Datei bearbeitet werden kann, dies ist allerdings nur m&ouml;glich wenn das Dokument per id included wird.";
$l_we_tag['input']['description'] = "Das we:input-Tag bewirkt, da&szlig; im Bearbeitungsmodus des Dokumentes, das diese Vorlage zugrunde liegen hat, ein einzeiliges Eingabefeld erzeugt wird, wenn der Typ = \"text\" ausgew&auml;hlt wird. F&uuml;r die anderen Typen siehe Handbuch oder Hilfe.";
$l_we_tag['js']['description'] = "Das we:js-Tag erzeugt ein HTML-Tag, das auf ein webEdition-internes Javascript-Dokument mit der unten angegebenen ID verweist. Dadurch k&ouml;nnen Sie Javascripts in einer separaten Datei definieren.";
$l_we_tag['keywords']['description'] = "Das we:keywords-Tag erzeugt ein Schl&uuml;sselwort Meta-Tag. Alles zwischen Start- und Endtag wird als default-keywords eingetragen, falls das Schl&uuml;sselwortfeld in der Ansicht \"Eigenschaft\" leer ist. Ansonsten werden die Schl&uuml;sselworte aus der Ansicht \"Eigenschaft\" eingetragen.";
$l_we_tag['link']['description'] = "Das we:link-Tag erzeugt einen einzelnen Link, der durch einen Button \"edit\" ver&auml;ndert werden kann. Wird das Tag innerhalb von Linklisten verwendet, so darf das Attribut \"name\" nicht angegeben werden. Wird das Tag au&szlig;erhalb von Linklisten verwendet, dann mu&szlig; das Attribut \"name\" angegeben werden!Das Attribut only kann dazu eingesetzt werden nur ein einzelnes Attribut  (only=\"Attributname\") oder den Inhalt (only=\"content\") auszugeben.";
$l_we_tag['linklist']['description'] = "Mit dem we:linklist-Tag kann man Linklisten generieren. Im Bearbeitungsmodus erscheint ein Plus-Button. Klickt man diesen Button, so wird der Liste ein neuer Link hinzugef&uuml;gt. Innerhalb des Start- und Endtags wird mit Hilfe der Tags \"we:link\", \"we:prelink\" und \"we:postlink\", sowie normalem HTML, das Aussehen der Linkliste bestimmt. Alle eingef&uuml;gten Links k&ouml;nnen mit einem Button \"edit\" ver&auml;ndert, oder mit einem Button \"l&ouml;schen\" gel&ouml;scht werden.";
$l_we_tag['linklist']['defaultvalue'] = "&lt;we:link /&gt;&lt;we:postlink&gt;&lt;br /&gt;&lt;/we:postlink&gt;";
$l_we_tag['linkToSeeMode']['description'] = "Dieser Tag erzeugt auf der Web-Seite einen Link, der das eben besuchte Dokument im seeMode von webEdition &ouml;ffnet und somit einfach bearbeitet werden kann.";
$l_we_tag['list']['description'] = "Mit dem we:list-Tag kann man erweiterbare Listen erzeugen. Alles, was zwischen Start- und Endtag steht, wird im Bearbeitungsmodus durch einen Klick auf den Plus-Button angeh&auml;ngt, bzw. eingef&uuml;gt. Dies k&ouml;nnen beliebiges HTML sowie fast alle we:tags sein.";
$l_we_tag['list']['defaultvalue'] = "";
$l_we_tag['listdir']['description'] = "Mit dem we:listdir-Tag kann man eine Liste erzeugen, welche alle Dateien im gleichen Verzeichnis anzeigt. Im Attribut \"field\" kann man angeben, welches Feld angezeigt wird. Ist das Feld leer oder gibt es das Feld nicht, wird der Dateiname angezeigt. Bei Verzeichnissen wird &uuml;berpr&uuml;ft, ob es darin eine index Datei gibt und wenn ja, wird diese angezeigt. Im Attribut \"dirfield\" kann man angeben, welches Feld zur Anzeige benutzt werden soll. Ist das Feld leer oder gibt es das Feld nicht, wird der Eintrag von \"field\" bzw der Dateiname benutzt. Ist das Attribut \"id\" gesetzt, werden die Dateien vom Verzeichnis mit der angegebenen ID angezeigt.";
$l_we_tag['listdir']['defaultvalue'] = "";
$l_we_tag['listview']['description'] = "Das we:listview-Tag ist das Start- und Endtag von automatisch generierten Listen. (&Uuml;bersichtsseiten von News, usw.).";
$l_we_tag['listview']['defaultvalue'] = "&lt;we:repeat&gt;
&lt;we:field name=\"Title\" alt=\"we_path\" hyperlink=\"true\"/&gt;
&lt;br /&gt;
&lt;/we:repeat&gt;";
$l_we_tag['listviewEnd']['description'] = "Dieses Tag gibt die Nummer des letzten Eintrags der aktuellen Seite einer &lt;we:listview&gt; aus.";
$l_we_tag['listviewPageNr']['description'] = "Dieses Tag gibt die Nummer der aktuellen Seite einer &lt;we:listview&gt; aus.";
$l_we_tag['listviewPages']['description'] = "Dieses Tag gibt die Anzahl der Seiten einer &lt;we:listview&gt; aus.";
$l_we_tag['listviewRows']['description'] = "Dieses Tag gibt die Anzahl aller gefundenen Eintr&auml;ge einer &lt;we:listview&gt; aus.";
$l_we_tag['listviewStart']['description'] = "Dises Tag gibt die Nummer des ersten Eintrags der aktuellen Seite einer &lt;we:listview&gt; aus.";
$l_we_tag['makeMail']['description'] = "Dieses Tag muss in jeder Vorlage in der ersten Zeile stehen, aus der ein webEdition-Dokument erzeugt wird, welches mit &lt;we:sendMail/&gt; versendet werden soll.";
$l_we_tag['master']['description'] = "Wird in einer Detailvorlage verwendet und f&uuml;gt den umschlossenen Inhalt beim we:content Tag im Mastertemplate ein. Die Verkn&uuml;pfung zu we:content wird &uuml;ber das Attribut \"name\" hergestellt. (we:master name=\"head\" =&gt; we:content name=\"head\").<br /><br />Inhalt der Detailvorlage au&szlig;erhalb des we:master Tags wird weiterhin beim we:content ohne Name eingesetzt.";
$l_we_tag['master']['defaultvalue'] = "";
$l_we_tag['metadata']['description'] = "Das we:metadata-Tag wird ben&ouml;tigt, um die Metadatenfelder von eingebundenen Bildern, Flash-Movies und Quicktime-Movies darzustellen. Innerhalb des we:metadata Start- und Endtags kann man die Metadatenfelder mit we:field-Tags darstellen. Im Attribut \"name\" muss der Name des darzustellenden Elements angegeben werden.";
$l_we_tag['metadata']['defaultvalue'] = "&lt;we:field name=\"NameOfField\" /&gt;";
$l_we_tag['navigation']['description'] = "Mit we:navigation wird eine innerhalb des Navigationstools erstellte Navigation initialisiert.";
$l_we_tag['navigationEntries']['description'] = "Dient innerhalb eines we:navigationEntry type=\"folder\" als Platzhalter f&uuml;r alle Eintr&auml;ge eines Ordners der Navigation.";
$l_we_tag['navigationEntry']['description'] = "Mit we:navigationEntry kann das Aussehen eines Eintrags innerhalb der Navigation beeinflusst werden. Mit den Attributen \"type\", \"level\", \"current\" und \"position\" kann man sich dabei gezielt einzelne Elemente verschiedenster Ebene rauspicken und ausgeben.";
$l_we_tag['navigationEntry']['defaultvalue'] = "&lt;a href=\"&lt;we:navigationField name=\"href\" /&gt;\"&gt;&lt;we:navigationField name=\"text\" /&gt;&lt;/a&gt;&lt;br /&gt;";
$l_we_tag['navigationField']['description'] = "Mit dem Tag &lt;we:navigationField&gt; kann innerhalb eines &lt;we:navigationEntry&gt; ein Wert des aktuellen Navigationseintrags ausgegeben werden.<br/> W&auml;hlen Sie dabei <b>entweder</b> einen Eintrag f&uuml;r das Attribut <i>name</i>, <b>oder</b> einen Eintrag f&uuml;r das Attribut <i>attributes</i>, <b>oder</b> einen Eintrag f&uuml;r das Attribut <i>complete</i>";
$l_we_tag['navigationWrite']['description'] = "Wird benutzt um eine we:navigation mit gegebenem Name zu schreiben.";
$l_we_tag['newsletterConfirmLink']['description'] = "Dieser Tag dient dazu, einen Best&auml;tigungs-Link f&uuml;r einen Double-Opt-In zu erstellen. Ein Newsletter-Interessent kann so best&auml;tigen, dass er den Newsletter abonnieren m&ouml;chte.";
$l_we_tag['newsletterConfirmLink']['defaultvalue'] = "Newsletter best&auml;tigen";
$l_we_tag['newsletterField']['description'] = "Ein Feld aus dem Empf&auml;ngerdatensatz innerhalb eines Newsletters anzeigen.";
$l_we_tag['newsletterSalutation']['description'] = "Mit diesem Tag kann man Anrede-Felder anzeigen.";
$l_we_tag['newsletterUnsubscribeLink']['description'] = "Das we:newsletterUnsubscribeLink-Tag erzeugt ein HTML-Link-Tag zum Austragen aus der Newsletterliste. Dieses Tag kann nur in E-Mail Vorlagen benutzt werden!";
$l_we_tag['next']['description'] = "Das we:next-Tag erzeugt ein HTML-Link-Tag, das auf die n&auml;chste we:listview-Seite verweist. Der gesamte Inhalt zwischen Start- und Endtag wird verlinkt.";
$l_we_tag['next']['defaultvalue'] = "";
$l_we_tag['noCache']['description'] = "Innerhalb dieses Tags kann PHP-Code stehen, welcher bei einer gecachten Vorlage (Ausnahme: Full-Cache) immer ausgef&uuml;hrt werden soll.";
$l_we_tag['noCache']['defaultvalue'] = "";
$l_we_tag['object']['description'] = "Das we:object-Tag wird ben&ouml;tigt, um Objekte darzustellen. Innerhalb des we:object Start- und Endtags kann man Felder des Objekts mit we:field-Tags darstellen. Ist nur das Attribut \"name\" gesetzt, erscheint im Edit Mode ein Objekt-Selector, in dem der Redakteur aus allen vorhandenen Objekten aller Klassen ausw&auml;hlen kann. Schr&auml;nkt man mit dem Attribut \"classid\" durch Angabe der ID einer Klasse die Auswahl ein, k&ouml;nnen jetzt nur noch Objekte dieser Klasse ausgew&auml;hlt werden. Im Attribut \"id\" kann man ein festes Objekt der gesetzten classid bestimmen. Das Attribut \"triggerid\" wird gebraucht, um bei einer statisch erzeugten Objekt-Listview ein dynamisches Dokument anzugeben, welches bei Objekt-Links ben&ouml;tigt wird, um das entsprechende Objekt darzustellen.";
$l_we_tag['object']['defaultvalue'] = "";
$l_we_tag['pagelogger']['description'] = "Das we:pagelogger-Tag erzeugt je nach gew&auml;hltem Attribut \"type\" den von pageLogger erforderlichen Erfassungscode oder den Fileserver- bzw. Download-Code.";
$l_we_tag['path']['description'] = "Das we:path-Tag stellt den Pfad des aktuellen Dokuments dar. Gibt es in einem der Unterverzeichnisse eine index-Datei, wird ein Link auf das Verzeichnis gesetzt. Im Attribut index kann man die verwendeten index-Dateien (mit Kommas getrennt) angeben. Ist dort nichts angegeben, werden \"index.html\", \"index.htm\", \"index.php\", \"default.htm\", \"default.html und \"default.php\" als Voreinstellung benutzt. Im Attribut home kann man angeben, was ganz am Anfang des Pfades stehen soll. Ist nichts angegeben, wird automatisch \"home\" angezeigt. Das Attribut separator beschreibt das Trennzeichen zwischen den Verzeichnissen. Ist das Attribut leer, dann wird ein \"/\" als Trennzeichen verwendet. Im Attribut \"field\" kann man angeben, welches Feld angezeigt wird. Ist das Feld leer oder gibt es das Feld nicht, wird der Dateiname angezeigt. Im Attribut \"dirfield\" kann man angeben, welches Feld zur Anzeige bei Verzeichnissen benutzt werden soll. Ist das Feld leer oder gibt es das Feld nicht, wird der Eintrag von \"field\" bzw der Dateiname benutzt.";
$l_we_tag['paypal']['description'] = "we:paypal stellt eine Schnittstelle zu paypal zur Verf&uuml;gung. Damit k&ouml;nnen sie Ihre Verk&auml;ufe bequem &uuml;ber einen Payment-Provider abwickeln. Beachten Sie hierbei, dass sie im Backend des Shop Moduls weitere Parameter angeben m&uuml;ssen.";
$l_we_tag['position']['description'] = "Das Tag we:position wird eingesetzt, um die aktuelle Position der duchlaufenen Listview, Block, Linklist oder einer Linklist auszugeben. Wird type \"block\" oder \"linklist\" verwendet, muss zus&auml;tzlich der Name (reference) des entsprechenden Blocks/Linklist angegeben werden. &Uuml;ber das Attribut \"format\" kann die Formatierung der Positionsangabe angegeben werden.";
$l_we_tag['postlink']['description'] = "Das we:postlink-Tag wird ben&ouml;tigt, um Code einzugrenzen, welcher beim letzten Durchlauf der Linkliste nicht angezeigt werden soll.";
$l_we_tag['postlink']['defaultvalue'] = "";
$l_we_tag['prelink']['description'] = "Das we:prelink-Tag wird ben&ouml;tigt, um Code einzugrenzen, welcher beim ersten Durchlauf der Linkliste nicht angezeigt werden soll.";
$l_we_tag['prelink']['defaultvalue'] = "";
$l_we_tag['printVersion']['description'] = "Das we:printVersion-Tag erzeugt ein HTML-Link-Tag, das auf das gleiche Dokument, aber mit einer anderen Vorlage, verweist. Das Attribut tid bestimmt die id der Vorlage. Der gesamte Inhalt zwischen Start- und Endtag wird verlinkt.";
$l_we_tag['printVersion']['defaultvalue'] = "";
$l_we_tag['processDateSelect']['description'] = "Das &lt;we:processDateSelect&gt;-Tag wandelt die 3 Werte, der Select Boxen des we:dateSelect-Tags in einen Unix Timestamp und schreibt diesen Wert in die globale Variable mit dem in \"name\" angegeben Namen.";
$l_we_tag['quicktime']['description'] = "Das we:quicktime-Tag dient dazu, einen Quicktime Movie in den Inhalt des Dokumentes einzubauen. Im Bearbeitungsmodus eines Dokumentes, das diese Vorlage zugrunde liegen hat, ist ein Button \"edit\" sichtbar. Durch Anklicken dieses Buttons, &ouml;ffnet sich ein Dateimanager, in dem man einen Quicktime Movie, der zuvor in webEdition angelegt wurde, ausw&auml;hlen kann. F&uuml;r das Tag we:quicktime gibt es momentan leider keine xhtml-valide Ausgabe, die auf g&auml;ngigen Browsern korrekt ausgef&uuml;hrt wird. Daher wird dem Attribut \"xml\" unabh&auml;ngig von der hier gemachten Einstellung immer der Wert \"false\" zugeordnet.";
$l_we_tag['registeredUser']['description'] = "Dieses Tag dient dazu, Daten eines bestimmten Kunden, der in der Kundenverwaltung eingetragen ist, anzuzeigen. ";
$l_we_tag['registerSwitch']['description'] = "Dieses Tag erzeugt im Edit-Mode einen Umschalter, mit dem man zwischen dem Status eines registrierten und eines unregistrierten Benutzers umschalten kann. Das ist sinnvoll bei der Verwendung der Tags &lt;we:ifRegisteredUser&gt; und &lt;we:ifNotRgisteredUser&gt;, um die verschiedenen Ansichten zu &uuml;berpr&uuml;fen und volle Sicherheit &uuml;ber das Layout zu haben.";
$l_we_tag['repeat']['description'] = "Dieses Tag dient dazu, den umschlossenen Inhalt innerhalb von &lt;we:listview&gt; pro gefundenem Eintrag zu wiederholen.";
$l_we_tag['repeat']['defaultvalue'] = "";
$l_we_tag['repeatShopItem']['description'] = "Dieses Tag erstellt eine Liste aller Artikel im Warenkorb.";
$l_we_tag['repeatShopItem']['defaultvalue'] = "";
$l_we_tag['returnPage']['description'] = "Dieses Tag dient dazu, den URL der Ursprungsseite auzugeben, wenn der Wert das Attributs \"return\" von &lt;we:a edit=\"document\"&gt; bzw. &lt;we:a edit=\"object\"&gt; gleich \"true\" war.";
$l_we_tag['saferpay']['description'] = "we:saferpay stellt eine Schnittstelle zu saferpay zur Verf&uuml;gung. Damit k&ouml;nnen sie Ihre Verk&auml;ufe bequem &uuml;ber einen Payment-Provider abwickeln. Beachten Sie hierbei, dass sie im Backend des Shop Moduls weitere Parameter angeben m&uuml;ssen.";
$l_we_tag['saveRegisteredUser']['description'] = "Dieses Tag dient zum Abspeichern von Kundendaten die &uuml;ber Sessionfields eingegeben wurden.";
$l_we_tag['search']['description'] = "Das we:search-Tag erzeugt ein Eingabefeld oder ein Textfeld, das f&uuml;r Suchanfragen genutzt werden soll. Das Suchfeld hat intern den Namen \"we_lv_search_0\". Wenn die Suchform also gesendet wird, dann wird auf der empfangenden Webseite die PHP-Variable \$_REQUEST[\"we_lv_search_0\"] mit dem Inhalt des Eingabefeldes gef&uuml;llt sein.";
$l_we_tag['select']['description'] = "Das we:select-Tag erzeugt im Bearbeitungsmodus eine Auswahlbox f&uuml;r die Eingabe. Wird bei Size eine 1 eingetragen (Size = \"1\"), so erscheint die Auswahlbox als Popup-Men&uuml;. Dieses Tag verh&auml;lt sich genau wie ein HTML-Select-Tag. Innerhalb von Start- und Endtag werden die Eintr&auml;ge durch normale HTML-Options-Tags bestimmt.";
$l_we_tag['select']['defaultvalue'] = "&lt;option&gt;#1&lt;/option&gt;
&lt;option&gt;#2&lt;/option&gt;
&lt;option&gt;#3&lt;/option&gt;";
$l_we_tag['sendMail']['description'] = "Das we:sendMail-Tag verschickt eine webEdition-Seite als E-Mail an die im Attribut \"recipient\" eingetragenen Adressen.";
$l_we_tag['sessionField']['description'] = "Das we:sessionField-Tag erzeugt ein HTML Input, Select oder Textarea-Tag, welches f&uuml;r die Eingabe von Session-Feldern (Kundendaten o&auml;.) verwendet wird.";
$l_we_tag['sessionLogout']['description'] = "Das we:sessionLogout-Tag erzeugt ein HTML-Link-Tag, das auf ein webEdition-internes Dokument mit der unten angegebenen ID verweist. Wenn das angegebene Dokument ein we:sessionStart-Tag besitzt und dynamisch gespeichert wurde, dann wird die aktuelle Session gel&ouml;scht.";
$l_we_tag['sessionLogout']['defaultvalue'] = "";
$l_we_tag['sessionStart']['description'] = "Dieses Tag dient dazu, eine Session zu beginnen oder eine bestehende fortzusetzen. Dieses Tag wird auf folgenden Vorlagen ben&ouml;tigt: bei Seiten, welche durch die Kundenverwaltung gesch&uuml;tzt sind, bei Shopseiten und bei Frontend-Eingaben (Erzeugung von webEdition-Dokumenten und Objekten &uuml;ber das Frontend).<br />Das Tag muss immer in der ersten Zeile der Vorlage stehen!";
$l_we_tag['setVar']['description'] = "Mit we:setVar k&ouml;nnen verschiedene Arten von Variablen gesetzt werden.<br/><strong>Achtung:</strong> Ohne gesetztes Attribut <strong>striptags</strong> werden dabei HTML- und PHP-Code mit &uuml;bertragen, dies ist ein potenzielles <strong>Sicherheitsrisiko!</strong>";
$l_we_tag['shipping']['description'] = "we:shipping ermittelt die bei einem Einkauf f&auml;lligen Versandkosten. Dabei wird auf den Wert des Warenkorbs, das Herkunftsland des eingeloggten Kunden und die innerhalb des Shop Moduls eingepflegten Regeln f&uuml;r Porto- und Versandkosten zugegriffen, um die anfallenden Kosten zu ermitteln. Mit dem Parameter \"sum\" &uuml;bergibt man den Namen einer mit we:sum errechneten Summe. Mit dem Parameter type kann gezielt der Netto- (net), bzw. Brutto- (gros) Betrag sowie der Mehrwertsteueranteil (vat) ermittelt werden.";
$l_we_tag['shopField']['description'] = "Mit we:shopField k&ouml;nnen verschiedene Felder direkt bei Artikeln, bzw. im Warenkorb (Bestellung) abgespeichert werden. Diese Felder k&ouml;nnen vom Administrator mit verschiedenen Werten festgelegt werden, die der Endkunde dann einstellen kann. Neben Artikel-Varianten ist es damit m&ouml;glich, eine Vielzahl von verschiedenen Artikelvariationen auf einfache Weise abzubilden.";
$l_we_tag['shopVat']['description'] = "Mit we:shopVat ist es m&ouml;glich einen Mehrwertsteuersatz f&uuml;r einen Artikel festzulegen. Mehrwertsteuers&auml;tze k&ouml;nnen direkt im Shop Modul gepflegt werden. Ist Id gesetzt, wird der Mehrwertsteuersatz mit der angegebenen Id ausgegeben.";
$l_we_tag['showShopItemNumber']['description'] = "Das we:showShopItemNumber-Tag zeigt die im Warenkorb vorhandene Anzahl der Artikel eines Typs an. ";
$l_we_tag['sidebar']['description'] = "Dieses Tag dient dazu einen Button im Bearbeitenmodus eines Dokumentes zum &ouml;ffnen einer Webseite in der Sidebar zu &ouml;ffnen einzubinden.";
$l_we_tag['sidebar']['defaultvalue'] = "Sidebar &ouml;ffnen";
$l_we_tag['subscribe']['description'] = "Dieses Tag erzeugt ein Eingabefeld zum Eintragen in die Newsletter-Liste. Mit dem Attribut \"type\" kann bestimmt werden, um welche Art Feld es sich handelt.";
$l_we_tag['sum']['description'] = "Das we:sum-Tag addiert alle Zahlen in einer Liste zusammen.";
$l_we_tag['target']['description'] = "Dieses Tag dient dazu, innerhalb von &lt;we:linklist&gt; das Linkziel auszugeben.";
$l_we_tag['textarea']['description'] = "Das we:textarea-Tag erzeugt ein mehrzeiliges Eingabefeld.";
$l_we_tag['title']['description'] = "Das we:title-Tag erzeugt ein normales title-Tag. Alles, was zwischen dem Start- und Endtag steht, wird als default-Titel eingetragen, falls das Titelfeld in der Ansicht \"Eigenschaft\" leer ist. Ansonsten wird der Titel aus dieser Ansicht eingetragen.";
$l_we_tag['tr']['description'] = "Das &lt;we:tr&gt; Tag entspricht dem HTML-tag &lt;tr&gt; und dient der Definition einer Tabellenzeile.<br />Beim Einsatz in einer Listview erzwingt der Tag alle x Datens&auml;tze eine neue Tabellenzeile, wobei x die Anzahl der im Listview Parameter cols eingestellten Spalten ist.";
$l_we_tag['tr']['defaultvalue'] = "";
$l_we_tag['unsubscribe']['description'] = "Dieses Tag erzeugt ein Eingabefeld zum Austragen aus der Newsletter-Liste. Dieser Tag muss innerhalb eines Formulars platziert werden.<br />Auf der Folgeseite muss der Tag &lt;we:addDelNewsletterEmail/&gt; vorhanden sein, bei diesem legen Sie auch den Speicherort der CSV Empf&auml;ngerlisten fest, aus denen der Empf&auml;nger ausgetragen werden soll.";
$l_we_tag['url']['description'] = "Das we:url-Tag erzeugt eine webEdition-interne URL, die auf das Dokument mit der unten angegebenen ID verlinkt.";
$l_we_tag['userInput']['description'] = "Das we:userInput-Tag erzeugt Eingabefelder um in Verbindung mit we:form type=\"document\" bzw. type=\"object\" Dokumente oder Objekte zu erzeugen.";
$l_we_tag['useShopVariant']['description'] = "Das we:shopVariant-Tag &uuml;bernimmt die Daten einer per Namen &uuml;bergebenen Artikel-Variante. Existiert kein Artikel-Variante mit gegebenem Namen, wird der Original-Artikel verwendet.";
$l_we_tag['var']['description'] = "Das we:var-Tag zeigt den Inhalt einer globalen Php-Variablen bzw. den Inhalt eines Dokumentfeldes mit dem unten eingegebenen Namen an.";
$l_we_tag['voting']['description'] = "Das we:voting-Tag wird ben&ouml;tigt, um Votings darzustellen.";
$l_we_tag['voting']['defaultvalue'] = "";
$l_we_tag['votingField']['description'] = "Das we:votingField-Tag wird ben&ouml;tigt, um den Inhalt eines Votings anzuzeigen. Das Attribut name definiert den zu zeigenden Inhalt, das Attribut type die Art der Anzeige. G&uuml;ltige name-type Kombinationen sind: question - text; result - count, percent, total; id - answer, select, radio, voting; answer - text, radio, checkbox (Mehrfachauswahl), select (Mehrfachauswahl), textinput und textarea (freies Textantwortfeld), image (hier sind alle we:img Attribute wie thumbnail usw. m&ouml;glich), media (liefert &uuml;ber to und nameto den Pfad der Datei); ";
$l_we_tag['votingList']['description'] = "Mit diesem Tag k&ouml;nnen Sie automatisch Listen &uuml;ber Ihre Votings generieren.";
$l_we_tag['votingList']['defaultvalue'] = "";
$l_we_tag['votingSelect']['description'] = "Mit diesem Tag wird ein DropDown-Men&uuml; (&lt;select&gt;) erzeugt, mit dem es m&ouml;glich ist, ein Voting auszuw&auml;hlen.";
$l_we_tag['write']['description'] = "Das we:write Tag schreibt ein zuvor mit &lt;we:form type=\"document/object\"&gt; erzeugtes webEdition Dokument/Objekt.";
$l_we_tag['writeShopData']['description'] = "Das we:writeShopData-Tag schreibt alle Daten des aktuellen Warenkorbs in die Datenbank.";
$l_we_tag['writeVoting']['description'] = "Dieses Tag schreibt ein Voting in die Datenbank. Falls das Attribut \"id\" definiert ist, wird nur das Voting mit dieser id gespeichert.<br /><br />Hinweis:  WICHTIG! Das Tag &lt;we:writeVoting/&gt; muss in der allerersten Zeile der Vorlage stehen, in der es verwendet wird. Andernfalls ist eine &Uuml;berpr&uuml;fung des Abstimmungsintervalls per COOKIE nicht m&ouml;glich!";
$l_we_tag['xmlfeed']['description'] = "Das we:xmlfeed Tag l&auml;dt den XML-Inhalt von der eingegebenen URL.";
$l_we_tag['xmlnode']['description'] = "Das we:xmlnode Tag erzeugt ein XML-Element aus einem vorgegebenen XML-Feed oder URL.";
$l_we_tag['xmlnode']['defaultvalue'] = "";
$l_we_tag['ifbannerexists']['description'] = "F&uuml;hrt den eingeschlossenen Code nur aus, wenn das Banner-Modul nicht deaktiviert wurde (Einstellungsdialog).";
$l_we_tag['ifbannerexists']['defaultvalue'] = "";
$l_we_tag['ifcustomerexists']['description'] = "F&uuml;hrt den eingeschlossenen Code nur aus, wenn das Kundenverwaltungs-Modul nicht deaktiviert wurde (Einstellungsdialog).";
$l_we_tag['ifcustomerexists']['defaultvalue'] = "";
$l_we_tag['ifnewsletterexists']['description'] = "F&uuml;hrt den eingeschlossenen Code nur aus, wenn das Newsletter-Modul nicht deaktiviert wurde (Einstellungsdialog).";
$l_we_tag['ifnewsletterexists']['defaultvalue'] = "";
$l_we_tag['ifobjektexists']['description'] = "F&uuml;hrt den eingeschlossenen Code nur aus, wenn das Objekt/DB-Modul nicht deaktiviert wurde (Einstellungsdialog).";
$l_we_tag['ifobjektexists']['defaultvalue'] = "";
$l_we_tag['ifshopexists']['description'] = "F&uuml;hrt den eingeschlossenen Code nur aus, wenn das Shop-Modul nicht deaktiviert wurde (Einstellungsdialog).";
$l_we_tag['ifshopexists']['defaultvalue'] = "";
$l_we_tag['ifvotingexists']['description'] = "F&uuml;hrt den eingeschlossenen Code nur aus, wenn das Voting-Modul nicht deaktiviert wurde (Einstellungsdialog).";
$l_we_tag['ifvotingexists']['defaultvalue'] = "";
$l_we_tag['ifNotHasShopVariants']['description'] = "Mit &lt;we:ifNotHasShopVariants&gt; kann ein Inhalt bedingt nur dann angezeigt werden, wenn ein Dokument, Objekt KEINE Varianten enth&auml;lt. Damit kann bspw. kontrolliert werden, ob eine &lt;we:listview type=\"shopVariant\"&gt; &uuml;berhaupt angezeigt werden soll bzw. was alternativ angezeigt werden soll.";
$l_we_tag['ifNotHasShopVariants']['defaultvalue'] = "";
$l_we_tag['ifNotHasChildren']['description'] = "Innerhalb des we:repeat Tags kann mit &lt;we:ifNotHasChildren&gt; abgefragt werden, ob der aktuelle Kategorie-Ordner Kategorien enth&auml;lt bzw. die Kategorie Kinder hat.";
$l_we_tag['ifNotHasChildren']['defaultvalue'] = "";
$l_we_tag['ifNotHasCurrentEntry']['description'] = "Mit we:ifNotHasCurrentEntry kann innerhalb eines we:navigationEntry type=\"folder\" Inhalt nur dann ausgegeben werden, wenn der auszugebende Navigationsordner NICHT den aktiven Eintrag besitzt.";
$l_we_tag['ifNotHasCurrentEntry']['defaultvalue'] = "";
$l_we_tag['ifNotHasEntries']['description'] = "Mit we:ifNotHasEntries kann innerhalb eines we:navigationEntry Inhalt nur ausgegeben werden, wenn der auszugebende Navigationseintrag KEINE Eintr&auml;ge besitzt";
$l_we_tag['ifNotHasEntries']['defaultvalue'] = "";
$l_we_tag['ifPageLanguage']['description'] = "Mit we:ifPageLanguage kann auf die Spracheinstellung des Dokumentes getestet werden, dabei k&ouml;nnen mehrere Werte durch Komma separiert angegeben werden (oder-Verkn&uuml;pfung). Die m&ouml;glichen Werte ergeben sich aus dem Einstellungsdialog, Tab 'Sprachen'.";
$l_we_tag['ifPageLanguage']['defaultvalue'] = "";
$l_we_tag['ifNotPageLanguage']['description'] = "Mit we:ifNotPageLanguage kann auf die Spracheinstellung des Dokumentes getestet werden, dabei k&ouml;nnen mehrere Werte durch Komma separiert angegeben werden (oder-Verkn&uuml;pfung). Die m&ouml;glichen Werte ergeben sich aus dem Einstellungsdialog, Tab 'Sprachen'.";
$l_we_tag['ifNotPageLanguage']['defaultvalue'] = "";
$l_we_tag['ifObjectLanguage']['description'] = "Mit we:ifObjectLanguage kann auf die Spracheinstellung des Objectes getestet werden, dabei k&ouml;nnen mehrere Werte durch Komma separiert angegeben werden (oder-Verkn&uuml;pfung). Die m&ouml;glichen Werte ergeben sich aus dem Einstellungsdialog, Tab 'Sprachen'.";
$l_we_tag['ifObjectLanguage']['defaultvalue'] = "";
$l_we_tag['ifNotObjectLanguage']['description'] = "Mit we:ifObjectLanguage kann auf die Spracheinstellung des Objectes getestet werden, dabei k&ouml;nnen mehrere Werte durch Komma separiert angegeben werden (oder-Verkn&uuml;pfung). Die m&ouml;glichen Werte ergeben sich aus dem Einstellungsdialog, Tab 'Sprachen'.";
$l_we_tag['ifNotObjectLanguage']['defaultvalue'] = "";
$l_we_tag['ifSendMail']['description'] = "Pr&uuml;ft, ob eine Seite gerade mit we:sendMail versendet wird und erlaubt Inhalte dabei aus- und einzublenden";
$l_we_tag['ifSendMail']['defaultvalue'] = "";
$l_we_tag['ifNotSendMail']['description'] = "Pr&uuml;ft, ob eine Seite gerade mit we:sendMail versendet wird und erlaubt Inhalte dabei aus- und einzublenden";
$l_we_tag['ifNotSendMail']['defaultvalue'] = "";
$l_we_tag['ifVoteIsRequired']['description'] = "Alles, was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das Voting ein Pflichtfeld ist.";
$l_we_tag['ifVoteIsRequired']['defaultvalue'] = "";
$l_we_tag['ifNotVoteActive']['description'] = "Alles, was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das Voting abgelaufen ist.";
$l_we_tag['ifNotVoteActive']['defaultvalue'] = "";
$l_we_tag['ifNotVoteIsRequired']['description'] = "Alles, was sich zwischen Start- und Endtag befindet, wird nur angezeigt, wenn das Voting kein Pflichtfeld ist.";
$l_we_tag['ifNotVoteIsRequired']['defaultvalue'] = "";
$l_we_tag['pageLanguage']['description'] = "Gibt die dem Dokument zugewiesene Sprache aus";
$l_we_tag['pageLanguage']['defaultvalue'] = "";
$l_we_tag['objectLanguage']['description'] = "Gibt die dem Objekt zugewiesene Sprache aus";
$l_we_tag['objectLanguage']['defaultvalue'] = "";

$l_we_tag['ifVotingField']['description'] = "&Uuml;berpr&uuml;ft ob ein VotingField einen Wert entsprechend dem Attribut match hat, die Kombinationen von name und type Attributen entsprechen denen des we:votingFiled-Tags";
$l_we_tag['ifNotVotingField']['description'] = "&Uuml;berpr&uuml;ft ob ein VotingField keinen Wert entsprechend dem Attribut match hat, die Kombinationen von name und type Attributen entsprechen denen des we:votingFiled-Tags";
$l_we_tag['ifVotingFieldEmpty']['description'] = "&Uuml;berpr&uuml;ft ob ein VotingField leer ist, die Kombinationen von name und type Attributen entsprechen denen des we:votingFiled-Tags";
$l_we_tag['ifVotingFieldNotEmpty']['description'] = "&Uuml;berpr&uuml;ft ob ein VotingField nicht leer ist, die Kombinationen von name und type Attributen entsprechen denen des we:votingFiled-Tags";
$l_we_tag['ifVotingIsRequired']['description'] = "Gibt des umschlossenen Inhalt nur aus, wenn das Voting-Feld ein Pflichtfeld ist";
$l_we_tag['ifNotVotingIsRequired']['description'] = "Gibt des umschlossenen Inhalt nur aus, wenn das Voting-Feld kein Pflichtfeld ist";
$l_we_tag['votingSession']['description'] = "Generiert einen eindeutigen Identifier, der mit ins Voting-Log aufgenommen wird und so erlaubt, die Antworten zu verschienenen Fragen einer Befragung einander zuzuordnen";

?>