<?php

/**
 * webEdition CMS
 *
 * This source is part of webEdition CMS. webEdition CMS is
 * free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * The GNU General Public License can be found at
 * http://www.gnu.org/copyleft/gpl.html.
 * A copy is found in the textfile
 * webEdition/licenses/webEditionCMS/License.txt
 *
 * @category   webEdition
 * @package    webEdition_language
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL
 */


/**
 * Language file: global.inc.php
 *
 * Provides language strings.
 *
 * Language: Deutsch
 */

include_once(dirname(__FILE__)."/enc_".basename(__FILE__));

/*****************************************************************************
 * LOGIN-SCREEN
 *****************************************************************************/

$l_button["login"]["value"] = "Login";
$l_button["login"]["alt"] = "An webEdition anmelden";
$l_button["login"]["width"] = 100;

$l_button["back_to_login"]["value"] = "Zurück";
$l_button["back_to_login"]["alt"] = "Zurück zum webEdition-Login";
$l_button["back_to_login"]["width"] = 100;

/*****************************************************************************
 * STARTMENU
 *****************************************************************************/

$l_button["open_document"]["value"] = "Dokument öffnen";
$l_button["open_document"]["alt"] = "";
$l_button["open_document"]["width"] = 200;

$l_button["new_document"]["value"] = "Neues Dokument";
$l_button["new_document"]["alt"] = "Neues Dokument erstellen";
$l_button["new_document"]["width"] = 200;

$l_button["new_template"]["value"] = "Neue Vorlage";
$l_button["new_template"]["alt"] = "Neue Vorlage erstellen";
$l_button["new_template"]["width"] = 200;

$l_button["new_directory"]["value"] = "Neues Verzeichnis";
$l_button["new_directory"]["alt"] = "Neues Verzeichnis erstellen";
$l_button["new_directory"]["width"] = 200;

$l_button["unpublished_pages"]["value"] = "Unveröffentlichte Dokumente";
$l_button["unpublished_pages"]["alt"] = "Überblick über die unveröffentlichten Dokumente";
$l_button["unpublished_pages"]["width"] = 200;

$l_button["preferences"]["value"] = "Einstellungen";
$l_button["preferences"]["alt"] = "Die Einstellungen von webEdition bearbeiten";
$l_button["preferences"]["width"] = 200;

/*****************************************************************************
 * DELETE SCREEN
 *****************************************************************************/

$l_button["quit_delete"]["value"] = "Lösch-Modus beenden";
$l_button["quit_delete"]["alt"] = "";
$l_button["quit_delete"]["width"] = 200;

/*****************************************************************************
 * MOVE SCREEN
 *****************************************************************************/

$l_button["quit_move"]["value"] = "Verschieben-Modus beenden";
$l_button["quit_move"]["alt"] = "";
$l_button["quit_move"]["width"] = 250;

/*****************************************************************************
 * STANDARD
 *****************************************************************************/

$l_button["ok"]["value"] = "OK";
$l_button["ok"]["alt"]   = "";
$l_button["ok"]["width"] = 100;

$l_button["cancel"]["value"] = "Abbrechen";
$l_button["cancel"]["alt"]   = "";
$l_button["cancel"]["width"] = 100;

$l_button["yes"]["value"] = "Ja";
$l_button["yes"]["alt"]   = "";
$l_button["yes"]["width"] = 100;

$l_button["no"]["value"] = "Nein";
$l_button["no"]["alt"]   = "";
$l_button["no"]["width"] = 100;

$l_button["save"]["value"] = "Speichern";
$l_button["save"]["alt"]   = "";
$l_button["save"]["width"] = 100;

$l_button["publish"]["value"] = "Veröffentlichen";
$l_button["publish"]["alt"]   = "Speichert und veröffentlicht das Dokument";
$l_button["publish"]["width"] = 120;

$l_button["saveversion"]["value"] = "Speichere Version";
$l_button["saveversion"]["alt"]   = "Speichert und legt eine neue Version an";
$l_button["saveversion"]["width"] = 120;

$l_button["delete"]["value"] = "Löschen";
$l_button["delete"]["alt"]   = "";
$l_button["delete"]["width"] = 100;

$l_button["go"]["value"] = "Jetzt ausführen";
$l_button["go"]["alt"]   = "";
$l_button["go"]["width"] = 120;

$l_button["openVersionWizard"]["value"] = "Versions-Wizard";
$l_button["openVersionWizard"]["alt"]   = "Versions-Wizard";
$l_button["openVersionWizard"]["width"] = 120;

$l_button["next"]["value"] = "Weiter";
$l_button["next"]["alt"]   = "";
$l_button["next"]["width"] = 100;

$l_button["back"]["value"] = "Zurück";
$l_button["back"]["alt"] = "";
$l_button["back"]["width"] = 100;

$l_button["open"]["value"] = "Öffnen";
$l_button["open"]["alt"] = "";
$l_button["open"]["width"] = 100;

$l_button["default"]["value"] = "Standard";
$l_button["default"]["alt"] = "";
$l_button["default"]["width"] = 100;

$l_button["reset"]["value"] = "Zurücksetzen";
$l_button["reset"]["alt"]   = "";
$l_button["reset"]["width"] = 100;


/*****************************************************************************
 * SAVING, PUBLISHING, ETC.
 *****************************************************************************/

$l_button["unpublish"]["value"] = "Parken";
$l_button["unpublish"]["alt"] = "";
$l_button["unpublish"]["width"] = 100;


/*****************************************************************************
 * MAKE AN NEW DOCUMENT BASED ON TEMPLATE
 *****************************************************************************/

$l_button["make_new_document"]["value"] = "Neues Dokument";
$l_button["make_new_document"]["alt"] = "Neues Dokument erstellen";
$l_button["make_new_document"]["width"] = 125;

/*****************************************************************************
 * SUPER-EASY-EDIT-MODE
 *****************************************************************************/

$l_button["preview"]["value"] = "Vorschau";
$l_button["preview"]["alt"] = "Vorschau anzeigen";
$l_button["preview"]["width"] = 100;

$l_button["properties"]["value"] = "Eigenschaften";
$l_button["properties"]["alt"] = "Eigenschaften anzeigen";
$l_button["properties"]["width"] = 100;

$l_button["thumbnails"]["value"] = "Miniaturansichten";
$l_button["thumbnails"]["alt"] = "Miniaturansichten anzeigen";
$l_button["thumbnails"]["width"] = 100;

$l_button["shopVariants"]["value"] = "Varianten";
$l_button["shopVariants"]["alt"] = "Varianten bearbeiten";
$l_button["shopVariants"]["width"] = 100;

/*****************************************************************************
 * DOCUMENT TYPES
 *****************************************************************************/

$l_button["new_doctype"]["value"] = "Neuer Dokument-Typ";
$l_button["new_doctype"]["alt"] = "Einen neuen Dokumenten Typ erstellen";
$l_button["new_doctype"]["width"] = 174;

$l_button["delete_doctype"]["value"] = "Dokument-Typ löschen";
$l_button["delete_doctype"]["alt"] = "Den ausgewählten Dokument-Typen löschen";
$l_button["delete_doctype"]["width"] = 174;

/*****************************************************************************
 * XML
 *****************************************************************************/

$l_button["import"]["value"] = "Importieren";
$l_button["import"]["alt"] = "Ausgewählte Datei importieren";
$l_button["import"]["width"] = 100;

$l_button["export"]["value"] = "Exportieren";
$l_button["export"]["alt"] = "Ausgewählte Dateien exportieren";
$l_button["export"]["width"] = 100;

$l_button["browse"]["value"] = "Durchsuchen";
$l_button["browse"]["alt"] = "Verzeichnis durchsuchen";
$l_button["browse"]["width"] = 100;

/*****************************************************************************
 * FILE-SELECTOR
 *****************************************************************************/

$l_button["root_dir"]["value"] = "/";
$l_button["root_dir"]["alt"]   = "Zum Hauptverzeichnis";
$l_button["root_dir"]["width"] = 40;


/*****************************************************************************
 * UPLOAD DIALOG
 *****************************************************************************/

$l_button["upload"]["value"] = "Hochladen";
$l_button["upload"]["alt"]   = "Datei hochladen";
$l_button["upload"]["width"] = 100;

$l_button["close"]["value"] = "Schließen";
$l_button["close"]["alt"]   = "Das Fenster schließen";
$l_button["close"]["width"] = 100;

$l_button["overwrite"]["value"] = "Überschreiben";
$l_button["overwrite"]["alt"]   = "Datei überschreiben";
$l_button["overwrite"]["width"] = 100;

$l_button["newName"]["value"] = "Neuer Name";
$l_button["newName"]["alt"]   = "Einen neuen Namen eingeben";
$l_button["newName"]["width"] = 100;


/*****************************************************************************
 * PREFERENCES
 *****************************************************************************/

$l_button["add_languages"]["value"] = "Sprachen hinzufügen";
$l_button["add_languages"]["alt"]   = "Installiert weitere Sprachen für webEdition";
$l_button["add_languages"]["width"] = 175;

$l_button["apply_current_dimension"]["value"] = "Aktuelle Größe übernehmen";
$l_button["apply_current_dimension"]["alt"]   = "Übernimmt die aktuelle Größe des webEdition Fensters";
$l_button["apply_current_dimension"]["width"] = 175;

$l_button["res_800"]["value"] = "800x600";
$l_button["res_800"]["alt"]   = "800x600 einstellen";
$l_button["res_800"]["width"] = 100;

$l_button["res_1024"]["value"] = "1024x768";
$l_button["res_1024"]["alt"]   = "1024x768 einstellen";
$l_button["res_1024"]["width"] = 100;

$l_button["res_1280"]["value"] = "1280x960";
$l_button["res_1280"]["alt"]   = "1280x960 einstellen";
$l_button["res_1280"]["width"] = 100;

$l_button["res_1600"]["value"] = "1600x1200";
$l_button["res_1600"]["alt"]   = "1600x1200 einstellen";
$l_button["res_1600"]["width"] = 100;

$l_button["apply_current_editor_dimension"]["value"] = "Aktuelle Größe übernehmen";
$l_button["apply_current_editor_dimension"]["alt"]   = "Übernimmt die aktuelle Größe des Editors";
$l_button["apply_current_editor_dimension"]["width"] = 175;

$l_button["res_500"]["value"] = "500x300";
$l_button["res_500"]["alt"]   = "500x300 einstellen";
$l_button["res_500"]["width"] = 100;

$l_button["res_700"]["value"] = "700x320";
$l_button["res_700"]["alt"]   = "700x320 einstellen";
$l_button["res_700"]["width"] = 100;

$l_button["res_960"]["value"] = "960x420";
$l_button["res_960"]["alt"]   = "960x420 einstellen";
$l_button["res_960"]["width"] = 100;

$l_button["res_1300"]["value"] = "1300x650";
$l_button["res_1300"]["alt"]   = "1300x650 einstellen";
$l_button["res_1300"]["width"] = 100;

/*****************************************************************************
 * Rebuild
 *****************************************************************************/

$l_button["rebuild"]["value"] = "Rebuild";
$l_button["rebuild"]["alt"]   = "Rebuild starten";
$l_button["rebuild"]["width"] = 100;

/*****************************************************************************
 * UPDATE
 *****************************************************************************/

$l_button["demoversion"]["value"] = "Demoversion";
$l_button["demoversion"]["alt"]   = "";
$l_button["demoversion"]["width"] = 100;

$l_button["register"]["value"] = "Registrieren";
$l_button["register"]["alt"]   = "";
$l_button["register"]["width"] = 100;

$l_button["backup"]["value"] = "Backup";
$l_button["backup"]["alt"]   = "";
$l_button["backup"]["width"] = 100;

$l_button["search"]["value"] = "Suche";
$l_button["search"]["alt"]   = "";
$l_button["search"]["width"] = 100;

/*****************************************************************************
 * Backup
 *****************************************************************************/

$l_button["restore_backup"]["value"] = "Backup wiederherstellen";
$l_button["restore_backup"]["alt"]   = "";
$l_button["restore_backup"]["width"] = 180;

$l_button["make_backup"]["value"] = "Backup erstellen";
$l_button["make_backup"]["alt"]   = "";
$l_button["make_backup"]["width"] = 150;

$l_button["delete_backup"]["value"] = "Backup-Datei löschen";
$l_button["delete_backup"]["alt"]   = "";
$l_button["delete_backup"]["width"] = 150;

/*****************************************************************************
 * Thumbnails
 *****************************************************************************/

$l_button["edit_all_thumbs"]["value"] = "Miniaturansichten bearbeiten...";
$l_button["edit_all_thumbs"]["alt"]   = "";
$l_button["edit_all_thumbs"]["width"] = 220;


/*****************************************************************************
 * Navigation
 *****************************************************************************/
$l_button["new_item"]["value"] = "Neuer Eintrag";
$l_button["new_item"]["alt"]   = "";
$l_button["new_item"]["width"] = 200;

$l_button["new_folder"]["value"] = "Neuer Ordner";
$l_button["new_folder"]["alt"]   = "";
$l_button["new_folder"]["width"] = 200;

/*****************************************************************************
 * Logbuch Formmail
 *****************************************************************************/
$l_button["clear_log"]["value"] = "Logbuch leeren";
$l_button["clear_log"]["alt"] = "";
$l_button["clear_log"]["width"] = 120;

$l_button["logbook"]["value"] = "Logbuch";
$l_button["logbook"]["alt"]   = "";
$l_button["logbook"]["width"] = 100;

/*****************************************************************************
 * Info
 *****************************************************************************/
$l_button["revert_published"]["value"] = "Veröffentlichte Version wiederherstellen";
$l_button["revert_published"]["alt"] = "Änderungen verwerfen und veröffentlichte Version wiederherstellen.";
$l_button["revert_published"]["width"] = 220;

?>