<?php

/**
 * webEdition CMS
 *
 * This source is part of webEdition CMS. webEdition CMS is
 * free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * The GNU General Public License can be found at
 * http://www.gnu.org/copyleft/gpl.html.
 * A copy is found in the textfile
 * webEdition/licenses/webEditionCMS/License.txt
 *
 * @category   webEdition
 * @package    webEdition_language
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL
 */

/**
 * Language file: glossary.inc.php
 * Provides language strings.
 * Language: German
 */

$l_glossary = array();

$l_glossary["save_changed_glossary"] = "Der Eintrag wurde geändert.\\nMöchten Sie Ihre Änderungen speichern?";
$l_glossary['glossary_check_not_avalaible'] = "Die Glossarprüfung steht für diesen Dateityp nicht zur Verfügung.";

$l_glossary['please_choose'] = "bitte wählen";
$l_glossary['not_identified_words'] = "Folgende Wörter konnten nicht identifiziert werden:";
$l_glossary['not_found'] = "nicht erkannte Begriffe";
$l_glossary['announced_word'] = "ausgeschrieben";
$l_glossary['not_known_words'] = "nicht erkannte Begriffe";
$l_glossary['not_known_word'] = "nicht erkannt";
$l_glossary['to_exceptionlist'] = "in Ausnahmeliste";
$l_glossary['ignore'] = "ignorieren";
$l_glossary['correct_word'] = "Wort korrigieren";
$l_glossary['to_dictionary'] = "ins Wörterbuch";
$l_glossary['change_to'] = "ändern in";
$l_glossary['input'] = "Eingabe";
$l_glossary['languages'] = "Sprachen";
$l_glossary['action'] = "Aktion";

$l_glossary['hint_exception'] = "Die hier eingetragenen Begriffe werden bei der Glossarprüfung ignoriert. Bitte immer nur ein Begriff pro Zeile eintragen.";
$l_glossary['show_extended_linkoptions'] = "erweiterte Linkeigenschaften einblenden";
$l_glossary['hide_extended_linkoptions'] = "erweiterte Linkeigenschaften ausblenden";

$l_glossary['check_successful'] = "Die Glossarprüfung wurde erfolgreich abgeschlossen.";
$l_glossary['check_successful_and_publish'] = "Die Glossarprüfung wurde erfolgreich abgeschlossen.";
$l_glossary['glossary_check'] = "Glossarprüfung";
$l_glossary['checking'] = "Die Glossarprüfung wird durchgeführt...";
$l_glossary['download'] = "Lade Wörterbücher...";


$l_glossary['acronym'] = "Akronym";
$l_glossary['acronym_description'] = "Ein Akronym ist eine besondere Abkürzung, die aus den Anfangsbuchstaben mehrerer (Teil-) Wörter gebildet wird. Es wird im Deutschen in der Regel ohne Punkt gebildet ('Lkw'). Ein Akronym lässt sich darüber hinaus meist als Wort aussprechen (z. B. 'NATO').";
$l_glossary['abbreviation'] = "Abkürzung";
$l_glossary['abbreviation_description'] = "Abkürzung (auch Abbreviatur, Kürzel) bezeichnet die verkürzte Form eines Wortes oder einer Wortgruppe. Hierzu gehören Akronyme, Kurzwörter, Initialwörter und Buchstabenketten. Was man abkürzt, ist auch gesellschaftlich bedingt. So erscheinen Abkürzungen wie AB für Anrufbeantworter oder HP für Homepage als regional, national oder durch die Textsorte begrenzt. Eine Abkürzung ist eine Schreib- und Leseerleichterung, sie dient der schnelleren und konzentrierteren Kommunikation. Des Weiteren dient die Abkürzung auch der Platzersparnis.";
$l_glossary['foreignword'] = "Fremdwort";
$l_glossary['foreignword_description'] = "Ein Fremdwort ist ein Wort, das aus einer anderen Sprache übernommen wurde und das sich in Lautstand, Betonung oder Schreibung der Zielsprache (noch) nicht angepasst hat, so dass es als fremd empfunden wird.";
$l_glossary['link'] = "Hyperlink";
$l_glossary['link_description'] = "Als Hyperlink, auch kurz Link (aus dem Englischen für Verknüpfung, Verbindung, Verweis), bezeichnet man einen Verweis auf ein anderes Dokument in einem Hypertext, der durch das Hypertextsystem automatisch verfolgt werden kann.";
$l_glossary['exception'] = "Ausnahmen";

$l_glossary['new_item_after_saving'] = "Nach Speichern neuen Eintrag";
$l_glossary['publish_when_saved'] = "Beim Speichern aktivieren";

$l_glossary['menu_new'] = 'Neu';
$l_glossary['menu_save'] = 'Speichern';
$l_glossary['menu_delete'] = 'Löschen';
$l_glossary['menu_exit'] = 'Schließen';
$l_glossary['menu_info'] = 'Info';
$l_glossary['menu_options'] = 'Optionen';
$l_glossary['menu_settings'] = 'Einstellungen';
$l_glossary['menu_dictionaries'] = 'Wörterbücher';
$l_glossary['menu_help'] = 'Hilfe';

$l_glossary['show'] = 'Zeige';
$l_glossary['date_published'] = 'Aktiviert';
$l_glossary['date_modified'] = 'Geändert';
$l_glossary['property'] = 'Eigenschaften';
$l_glossary['overview'] = 'Übersicht';
$l_glossary['path'] = 'Pfad';
$l_glossary['folder'] = 'Ordner';
$l_glossary['type'] = 'Typ';
$l_glossary['glossarylanguage'] = "Glossarsprache";
$l_glossary['announced_word'] = "Title-Attribut";
$l_glossary['suggestion'] = "Vorschlag";
$l_glossary['suggestions'] = "Vorschläge";
$l_glossary['corrected'] = "korrigiert";
$l_glossary['link_url'] = "Link URL";
$l_glossary['link_mode'] = "Linktyp";
$l_glossary['language'] = "Sprache";
$l_glossary['search'] = "Suche";
$l_glossary['view'] = "Ansicht";
$l_glossary['show_only_visible_items'] = "Zeige nur sichtbare Einträge";
$l_glossary['delete_selected_items'] = "Ausgewählte Einträge löschen.";
$l_glossary['publish_selected_items'] = "Ersetzung ausgewählter Einträge aktivieren.";
$l_glossary['unpublish_selected_items'] = "Ersetzung ausgewählter Einträge deaktivieren.";
$l_glossary["confirm_delete"] = "Sind Sie sicher, dass Sie die ausgewählten Einträge löschen wollen?";
$l_glossary["confirm_publish"] = "Sind Sie sicher, dass Sie die ausgewählten Einträge aktivieren wollen?";
$l_glossary["confirm_unpublish"] = "Sind Sie sicher, dass Sie die ausgewählten Einträge deaktivieren wollen?";

$l_glossary['no_entries_found'] = 'Es wurden keine Einträge gefunden.';
$l_glossary['no_perms'] = 'Sie haben nicht die Berechtigung, diese Option auszuwählen.';
$l_glossary['name_empty'] = 'Der Eintrag darf nicht leer sein!';
$l_glossary['title_empty'] = 'Das Feld "Title" darf nicht leer sein!';
$l_glossary['lang_empty'] = 'Das Feld "Sprache" darf nicht leer sein!';
$l_glossary['name_exists'] = 'Der Eintrag existiert bereits!';
$l_glossary['entry_saved'] = 'Der Eintrag wurde im Glossar gespeichert!';
$l_glossary['path_nok'] = 'Der Pfad ist nicht korrekt!';
$l_glossary['save_ok'] = 'Eintrag wurde gespeichert.';
$l_glossary['nothing_to_delete'] = 'Nichts zu löschen!';
$l_glossary['delete_alert'] = 'Aktuellen Eintrag löschen.\\nSind Sie sich sicher?';
$l_glossary['nothing_to_save'] = 'Nichts zu speichern';
$l_glossary['group_deleted'] = 'Die Gruppe wurde erfolgreich gelöscht.';
$l_glossary['item_deleted'] = 'Der Eintrag wurde erfolgreich gelöscht.';
$l_glossary['item_is_active'] = 'Eintrag ist aktiv';

$l_glossary['glossary'] = 'Glossar';

$l_glossary['link_intern'] = 'Internes Dokument';
$l_glossary['link_extern'] = 'Externes Dokument';
$l_glossary['link_object'] = 'Objekt';
$l_glossary['link_category'] = 'Kategorie';
$l_glossary['workspace'] = 'Arbeitsbereich';
$l_glossary['link_selection'] = 'Link Auswahl';

$l_glossary['selection'] = 'Auswahl';
$l_glossary['no_workspace'] = 'Das Objekt hat keinen Arbeitsbereich definiert! Deshalb ist die Auswahl des Objektes nicht möglich!';

$l_glossary['attributes'] = 'Attribute';
$l_glossary['parameter'] = 'Parameter';
$l_glossary['parameter_name'] = 'Name des Kategorie Parameters';
$l_glossary['title'] = 'Title';
$l_glossary['anchor'] = 'Anker';
$l_glossary['language'] = 'Sprache';
$l_glossary['target'] = 'Linkziel';
$l_glossary['link_language'] = 'Link';
$l_glossary['href_language'] = 'verlinkte Seite';
$l_glossary['keyboard'] = 'Tastatur';
$l_glossary['accesskey'] = 'Accesskey';
$l_glossary['tabindex'] = 'Tabindex';
$l_glossary['relation'] = 'Beziehung';
$l_glossary['link_attribute'] = 'Link Attribute';
$l_glossary['popup'] = 'Popup Fenster';
$l_glossary['popup_open'] = 'Öffnen';
$l_glossary['popup_center'] = 'Zentrieren';
$l_glossary['popup_x'] = 'x Position';
$l_glossary['popup_y'] = 'y Position';
$l_glossary['popup_width'] = 'Breite';
$l_glossary['popup_height'] = 'Höhe';
$l_glossary['popup_status'] = 'Status';
$l_glossary['popup_scrollbars'] = 'Scrollbars';
$l_glossary['popup_menubar'] = 'Menubar';
$l_glossary['popup_resizable'] = 'Resizable';
$l_glossary['popup_location'] = 'Location';
$l_glossary['popup_toolbar'] = 'Toolbar';

$l_glossary['linkprops_desc'] = 'Hier können Sie die zusätzlichen Link-Eigenschaften definieren. Für die dynamischen Einträge werden nur die Link-Eigenschaften Linkziel und Popup-Fenster verwendet.';
$l_glossary['text_notValid'] = "Der Text enthält ungültige Zeichen. Zu diesen gehören $, | und \\\\.";
$l_glossary['title_notValid'] = "Der Titel enthält ungültige Zeichen. Zu diesen gehören $, | und \\\\.";


$l_glossary['enable_replacement'] = 'automatische Glossarersetzung aktivieren';
$l_glossary['enabe_dictionary_check'] = 'Glossarprüfung vor veröffentlichen von Dokumenten/Objekten';
$l_glossary['force_action'] = 'Aktion bei nicht erkannten Begriffen erzwingen';
$l_glossary['preferences_saved'] = 'Einstellungen wurden gespeichert!';
$l_glossary['preferences_not_saved'] = 'Einstellungen konnten nicht gespeichert werden!';

$l_glossary['please_choose_action'] = "Bitte wählen Sie die auszuführende Aktion aus.";
$l_glossary['please_insert_correct_word'] = "Bitte tragen Sie das korrekt geschriebene Wort ein.";
$l_glossary['please_insert_language'] = "Bitte wählen Sie die Sprache aus.";
$l_glossary['please_insert_title'] = "Bitte tragen Sie das ausgeschrieben Wort ein.";
$l_glossary['number_of_entries'] = 'Anzahl der Einträge';
$l_glossary['all_words_identified'] = "Keine unbekannten Worte gefunden.";

$l_glossary['no_java'] = 'Es scheint, dass das Java-Plugin nicht installiert oder nicht aktiviert ist. Die Glossarprüfung konnte nicht durchgeführt werden!';

$l_glossary['item_saved'] = "Der Eintrag '%s' wurde erfolgreich gespeichert!";
$l_glossary['replace_deactivated'] = "Die Ersetzung des Eintrages '%s' wurde erfolgreich deaktiviert!";
$l_glossary['replace_activated'] = "Die Ersetzung des Eintrages '%s' wurde erfolgreich aktiviert!";
?>