/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

class IndentBreakAction
extends TextAction {
    private static final long serialVersionUID = 1L;

    public IndentBreakAction() {
        super("insert-break");
    }

    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target == null) {
            return;
        }
        if (!target.isEditable() || !target.isEnabled()) {
            UIManager.getLookAndFeel().provideErrorFeedback(target);
            return;
        }
        try {
            char c;
            Document doc = target.getDocument();
            Element rootElement = doc.getDefaultRootElement();
            int selectionStart = target.getSelectionStart();
            int line = rootElement.getElementIndex(selectionStart);
            int start = rootElement.getElement(line).getStartOffset();
            int end = rootElement.getElement(line).getEndOffset();
            int length = end - start;
            String text = doc.getText(start, length);
            int offset = 0;
            for (offset = 0; offset < length && ((c = text.charAt(offset)) == ' ' || c == '\t'); ++offset) {
            }
            target.replaceSelection("\n" + text.substring(0, offset));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

