/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.eplugin.editor;

import com.livinge.eplugin.editor.WeEditor;
import com.livinge.eplugin.editor.WeSettings;
import com.livinge.eplugin.privileged.PrivilegedCheck;
import com.livinge.eplugin.privileged.PrivilegedMkDirs;
import com.livinge.eplugin.privileged.PrivilegedPrepareEditFile;
import com.livinge.eplugin.privileged.PrivilegedSave;
import com.livinge.eplugin.util.HttpRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;

public class EPDocument {
    protected WeEditor Editor;
    protected String CacheFilename;
    protected String ContentType;
    protected String Transaction;
    protected String SessionId;
    protected long CacheLastSave = 0L;
    protected String Source;
    protected String CmdEntry;
    protected String Encoding;
    protected boolean Check = false;

    public EPDocument() {
        this.CacheFilename = "";
        this.ContentType = "";
        this.Transaction = "";
        this.SessionId = "";
        this.CmdEntry = "";
        this.Encoding = WeSettings.getDefaultEncoding();
    }

    public EPDocument(String session, String trans, String filename, String ct, String cmd) {
        this.CacheFilename = filename;
        this.ContentType = ct;
        this.Transaction = trans;
        this.SessionId = session;
        this.CmdEntry = cmd;
        this.Encoding = WeSettings.getDefaultEncoding();
        PrivilegedMkDirs pmkdir = new PrivilegedMkDirs(new File(this.CacheFilename).getParentFile().getPath());
        AccessController.doPrivileged(pmkdir);
    }

    public void setEditor(WeEditor ed) {
        this.Editor = ed;
    }

    public void setSource(String s) {
        this.Source = s;
    }

    public String getSource() {
        return this.Source;
    }

    public void setCacheFilename(String filename) {
        this.CacheFilename = EPDocument.clearPath(filename);
    }

    public String getCacheFilename() {
        return this.CacheFilename;
    }

    public String getTransaction() {
        return this.Transaction;
    }

    public void setTransaction(String trans) {
        this.Transaction = trans;
    }

    public String getContentType() {
        return this.ContentType;
    }

    public void setContentType(String ct) {
        this.ContentType = ct;
    }

    public String getEncoding() {
        return this.Encoding;
    }

    public void setEncoding(String enc) {
        this.Encoding = enc;
    }

    public void saveSource() {
        PrivilegedMkDirs pmkdir = new PrivilegedMkDirs(new File(this.CacheFilename).getParentFile().getPath());
        AccessController.doPrivileged(pmkdir);
        PrivilegedSave textSave = new PrivilegedSave(this.CacheFilename, this.Source, this.Encoding);
        AccessController.doPrivileged(textSave);
        textSave.setCheck(true);
        AccessController.doPrivileged(textSave);
        this.CacheLastSave = textSave.LastChange;
    }

    public void loadSource() {
        this.Source = "";
        try {
            String str;
            BufferedReader in = WeSettings.isCharsetSupported(this.Encoding) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.CacheFilename), this.Encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.CacheFilename)));
            while ((str = in.readLine()) != null) {
                this.Source = this.Source + str + System.getProperty("line.separator");
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyFromUrl(String url) {
        try {
            PrivilegedPrepareEditFile pcopy = new PrivilegedPrepareEditFile(new URL(url), this.CacheFilename);
            AccessController.doPrivileged(pcopy);
            this.CacheLastSave = this.getLastSave();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String clearPath(String in) {
        String out = "";
        out = in.replace('\\', '/');
        out = out.replaceAll("[/]+", "/");
        if (System.getProperty("os.name").matches("Windows(.)*")) {
            out = out.replace('/', '\\');
        }
        return out;
    }

    public void uploadFile() {
        try {
            HttpRequest fu = new HttpRequest();
            fu.addVariable("we_cmd[0]", "setBinary");
            fu.addVariable("we_transaction", this.Transaction);
            fu.addVariable("contenttype", this.ContentType);
            fu.addFile("uploadfile", this.CacheFilename);
            fu.upload(this.CmdEntry);
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex);
            ex.printStackTrace();
        }
    }

    public long getCacheLastSave() {
        return this.CacheLastSave;
    }

    public void setCacheLastSave(long ls) {
        this.CacheLastSave = ls;
    }

    public String getSessionId() {
        return this.SessionId;
    }

    public void setSessionId(String s) {
        this.SessionId = s;
    }

    protected long getLastSave() {
        PrivilegedCheck pAction = new PrivilegedCheck(this.CacheFilename);
        AccessController.doPrivileged(pAction);
        return pAction.LastChange;
    }

    public boolean isChanged() {
        long newLastSave = this.getLastSave();
        return newLastSave > this.CacheLastSave;
    }

    public void setNewLastSave() {
        this.setCacheLastSave(this.getLastSave());
    }

    public boolean isText() {
        return this.getContentType().indexOf("text/") != -1;
    }

    public boolean getCheck() {
        return this.Check;
    }

    public void setCheck(boolean c) {
        this.Check = c;
    }
}

