/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.eplugin.gui;

import com.livinge.eplugin.editor.EPDocument;
import com.livinge.eplugin.editor.WeEditor;
import com.livinge.eplugin.editor.WeSettings;
import com.livinge.eplugin.gui.EPPropDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class EPEditorDialog
extends JFrame
implements ActionListener {
    static final long serialVersionUID = -1611200117062004001L;
    private static final int MODE_EDITOR = 1;
    private static final int MODE_SETTINGS = 2;
    private JPanel listPane;
    private JButton choseButton;
    private JTextField chosePath;
    private JTextField choseArgs;
    private JButton startButton;
    private JButton closeButton;
    private JButton clearButton;
    private JButton addButton;
    private JButton editButton;
    private JButton delButton;
    private JCheckBox showAllEditors;
    private JCheckBox autoStart;
    private JFileChooser fileSelector;
    private WeSettings weSettings;
    private JList editorList;
    private DefaultListModel listModel = new DefaultListModel();
    private Vector listVector = new Vector();
    protected EPDocument epDoc;
    protected int mode = 1;
    protected WeEditor selectedEditor;

    public EPEditorDialog(EPDocument doc, WeSettings weset, int m) {
        this.epDoc = doc;
        this.weSettings = weset;
        this.mode = m;
        this.buildGUI();
        this.setTitle(this.weSettings.getParam("lan_main_dialog_title"));
    }

    protected void buildGUI() {
        EmptyBorder eb = new EmptyBorder(10, 10, 10, 10);
        CompoundBorder cb = new CompoundBorder(eb, BorderFactory.createEtchedBorder());
        this.setDefaultCloseOperation(2);
        this.chosePath = new JTextField(this.weSettings.getParam("lan_select_text"));
        this.chosePath.setPreferredSize(new Dimension(300, this.chosePath.getFontMetrics(this.chosePath.getFont()).getHeight()));
        this.chosePath.addActionListener(this);
        this.choseArgs = new JTextField(this.weSettings.getParam("lan_args"));
        this.choseArgs.setPreferredSize(new Dimension(100, this.choseArgs.getFontMetrics(this.choseArgs.getFont()).getHeight()));
        this.choseArgs.addActionListener(this);
        this.choseButton = new JButton(this.weSettings.getParam("lan_select_button"));
        this.choseButton.addActionListener(this);
        this.editorList = new JList(this.listModel);
        CellRenderer renderer = new CellRenderer();
        renderer.setPreferredSize(new Dimension(200, 100));
        this.editorList.setSelectionMode(0);
        this.editorList.setSelectionBackground(new Color(223, 233, 245));
        this.editorList.setCellRenderer(renderer);
        this.editorList.setAlignmentX(0.0f);
        this.editorList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && EPEditorDialog.this.editorList.getSelectedIndex() > -1) {
                    EPEditorDialog.this.selectedEditor = (WeEditor)EPEditorDialog.this.listVector.elementAt(EPEditorDialog.this.editorList.getSelectedIndex());
                    EPEditorDialog.this.chosePath.setText(EPEditorDialog.this.selectedEditor.Path);
                    EPEditorDialog.this.choseArgs.setText(EPEditorDialog.this.selectedEditor.Args);
                    EPEditorDialog.this.editButton.setEnabled(true);
                    EPEditorDialog.this.delButton.setEnabled(true);
                }
                if (e.getClickCount() == 2 && EPEditorDialog.this.mode == 1 && EPEditorDialog.this.editorList.getSelectedIndex() > -1) {
                    EPEditorDialog.this.selectedEditor = (WeEditor)EPEditorDialog.this.listVector.elementAt(EPEditorDialog.this.editorList.getSelectedIndex());
                    EPEditorDialog.this.chosePath.setText(EPEditorDialog.this.selectedEditor.Path);
                    EPEditorDialog.this.choseArgs.setText(EPEditorDialog.this.selectedEditor.Args);
                    EPEditorDialog.this.lunchEditor();
                }
            }
        });
        this.refreshListModel(this.epDoc.getContentType());
        this.closeButton = new JButton(this.weSettings.getParam("lan_close_button"));
        this.closeButton.addActionListener(this);
        this.clearButton = new JButton(this.weSettings.getParam("lan_clear_button"));
        this.clearButton.addActionListener(this);
        this.showAllEditors = new JCheckBox(this.weSettings.getParam("lan_showall_label"));
        this.showAllEditors.addActionListener(this);
        this.addButton = new JButton(this.weSettings.getParam("lan_add_button"));
        this.addButton.addActionListener(this);
        this.addButton.setEnabled(true);
        this.editButton = new JButton(this.weSettings.getParam("lan_edit_button"));
        this.editButton.addActionListener(this);
        this.editButton.setEnabled(false);
        this.delButton = new JButton(this.weSettings.getParam("lan_del_button"));
        this.delButton.addActionListener(this);
        this.delButton.setEnabled(false);
        JScrollPane listScroller = new JScrollPane(this.editorList);
        listScroller.setPreferredSize(new Dimension(250, 370));
        listScroller.setMinimumSize(new Dimension(250, 370));
        listScroller.setAlignmentX(0.0f);
        this.listPane = new JPanel();
        this.listPane.setLayout(new BorderLayout());
        this.listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        this.listPane.add((Component)listScroller, "Center");
        this.listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel toolButtonsPane = new JPanel();
        toolButtonsPane.setLayout(new BorderLayout());
        toolButtonsPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JPanel toolsPane = new JPanel();
        toolsPane.setLayout(new BoxLayout(toolsPane, 0));
        toolsPane.add(this.addButton);
        toolsPane.add(Box.createRigidArea(new Dimension(5, 0)));
        toolsPane.add(this.editButton);
        toolsPane.add(Box.createRigidArea(new Dimension(5, 0)));
        toolsPane.add(this.delButton);
        toolsPane.add(Box.createRigidArea(new Dimension(5, 0)));
        toolsPane.add(this.clearButton);
        toolsPane.add(Box.createRigidArea(new Dimension(10, 0)));
        toolButtonsPane.add((Component)toolsPane, "West");
        if (this.mode == 1) {
            toolButtonsPane.add((Component)this.showAllEditors, "East");
        } else {
            toolButtonsPane.add(Box.createRigidArea(new Dimension(150, 0)), "East");
        }
        this.listPane.add((Component)toolButtonsPane, "South");
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new BorderLayout());
        centerPane.setBorder(cb);
        centerPane.add((Component)this.listPane, "North");
        if (this.mode == 1) {
            JPanel selectPane = new JPanel();
            selectPane.setLayout(new BoxLayout(selectPane, 0));
            selectPane.setAlignmentX(0.0f);
            selectPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            JLabel label2 = new JLabel();
            label2.setLabelFor(selectPane);
            selectPane.add(Box.createHorizontalGlue());
            selectPane.add(this.chosePath);
            selectPane.add(this.choseArgs);
            selectPane.add(Box.createRigidArea(new Dimension(10, 0)));
            selectPane.add(this.choseButton);
            centerPane.add((Component)selectPane, "South");
        }
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 10));
        if (this.mode == 1) {
            this.startButton = new JButton(this.weSettings.getParam("lan_start_button"));
            this.startButton.addActionListener(this);
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(this.startButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        buttonPane.add(this.closeButton);
        this.autoStart = new JCheckBox(this.weSettings.getParam("lan_autostart_label"));
        this.autoStart.addActionListener(this);
        this.autoStart.setSelected(!this.weSettings.getSetting("askForEditor").equals("true"));
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new BorderLayout());
        bottomPane.setBorder(new EmptyBorder(0, 10, 10, 10));
        bottomPane.add((Component)this.autoStart, "West");
        bottomPane.add((Component)buttonPane, "East");
        bottomPane.add((Component)new JLabel("Build: " + this.weSettings.getVersion()), "East");
        this.getContentPane().add((Component)centerPane, "Center");
        this.getContentPane().add((Component)bottomPane, "South");
        int windowHeight = 640;
        int windowWidth = 640;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = windowWidth + 10;
        int h = windowHeight + 10;
        this.setLocation(screenSize.width / 3 - w / 2, screenSize.height / 2 - h / 2);
        this.setSize(w, h);
        this.setResizable(false);
    }

    protected void loadEditorList(String ct) {
        this.weSettings.loadEditorList(this.epDoc.getCacheFilename(), this.epDoc.getContentType());
        this.listVector = this.weSettings.getEditorList(ct);
    }

    public void refreshListModel(String ct) {
        this.loadEditorList(ct);
        int size = this.listVector.size();
        this.listModel.removeAllElements();
        for (int i = 0; i < size; ++i) {
            this.listModel.addElement(new Integer(i));
        }
    }

    public void reloadEditorList() {
        if (this.showAllEditors.isSelected()) {
            this.refreshListModel("");
        } else {
            this.refreshListModel(this.epDoc.getContentType());
        }
        this.editorList.repaint();
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = EPEditorDialog.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private void lunchEditor() {
        String editor = this.chosePath.getText();
        String args = this.choseArgs.getText();
        if (this.selectedEditor != null) {
            this.selectedEditor.Path = this.chosePath.getText();
        } else {
            this.selectedEditor = new WeEditor();
            this.selectedEditor.init(editor, editor, args, this.epDoc.getContentType(), "", "");
        }
        int exitVal = this.selectedEditor.start(this.epDoc);
        if (exitVal == 0) {
            if (!this.weSettings.editorExists(editor)) {
                this.weSettings.addToDefaultEditors(this.selectedEditor);
                this.weSettings.saveDefaultEditorList();
            }
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, this.weSettings.getParam("lan_alert_noeditor_text"), this.weSettings.getParam("lan_alert_noeditor_title"), 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.choseButton) {
            this.fileSelector = new JFileChooser();
            int returnVal = this.fileSelector.showOpenDialog(this.choseButton.getParent());
            if (returnVal == 0) {
                String selected = this.fileSelector.getSelectedFile().getPath();
                this.chosePath.setText(selected);
                this.choseArgs.setText("");
            }
        }
        if (e.getSource() == this.addButton) {
            EPPropDialog propDialog = new EPPropDialog(this.weSettings, new WeEditor(), this);
            propDialog.pack();
            propDialog.setVisible(true);
        }
        if (e.getSource() == this.startButton) {
            this.lunchEditor();
        }
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
        }
        if (e.getSource() == this.clearButton && JOptionPane.showConfirmDialog(this, this.weSettings.getParam("lan_clear_question"), this.weSettings.getParam("lan_question"), 0) == 0) {
            ((DefaultListModel)this.editorList.getModel()).clear();
            this.weSettings.clearList();
        }
        if (e.getSource() == this.editButton) {
            EPPropDialog propDialog = new EPPropDialog(this.weSettings, (WeEditor)this.listVector.get(this.editorList.getSelectedIndex()), this);
            propDialog.pack();
            propDialog.setVisible(true);
        }
        if (e.getSource() == this.delButton && JOptionPane.showConfirmDialog(this, this.weSettings.getParam("lan_del_question"), this.weSettings.getParam("lan_question"), 0) == 0) {
            this.weSettings.removeFromDefaultEditorList((WeEditor)this.listVector.elementAt(this.editorList.getSelectedIndex()));
            this.reloadEditorList();
        }
        if (e.getSource() == this.showAllEditors) {
            this.reloadEditorList();
        }
        if (e.getSource() == this.autoStart) {
            if (this.autoStart.isSelected()) {
                this.weSettings.setSetting("askForEditor", "false");
            } else {
                this.weSettings.setSetting("askForEditor", "true");
            }
            this.weSettings.saveSettings();
        }
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = (Integer)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (EPEditorDialog.this.listVector.size() > selectedIndex) {
                WeEditor editor = (WeEditor)EPEditorDialog.this.listVector.elementAt(selectedIndex);
                String text = "<html>\t\t\t<table>\t\t\t\t<tr>\t\t\t\t\t<td>\t\t\t\t\t\t&nbsp;&nbsp;</td>\t\t\t\t\t<td></td>\t\t\t\t\t<td>\t\t\t\t\t\t<font color='black' size='5'><b>" + editor.Name + "</b></font><br>" + "\t\t\t\t\t\t<font color='gray' size='3'><i>" + editor.Path + "</i></font><br>" + (editor.ContentType != null ? (editor.ContentType.trim().length() > 0 ? "\t\t\t\t\t\t<font color='black'>" + EPEditorDialog.this.weSettings.getParam("lan_contenttypes") + ": " + editor.ContentType + "</font><br>" : "") : "") + (editor.DefaultFor != null ? (editor.DefaultFor.trim().length() > 0 ? "\t\t\t\t\t\t<font  size='3' color='back'><i>" + EPEditorDialog.this.weSettings.getParam("lan_default_for") + ": " + editor.DefaultFor + "</i></font><br>" : "") : "") + (editor.Encoding != null ? (editor.Encoding.trim().length() > 0 ? "\t\t\t\t\t\t<font  size='2' color='back'>" + EPEditorDialog.this.weSettings.getParam("lan_encoding") + ": " + editor.Encoding + "</font>" : "") : "") + "\t\t\t\t\t</td>" + "\t\t\t\t</tr>" + "\t\t\t</table>" + "\t\t</html>";
                this.setText(text);
                this.setFont(list.getFont());
            }
            return this;
        }
    }
}

