<?php
	require "init.inc.php";
	$output = array();
	$output['error'] = strlen($error) ? 1:0;
	$output['errorMsg'] = $error;
	$output['customers'] = null;
	if (!strlen($error)) {
		$table_customers = TABLE_CUSTOMERS;
		$table_customers_addresses = TABLE_CUSTOMERS_ADDRESSES;
		$table_orders = TABLE_ORDERS;
		$table_orders_stats = TABLE_ORDERS_STATS;
		$sql_customers = "	SELECT 	$table_customers_addresses.customers_firstname as 'firstname',
									$table_customers_addresses.customers_lastname as 'lastname',
									$table_customers_addresses.customers_gender as 'gender',
									$table_customers_addresses.customers_dob as 'birthday',
									$table_customers_addresses.customers_city as 'city',
									$table_customers_addresses.customers_postcode as 'postcode',
									$table_customers.customers_email_address as 'email',
									$table_customers_addresses.customers_phone as 'mobile',
									count($table_orders.orders_id) as 'total_orders',
									avg($table_orders_stats.orders_stats_price) as 'avg_sales',
									sum($table_orders_stats.orders_stats_price) as 'total_sales'
							FROM $table_customers
							LEFT JOIN $table_customers_addresses
								ON $table_customers_addresses.customers_id = $table_customers.customers_id
							LEFT JOIN $table_orders
								ON $table_orders.customers_id = $table_customers.customers_id
							LEFT JOIN $table_orders_stats
								ON $table_orders_stats.orders_id = $table_orders.orders_id";
		if (isset($_POST['timeframe'])) {
			if ($_POST['timeframe'] > 0) {
				$timeframe = $_POST['timeframe'];
				$sql_customers .= " WHERE GREATEST($table_customers.date_added, $table_customers.last_modified, $table_customers_addresses.date_added, $table_customers_addresses.last_modified ) >
									DATE_SUB( NOW(), INTERVAL $timeframe HOUR ) OR ($table_customers.date_added = '0000-00-00 00:00:00' AND $table_customers.last_modified = '0000-00-00 00:00:00')";
			}
		}
         if (XT_NEWSLETTER2GO_CHECKBOX=='true') {
             if (!isset($timeframe)) {
                 $sql_customers .= " WHERE ";
             } else {
                 $sql_customers .= " AND ";
             }
             $sql_customers .= " $table_customers.nl2go_newsletter_status='1' ";
         }

		$sql_customers .= "	GROUP BY	$table_customers_addresses.customers_firstname,
										$table_customers_addresses.customers_lastname,
										$table_customers_addresses.customers_gender,
										$table_customers.customers_email_address,
										$table_customers_addresses.customers_phone";

		$res = $db->getAll($sql_customers);
		foreach ($res as $field=>$row) {
			$res[$field]['firstname'] = is_null($res[$field]['firstname']) ? "" : $res[$field]['firstname'];
			$res[$field]['lastname'] = is_null($res[$field]['lastname']) ? "" : $res[$field]['lastname'];
			$res[$field]['gender'] = is_null($res[$field]['gender']) ? "" : $res[$field]['gender'];
			$res[$field]['birthday'] = is_null($res[$field]['birthday']) ? "" : $res[$field]['birthday'];
			$res[$field]['city'] = is_null($res[$field]['city']) ? "" : $res[$field]['city'];
			$res[$field]['postcode'] = is_null($res[$field]['postcode']) ? "" : $res[$field]['postcode'];
			$res[$field]['email'] = is_null($res[$field]['email']) ? "" : $res[$field]['email'];
			$res[$field]['mobile'] = is_null($res[$field]['mobile']) ? "" : $res[$field]['mobile'];
			$res[$field]['total_orders'] = is_null($row['total_orders']) ? 0 : intval($row['total_orders']);
			$res[$field]['avg_sales'] = is_null($row['avg_sales']) ? "" : intval($row['avg_sales']);
			$res[$field]['total_sales'] = is_null($row['total_sales']) ? "" : intval($row['total_sales']);
		}
		$output['customers'] = $res;
	}
	header('Content-type: application/json');
	echo json_encode($output);