/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.spellchecker.engine;

import com.swabunga.spell.engine.SpellDictionaryDisk;
import com.swabunga.spell.engine.Word;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SpellDictionaryEncDisk
extends SpellDictionaryDisk {
    protected List possible;
    protected String defEncoding;

    public SpellDictionaryEncDisk(File base, File phonetic, boolean block, String enc) throws FileNotFoundException, IOException {
        super(base, phonetic, block, enc);
        this.defEncoding = enc;
        this.loadIndex();
        this.ready = true;
    }

    public void buildDict(boolean block) {
        try {
            if (block) {
                this.buildNewDictionaryDatabase();
            } else {
                Thread t = new Thread(){

                    public void run() {
                        try {
                            SpellDictionaryEncDisk.this.buildNewDictionaryDatabase();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                t.start();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected File buildSortedFile() throws FileNotFoundException, IOException {
        ArrayList<String> w = new ArrayList<String>();
        File[] wordFiles = this.words.listFiles();
        int i = 0;
        while (i < wordFiles.length) {
            String word;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(wordFiles[i]), this.defEncoding));
            while ((word = r.readLine()) != null) {
                if (word.equals("")) continue;
                w.add(word.trim());
            }
            r.close();
            ++i;
        }
        Collections.sort(w);
        File file = File.createTempFile("jazzy", "sorted");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.defEncoding));
        String prev = null;
        int i2 = 0;
        while (i2 < w.size()) {
            String word = (String)w.get(i2);
            if (prev == null || !prev.equals(word)) {
                writer.write(word);
                writer.newLine();
            }
            prev = word;
            ++i2;
        }
        writer.close();
        return file;
    }

    protected void buildCodeDb(File sortedWords) throws FileNotFoundException, IOException {
        String word;
        ArrayList<SpellDictionaryDisk.CodeWord> codeList = new ArrayList<SpellDictionaryDisk.CodeWord>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sortedWords), this.defEncoding));
        while ((word = reader.readLine()) != null) {
            codeList.add(new SpellDictionaryDisk.CodeWord(this, this.getCode(word), word));
        }
        reader.close();
        Collections.sort(codeList);
        ArrayList<Object[]> index = new ArrayList<Object[]>();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.db, "words.db")), this.defEncoding));
        String currentCode = null;
        int currentPosition = 0;
        int currentLength = 0;
        int i = 0;
        while (i < codeList.size()) {
            SpellDictionaryDisk.CodeWord cw = (SpellDictionaryDisk.CodeWord)codeList.get(i);
            String thisCode = cw.getCode();
            thisCode = this.getIndexCode(thisCode, codeList);
            String toWrite = String.valueOf(cw.getCode()) + "," + cw.getWord() + "\n";
            byte[] bytes = toWrite.getBytes();
            if (currentCode == null) {
                currentCode = thisCode;
            }
            if (!currentCode.equals(thisCode)) {
                index.add(new Object[]{currentCode, new int[]{currentPosition, currentLength}});
                currentPosition += currentLength;
                currentLength = bytes.length;
                currentCode = thisCode;
            } else {
                currentLength += bytes.length;
            }
            out.write(new String(bytes));
            ++i;
        }
        out.close();
        if (currentCode != null && currentPosition != 0 && currentLength != 0) {
            index.add(new Object[]{currentCode, new int[]{currentPosition, currentLength}});
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.db, "words.idx")), this.defEncoding));
        int i2 = 0;
        while (i2 < index.size()) {
            Object[] o = (Object[])index.get(i2);
            writer.write(o[0].toString());
            writer.write(",");
            writer.write(String.valueOf(((int[])o[1])[0]));
            writer.write(",");
            writer.write(String.valueOf(((int[])o[1])[1]));
            writer.newLine();
            ++i2;
        }
        writer.close();
    }

    protected void loadIndex() throws IOException {
        String line;
        this.index = new HashMap();
        File idx = new File(this.db, "words.idx");
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(idx), this.defEncoding));
        while ((line = reader.readLine()) != null) {
            String[] fields = SpellDictionaryEncDisk.split(line, ",");
            this.index.put(fields[0], new int[]{Integer.parseInt(fields[1]), Integer.parseInt(fields[2])});
        }
        reader.close();
    }

    public List getWordsList(String code) {
        Vector<String> words = new Vector<String>();
        int[] posLen = this.getStartPosAndLen(code);
        if (posLen != null) {
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.db, "words.db")), this.defEncoding));
                input.skip(posLen[0]);
                char[] bytes = new char[posLen[1]];
                input.read(bytes, 0, posLen[1]);
                input.close();
                String data = new String(bytes);
                String[] lines = SpellDictionaryEncDisk.split(data, "\n");
                int i = 0;
                while (i < lines.length) {
                    String[] s = SpellDictionaryEncDisk.split(lines[i], ",");
                    if (s[0].equals(code)) {
                        words.addElement(s[1]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return words;
    }

    public boolean isCorrect(String word) {
        this.possible = this.getWordsList(this.getCode(word));
        if (this.possible.contains(word)) {
            return true;
        }
        return this.possible.contains(word.toLowerCase());
    }

    public List getSuggestions(String word, int threshold, int[][] matrix) {
        Vector<Word> suggestions = new Vector<Word>();
        Iterator iterator = this.possible.iterator();
        while (iterator.hasNext()) {
            suggestions.add(new Word(iterator.next().toString(), 1));
        }
        return suggestions;
    }
}

