/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.spellchecker.swing;

import com.livinge.spellchecker.engine.BaseUtility;
import com.livinge.spellchecker.engine.CopyUtility;
import com.livinge.spellchecker.engine.SpellDictionaryEncDisk;
import com.livinge.spellchecker.engine.Uploader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class DictEditor
extends JApplet {
    protected String defEncoding = "UTF8";
    protected SpellDictionaryEncDisk newDict;
    protected boolean runThreads = true;
    protected int threadTick = 2000;
    protected boolean working = false;
    protected boolean dictReady = false;
    protected boolean packed = false;
    protected boolean uploadFinished = false;
    final JLabel statusLabel = new JLabel("");
    Hashtable map = new Hashtable();
    final Hashtable params = new Hashtable();
    protected StatusRun satusR = new StatusRun();

    public void paint(Graphics arg0) {
        super.paint(arg0);
    }

    public boolean buildFinished() {
        return this.dictReady;
    }

    public boolean packingFinished() {
        return this.packed;
    }

    public boolean uploadFinished() {
        return this.uploadFinished;
    }

    public boolean isWorking() {
        return this.working;
    }

    public long getDbSize() {
        return new File(this.map.get("localWordsDb") + "words.db").length();
    }

    public void init() {
        String[] paramNames = new String[]{"l_select", "l_select_words", "l_select_phonetic", "l_build", "l_close", "l_dictname", "l_encoding", "l_encoding", "l_name_warning", "l_filename_warning", "l_phonetic_warning", "l_enc_warning", "l_filename_nok", "l_phonetic_nok", "upload_size", "upload_url", "l_building", "l_packing", "l_uploading", "l_finished", "scid"};
        int c = 0;
        while (c < paramNames.length) {
            try {
                this.params.put(paramNames[c], this.getParameter(paramNames[c]));
            }
            catch (Exception e) {
                System.err.print("Missing parameter:" + paramNames[c]);
            }
            ++c;
        }
        final JTextField dictName = new JTextField();
        final JTextField wFilename = new JTextField();
        final JTextField pFilename = new JTextField();
        final JFileChooser fc = new JFileChooser();
        final JButton addWords = new JButton(this.params.get("l_select").toString());
        addWords.setPreferredSize(new Dimension(100, 20));
        final JButton addPhonet = new JButton(this.params.get("l_select").toString());
        addPhonet.setPreferredSize(new Dimension(100, 20));
        final JButton startButton = new JButton(this.params.get("l_build").toString());
        final JButton closeButton = new JButton(this.params.get("l_close").toString());
        Vector<Charset> supportedEnc = new Vector<Charset>(Charset.availableCharsets().values());
        final JComboBox<Charset> encodings = new JComboBox<Charset>(supportedEnc);
        this.statusLabel.setForeground(new Color(0, 109, 180));
        final JLabel dictNameLabel = new JLabel(this.params.get("l_dictname").toString());
        final JLabel encodingLabel = new JLabel(this.params.get("l_encoding").toString());
        String s = "";
        int count = -1;
        String denc = BaseUtility.getDefaultEncoding();
        Iterator<Charset> it = supportedEnc.iterator();
        while (it.hasNext()) {
            if (s.equals(denc)) {
                encodings.setSelectedIndex(count);
                break;
            }
            ++count;
            s = ((Object)it.next()).toString();
        }
        encodings.setPreferredSize(new Dimension(300, dictName.getFontMetrics(encodings.getFont()).getHeight() + 5));
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                if ((e.getSource() == addWords || e.getSource() == addPhonet) && (returnVal = fc.showOpenDialog(DictEditor.this)) == 0) {
                    if (e.getSource() == addWords) {
                        wFilename.setText(fc.getSelectedFile().getPath());
                    } else {
                        pFilename.setText(fc.getSelectedFile().getPath());
                    }
                }
                if (e.getSource() == startButton) {
                    if (dictName.getText().equals("")) {
                        DictEditor.this.msgBox(DictEditor.this.params.get("l_name_warning").toString());
                    } else if (wFilename.getText().equals("")) {
                        DictEditor.this.msgBox(DictEditor.this.params.get("l_filename_warning").toString());
                    } else if (!new File(wFilename.getText()).exists()) {
                        DictEditor.this.msgBox(DictEditor.this.params.get("l_filename_nok").toString());
                    } else if (pFilename.getText().equals("")) {
                        DictEditor.this.msgBox(DictEditor.this.params.get("l_phonetic_warning").toString());
                    } else if (!new File(pFilename.getText()).exists()) {
                        DictEditor.this.msgBox(DictEditor.this.params.get("l_phonetic_nok").toString());
                    } else if (encodings.getSelectedItem().toString().equals("")) {
                        DictEditor.this.msgBox(DictEditor.this.params.get("l_enc_warning").toString());
                    } else {
                        addWords.setEnabled(false);
                        addPhonet.setEnabled(false);
                        startButton.setEnabled(false);
                        closeButton.setEnabled(false);
                        dictName.setEnabled(false);
                        wFilename.setEnabled(false);
                        pFilename.setEnabled(false);
                        encodings.setEnabled(false);
                        dictNameLabel.setEnabled(false);
                        encodingLabel.setEnabled(false);
                        DictEditor.this.statusLabel.setText(DictEditor.this.params.get("l_building").toString());
                        DictEditor.this.getContentPane().repaint();
                        final String dict = dictName.getText();
                        DictEditor.this.working = true;
                        Thread t = new Thread(){

                            public void run() {
                                try {
                                    DictEditor.this.buildDict(dict, wFilename.getText(), pFilename.getText(), encodings.getSelectedItem().toString());
                                    (this).DictEditor.this.dictReady = true;
                                    (this).DictEditor.this.statusLabel.setText((this).DictEditor.this.params.get("l_packing").toString());
                                    DictEditor.this.getContentPane().repaint();
                                    DictEditor.this.pack(dict);
                                    (this).DictEditor.this.packed = true;
                                    (this).DictEditor.this.statusLabel.setText((this).DictEditor.this.params.get("l_uploading").toString());
                                    DictEditor.this.getContentPane().repaint();
                                    DictEditor.this.upload((this).DictEditor.this.params.get("upload_url").toString(), String.valueOf((this).DictEditor.this.map.get("localDictBase").toString()) + dict + ".zip", Long.parseLong((this).DictEditor.this.params.get("upload_size").toString()));
                                    (this).DictEditor.this.uploadFinished = true;
                                    (this).DictEditor.this.working = false;
                                    (this).DictEditor.this.statusLabel.setText((this).DictEditor.this.params.get("l_finished").toString());
                                    DictEditor.this.getContentPane().repaint();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        t.start();
                    }
                }
                if (e.getSource() == closeButton) {
                    DictEditor.this.uploadFinished = true;
                }
            }
        };
        addWords.addActionListener(al);
        addPhonet.addActionListener(al);
        startButton.addActionListener(al);
        closeButton.addActionListener(al);
        wFilename.setPreferredSize(new Dimension(300, wFilename.getFontMetrics(wFilename.getFont()).getHeight()));
        wFilename.setText(this.params.get("l_select_words").toString());
        pFilename.setPreferredSize(new Dimension(300, pFilename.getFontMetrics(pFilename.getFont()).getHeight()));
        pFilename.setText(this.params.get("l_select_phonetic").toString());
        dictName.setPreferredSize(new Dimension(300, dictName.getFontMetrics(dictName.getFont()).getHeight() + 5));
        JPanel selectPaneW = new JPanel();
        selectPaneW.setLayout(new BoxLayout(selectPaneW, 0));
        selectPaneW.setAlignmentX(0.0f);
        selectPaneW.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        selectPaneW.add(Box.createHorizontalGlue());
        selectPaneW.add(wFilename);
        selectPaneW.add(Box.createRigidArea(new Dimension(10, 0)));
        selectPaneW.add(addWords);
        JPanel selectPaneP = new JPanel();
        selectPaneP.setLayout(new BoxLayout(selectPaneP, 0));
        selectPaneP.setAlignmentX(0.0f);
        selectPaneP.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        selectPaneP.add(Box.createHorizontalGlue());
        selectPaneP.add(pFilename);
        selectPaneP.add(Box.createRigidArea(new Dimension(10, 0)));
        selectPaneP.add(addPhonet);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.statusLabel);
        buttonPane.add(Box.createRigidArea(new Dimension(100, 0)));
        buttonPane.add(startButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(closeButton);
        EmptyBorder eb = new EmptyBorder(10, 10, 10, 10);
        CompoundBorder cb = new CompoundBorder(eb, BorderFactory.createEtchedBorder());
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new BorderLayout());
        centerPane.setBorder(cb);
        centerPane.add((Component)selectPaneW, "North");
        centerPane.add((Component)selectPaneP, "South");
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 0));
        headerPane.setAlignmentX(0.0f);
        headerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        headerPane.add(Box.createHorizontalGlue());
        headerPane.add(dictNameLabel);
        headerPane.add(Box.createRigidArea(new Dimension(10, 0)));
        headerPane.add(dictName);
        JPanel encPane = new JPanel();
        encPane.setLayout(new BoxLayout(encPane, 0));
        encPane.setAlignmentX(0.0f);
        encPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        encPane.add(Box.createHorizontalGlue());
        encPane.add(encodingLabel);
        encPane.add(Box.createRigidArea(new Dimension(10, 0)));
        encPane.add(encodings);
        JPanel footerPane = new JPanel();
        footerPane.setLayout(new BorderLayout());
        footerPane.add((Component)encPane, "North");
        footerPane.add((Component)buttonPane, "South");
        this.getContentPane().add((Component)headerPane, "North");
        this.getContentPane().add((Component)centerPane, "Center");
        this.getContentPane().add((Component)footerPane, "South");
    }

    protected void buildDict(String dict, String wordFilename, String phonetFilename, String enc) {
        File words = new File(wordFilename);
        File phonetic = new File(phonetFilename);
        this.map = BaseUtility.createBase(dict);
        BaseUtility.createBaseFiles(this.map);
        CopyUtility.copyTextFile(words, new File(String.valueOf(this.map.get("localWords").toString()) + dict), enc, this.defEncoding, "/");
        CopyUtility.copyTextFile(phonetic, new File(String.valueOf(this.map.get("localDictBase").toString()) + dict + ".phonet"), enc, this.defEncoding, null);
        this.satusR.start();
        try {
            this.newDict = new SpellDictionaryEncDisk(new File(this.map.get("localDictBase").toString()), new File(String.valueOf(this.map.get("localDictBase").toString()) + dict + ".phonet"), true, this.defEncoding);
            this.newDict.buildDict(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void pack(String dict) {
        File zipFile = new File(String.valueOf(this.map.get("localDictBase").toString()) + dict + ".zip");
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ArrayList<String> files = new ArrayList<String>();
        files.add(String.valueOf(this.map.get("localWordsDb").toString()) + "words.db");
        files.add(String.valueOf(this.map.get("localWordsDb").toString()) + "words.idx");
        files.add(String.valueOf(this.map.get("localDictBase").toString()) + dict + ".phonet");
        CopyUtility.pack(zipFile, files);
    }

    protected void upload(String url, String filename, long chunksize) {
        String sep = System.getProperty("file.separator");
        String localDir = String.valueOf(System.getProperty("user.home")) + sep + ".livinge" + sep + "spellchecker" + sep;
        String chunkName = String.valueOf(localDir) + "upload";
        File chunkFile = new File(chunkName);
        if (chunkFile.exists()) {
            chunkFile.delete();
        }
        long offset = 0L;
        long size = 0L;
        Uploader up = new Uploader();
        File upFile = new File(filename);
        up.addVariable("scid", this.params.get("scid").toString());
        up.addVariable("cmd[0]", "removeDictFile");
        up.addVariable("cmd[1]", upFile.getName());
        up.upload(url);
        up.addVariable("cmd[0]", "uploadPart");
        up.addVariable("cmd[1]", upFile.getName());
        up.addFile("chunk", chunkName);
        try {
            while ((size = CopyUtility.copyPart(filename, chunkName, offset, chunksize)) > 0L) {
                up.addVariable("cmd[2]", Long.toString(CopyUtility.getCRC(chunkFile)));
                up.upload(url);
                offset += size;
            }
            if (chunkFile.exists()) {
                chunkFile.delete();
            }
        }
        catch (Exception er) {
            er.printStackTrace();
        }
    }

    protected void msgBox(String s) {
        JOptionPane.showMessageDialog(this.getContentPane(), s);
    }

    public void destroy() {
        this.runThreads = false;
        try {
            Thread.sleep(2 * this.threadTick);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    class StatusRun
    extends Thread {
        StatusRun() {
        }

        public void run() {
            while (DictEditor.this.runThreads) {
                DictEditor.this.statusLabel.setText(String.valueOf(DictEditor.this.params.get("l_building").toString()) + " " + Long.toString(new File(String.valueOf(DictEditor.this.map.get("localWordsDb").toString()) + "words.db").length() / 1024L) + " KB");
                DictEditor.this.getContentPane().repaint();
                try {
                    Thread.sleep(DictEditor.this.threadTick);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }
}

