/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

abstract class Suggestor
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JList list = new JList();
    public boolean processSelection = true;
    protected Editor applet;
    protected JTextPane pane;
    protected LineNumberPanel lineNumbers;
    protected String suggestedValue;
    protected Vector<SuggestorListener> listeners;

    public Suggestor(Editor anApplet, JTextPane aPane, LineNumberPanel someLineNumbers) {
        this.applet = anApplet;
        this.pane = aPane;
        this.lineNumbers = someLineNumbers;
        this.suggestedValue = "";
        this.setLayout(null);
        this.setSize(200, 200);
        this.list.setFocusable(false);
        this.list.setBackground(new Color(255, 255, 235));
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setFocusable(false);
        scroll.setSize(200, 200);
        this.add(scroll);
        this.setVisible(false);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (Suggestor.this.isVisible()) {
                    switch (e.getKeyCode()) {
                        case 27: {
                            Suggestor.this.hideSuggestor();
                            return;
                        }
                        case 10: {
                            Suggestor.this._suggestorAction();
                            return;
                        }
                    }
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Suggestor.this._suggestorAction();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    protected void _suggestorAction() {
        if (this.processSelection) {
            try {
                int index = this.list.getSelectedIndex();
                String word = (String)this.list.getModel().getElementAt(index);
                this.updatePane(word);
                this.suggestedValue = word;
                this.fireSuggestorEvent();
                this.hideSuggestor();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected abstract void updatePane(String var1);

    public void showSuggestor(DefaultListModel model) {
        int pos = this.pane.getSelectionStart();
        if (model.size() > 0 && !this.isVisible()) {
            this.list.setModel(model);
            try {
                JScrollPane scrollPane = (JScrollPane)this.pane.getParent().getParent().getParent();
                Point p = scrollPane.getViewport().getViewPosition();
                Rectangle rect = this.pane.getUI().modelToView(this.pane, pos);
                int x = (int)rect.getX() + this.lineNumbers.getWidth() + 4 - p.x;
                int y = (int)(rect.getY() + rect.getHeight() + 2.0) - p.y;
                int appletW = this.applet.getContentPane().getWidth();
                int appletH = this.applet.getContentPane().getHeight();
                int suggestorWidth = this.getWidth();
                int suggestorHeight = this.getHeight();
                if (x + suggestorWidth > appletW) {
                    x = Math.max(0, appletW - suggestorWidth);
                }
                if (y + suggestorHeight > appletH) {
                    y = Math.max(0, y - suggestorHeight - 16);
                }
                this.setLocation(x, y);
                this.setVisible(true);
                this.suggestorWillShow();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Suggestor.this.processSelection = true;
                        Suggestor.this.pane.requestFocus();
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void hideSuggestor() {
        if (this.isVisible()) {
            this.setVisible(false);
            this.suggestorWillHide();
            if (this.pane != null) {
                this.pane.setFocusable(true);
                this.pane.requestFocus();
                this.processSelection = false;
            }
        }
    }

    public String getSuggestedValue() {
        return this.suggestedValue;
    }

    public void setSuggestedValue(String aValue) {
        this.suggestedValue = aValue;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void suggestorWillShow() {
        ActionMap am = this.pane.getActionMap();
        am.put("caret-down", new EditorDownAction());
    }

    public void suggestorWillHide() {
        ActionMap am = this.pane.getActionMap();
        am.remove("caret-down");
    }

    public synchronized void addSuggestorListener(SuggestorListener jcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(jcl);
    }

    public synchronized void removeSuggestorListener(SuggestorListener jcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.removeElement(jcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSuggestorEvent() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Vector targets;
            SuggestorEvent event = new SuggestorEvent(this, this.suggestedValue);
            Suggestor suggestor = this;
            synchronized (suggestor) {
                targets = (Vector)this.listeners.clone();
            }
            Enumeration en = targets.elements();
            while (en.hasMoreElements()) {
                SuggestorListener jcl = (SuggestorListener)en.nextElement();
                jcl.entrySelected(event);
            }
        }
    }

    public void selectEntry(String value) {
        System.out.println(value);
        this.list.setSelectedValue(value, true);
    }
}

