/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.eplugin.registry;

import com.livinge.eplugin.registry.Registry;
import com.livinge.eplugin.util.CmdProxy;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class WinRegistry
implements Registry {
    private final String REGQUERY_UTIL = "reg query ";
    private final String REGSTR_TOKEN = "REG_SZ";
    private Vector OpenWithList = new Vector();

    public void addNewApp(String app) {
        if (this.OpenWithList.indexOf(app) == -1) {
            this.OpenWithList.add(app);
        }
    }

    public Vector getAppList(String ext) {
        this.getOpenWithListForExtension(ext);
        this.getOpenWithListForType(ext);
        this.getOpenWithListForUser(ext);
        return this.findApplications(this.OpenWithList);
    }

    public String parseShellCommands(String content) {
        StringTokenizer st = new StringTokenizer(content, "\n");
        while (st.hasMoreTokens()) {
            String ss = st.nextToken();
            if (ss.indexOf("REG_EXPAND_SZ") == -1 && ss.indexOf("REG_SZ") == -1) continue;
            ss = ss.replaceAll("<NO NAME>\tREG_EXPAND_SZ\t", "").trim();
            ss = ss.replaceAll("<NO NAME>\tREG_SZ\t", "").trim();
            return ss;
        }
        return "";
    }

    public String getShellCommands(String app, String key) {
        String query = new String("reg query \"HKCR\\Applications\\" + app + "\\shell\\" + key + "\\command\"");
        String result = CmdProxy.executeCmd(query);
        if (result != null && result.trim().length() > 0 && (result = this.parseShellCommands(result)) != null && result.trim().length() > 0) {
            result = result.replaceAll("%[0-9]+", "");
            result = result.replaceAll("\"", "").trim();
            String cmd = "cmd /C echo ";
            if (System.getProperty("os.name").equals("Windows 95")) {
                cmd = "command /C echo ";
            }
            String result2 = CmdProxy.executeCmd(cmd + result);
            result2 = result2.replaceAll("%(.)*", "");
            if ((result2 = result2.trim()).length() > 0) {
                return result2;
            }
        }
        return "";
    }

    public Vector findApplications(Vector appList) {
        Vector<String> newList = new Vector<String>();
        String s = "";
        String result = "";
        Iterator i = appList.iterator();
        while (i.hasNext()) {
            s = i.next().toString().trim();
            result = this.getShellCommands(s, "edit");
            if (result.length() <= 0) continue;
            newList.add(result);
        }
        return newList;
    }

    public void parseOpenWithList(String content) {
        StringTokenizer st = new StringTokenizer(content, "\n");
        boolean inList = false;
        String next = "";
        while (st.hasMoreTokens()) {
            String ss = st.nextToken();
            StringTokenizer st1 = new StringTokenizer(ss, "\\");
            inList = false;
            while (st1.hasMoreTokens()) {
                next = st1.nextToken();
                if (inList) {
                    this.addNewApp(new String(next));
                }
                if (next.toString().equals("OpenWithList")) {
                    inList = true;
                    continue;
                }
                inList = false;
            }
        }
    }

    public String parsePerceivedType(String content) {
        StringTokenizer st = new StringTokenizer(content, "\n");
        while (st.hasMoreTokens()) {
            String ss = st.nextToken();
            int p = ss.indexOf("PerceivedType");
            if (p == -1) continue;
            return ss.replaceAll("PerceivedType\tREG_SZ", "").trim();
        }
        return null;
    }

    public void getOpenWithListForType(String extension) {
        String query = "reg query \"HKCR\\." + extension + "\"";
        try {
            String type;
            String result = CmdProxy.executeCmd(query);
            if (result != null && (type = this.parsePerceivedType(result)) != null) {
                this.getOpenWithListType(type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void getOpenWithListForExtension(String extension) {
        String query = "reg query \"HKCR\\." + extension + "\\OpenWithList\"";
        try {
            this.parseOpenWithList(CmdProxy.executeCmd(query));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getOpenWithListType(String type) {
        String query = "reg query \"HKCR\\SystemFileAssociations\\" + type + "\\OpenWithList\"";
        try {
            this.parseOpenWithList(CmdProxy.executeCmd(query));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void getOpenWithListForUser(String extension) {
        String query = "reg query \"HKCR\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\." + extension + "\\OpenWithList\"";
        try {
            String result = CmdProxy.executeCmd(query);
            this.parseOpenWithList(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

