<?php

/**
 * webEdition CMS
 *
 * This source is part of webEdition CMS. webEdition CMS is
 * free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * The GNU General Public License can be found at
 * http://www.gnu.org/copyleft/gpl.html.
 * A copy is found in the textfile
 * webEdition/licenses/webEditionCMS/License.txt
 *
 * @category   webEdition
 * @package    webEdition_language
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL
 */


/**
 * Language file: global.inc.php
 * Provides language strings.
 * Language: English
 */

include_once(dirname(__FILE__)."/enc_".basename(__FILE__));

/*****************************************************************************
 * LOGIN-SCREEN
 *****************************************************************************/

$l_button["login"]["value"] = "Kirjaudu";
$l_button["login"]["alt"] = "Kirjaudu webEdition -jrjestelmn";
$l_button["login"]["width"] = 100;

$l_button["back_to_login"]["value"] = "Takaisin";
$l_button["back_to_login"]["alt"] = "Takaisin webEdition-kirjautumisikkunaan";
$l_button["back_to_login"]["width"] = 100;

/*****************************************************************************
 * STARTMENU
 *****************************************************************************/

$l_button["open_document"]["value"] = "Avaa dokumentti";
$l_button["open_document"]["alt"] = "Avaa dokumentti";
$l_button["open_document"]["width"] = 200;

$l_button["new_document"]["value"] = "Uusi dokumentti";
$l_button["new_document"]["alt"] = "Uusi dokumentti";
$l_button["new_document"]["width"] = 200;

$l_button["new_template"]["value"] = "Uusi sivupohja";
$l_button["new_template"]["alt"] = "Uusi sivupohja";
$l_button["new_template"]["width"] = 200;

$l_button["new_directory"]["value"] = "Uusi hakemisto";
$l_button["new_directory"]["alt"] = "Uusi hakemisto";
$l_button["new_directory"]["width"] = 200;

$l_button["unpublished_pages"]["value"] = "Julkaisemattomat sivut";
$l_button["unpublished_pages"]["alt"] = "Julkaisemattomat sivut";
$l_button["unpublished_pages"]["width"] = 200;

$l_button["preferences"]["value"] = "Asetukset";
$l_button["preferences"]["alt"] = "Asetukset";
$l_button["preferences"]["width"] = 200;

/*****************************************************************************
 * DELETE SCREEN
 *****************************************************************************/

$l_button["quit_delete"]["value"] = "Lopeta poistotila";
$l_button["quit_delete"]["alt"] = "Lopeta poistotila";
$l_button["quit_delete"]["width"] = 175;

/*****************************************************************************
 * MOVE SCREEN
 *****************************************************************************/

$l_button["quit_move"]["value"] = "Lopeta siirtotila";
$l_button["quit_move"]["alt"] = "Lopeta siirtotila";
$l_button["quit_move"]["width"] = 175;

/*****************************************************************************
 * STANDARD
 *****************************************************************************/

$l_button["ok"]["value"] = "OK";
$l_button["ok"]["alt"]   = "Ok";
$l_button["ok"]["width"] = 100;

$l_button["cancel"]["value"] = "Peruuta";
$l_button["cancel"]["alt"] = "Peruuta";
$l_button["cancel"]["width"] = 100;

$l_button["yes"]["value"] = "Kyll";
$l_button["yes"]["alt"]   = "Kyll";
$l_button["yes"]["width"] = 100;

$l_button["no"]["value"] = "Ei";
$l_button["no"]["alt"]   = "Ei";
$l_button["no"]["width"] = 100;

$l_button["save"]["value"] = "Tallenna";
$l_button["save"]["alt"] = "Tallenna";
$l_button["save"]["width"] = 100;

$l_button["publish"]["value"] = "Julkaise";
$l_button["publish"]["alt"]   = "Tallenna ja julkaise";
$l_button["publish"]["width"] = 100;

$l_button["saveversion"]["value"] = "Save Version";// TRANSLATE
$l_button["saveversion"]["alt"]   = "Saves the template and creates a new version";// TRANSLATE
$l_button["saveversion"]["width"] = 120;// TRANSLATE

$l_button["delete"]["value"] = "Poista";
$l_button["delete"]["alt"] = "Poista";
$l_button["delete"]["width"] = 100;

$l_button["go"]["value"] = "Suorita nyt";
$l_button["go"]["alt"]   = "";
$l_button["go"]["width"] = 120;

$l_button["openVersionWizard"]["value"] = "Versio-Velho";
$l_button["openVersionWizard"]["alt"]   = "Versio-Velho";
$l_button["openVersionWizard"]["width"] = 120;

$l_button["next"]["value"] = "Seuraava";
$l_button["next"]["alt"]   = "Seuraava";
$l_button["next"]["width"] = 100;

$l_button["back"]["value"] = "Edellinen";
$l_button["back"]["alt"] = "Edellinen";
$l_button["back"]["width"] = 100;

$l_button["open"]["value"] = "Avaa";
$l_button["open"]["alt"] = "Avaa";
$l_button["open"]["width"] = 100;

$l_button["default"]["value"] = "Vakio";
$l_button["default"]["alt"] = "Vakio";
$l_button["default"]["width"] = 100;

$l_button["reset"]["value"] = "Nollaa";
$l_button["reset"]["alt"] = "Nollaa ...";
$l_button["reset"]["width"] = 100;

/*****************************************************************************
 * SAVING, PUBLISHING, ETC.
 *****************************************************************************/

$l_button["unpublish"]["value"] = "Poista julkaisusta";
$l_button["unpublish"]["alt"] = "Poista julkaisusta";
$l_button["unpublish"]["width"] = 160;


/*****************************************************************************
 * MAKE AN NEW DOCUMENT BASED ON TEMPLATE
 *****************************************************************************/

$l_button["make_new_document"]["value"] = "Uusi dokumentti";
$l_button["make_new_document"]["alt"] = "Luo uusi dokumentti";
$l_button["make_new_document"]["width"] = 125;

/*****************************************************************************
 * SUPER-EASY-EDIT-MODE
 *****************************************************************************/

$l_button["preview"]["value"] = "Esikatsele";
$l_button["preview"]["alt"] = "Esikatsele";
$l_button["preview"]["width"] = 120;

$l_button["properties"]["value"] = "Ominaisuudet";
$l_button["properties"]["alt"] = "Ominaisuudet";
$l_button["properties"]["width"] = 100;

$l_button["thumbnails"]["value"] = "Pikkukuvat";
$l_button["thumbnails"]["alt"]   = "Nyt pikkukuvat";
$l_button["thumbnails"]["width"] = 100;

$l_button["shopVariants"]["value"] = "Variantit";
$l_button["shopVariants"]["alt"] = "Muokkaa variantteja";
$l_button["shopVariants"]["width"] = 100;

/*****************************************************************************
 * DOCUMENT TYPES
 *****************************************************************************/

$l_button["new_doctype"]["value"] = "Uusi dokumenttityyppi";
$l_button["new_doctype"]["alt"] = "Luo uusi dokumenttityyppi";
$l_button["new_doctype"]["width"] = 174;

$l_button["delete_doctype"]["value"] = "Poista dokumenttityyppi";
$l_button["delete_doctype"]["alt"] = "Poista dokumenttityyppi";
$l_button["delete_doctype"]["width"] = 174;

/*****************************************************************************
 * XML
 *****************************************************************************/

$l_button["import"]["value"] = "Tuo";
$l_button["import"]["alt"]   = "Tuo valitut tiedostot";
$l_button["import"]["width"] = 100;

$l_button["export"]["value"] = "Vie";
$l_button["export"]["alt"]   = "Vie valitut tiedostot";
$l_button["export"]["width"] = 100;

$l_button["browse"]["value"] = "Selaa";
$l_button["browse"]["alt"] = "Selaa hakemistoa";
$l_button["browse"]["width"] = 100;

/*****************************************************************************
 * FILE-SELECTOR
 *****************************************************************************/

$l_button["root_dir"]["value"] = "/";
$l_button["root_dir"]["alt"]   = "Mene hakemiston juureen";
$l_button["root_dir"]["width"] = 40;


/*****************************************************************************
 * UPLOAD-DIALOG
 *****************************************************************************/

$l_button["upload"]["value"] = "Lataa";
$l_button["upload"]["alt"]   = "Lataa tiedosto";
$l_button["upload"]["width"] = 100;

$l_button["close"]["value"] = "Sulje";
$l_button["close"]["alt"]   = "Sulje webEdition";
$l_button["close"]["width"] = 100;

$l_button["overwrite"]["value"] = "Korvaa";
$l_button["overwrite"]["alt"]   = "Korvaa tiedosto";
$l_button["overwrite"]["width"] = 100;

$l_button["newName"]["value"] = "Uusi nimi";
$l_button["newName"]["alt"]   = "Luo uusi nimi";
$l_button["newName"]["width"] = 100;


/*****************************************************************************
 * PREFERENCES
 *****************************************************************************/

$l_button["add_languages"]["value"] = "Lis kieli";
$l_button["add_languages"]["alt"]   = "Asenna muita kieli webEditioniin";
$l_button["add_languages"]["width"] = 175;

$l_button["apply_current_dimension"]["value"] = "Aseta valitut mitat";
$l_button["apply_current_dimension"]["alt"]   = "Aseta valitut mitat";
$l_button["apply_current_dimension"]["width"] = 175;

$l_button["res_800"]["value"] = "800x600";
$l_button["res_800"]["alt"]   = "Aseta 800x600";
$l_button["res_800"]["width"] = 100;

$l_button["res_1024"]["value"] = "1024x768";
$l_button["res_1024"]["alt"]   = "Aseta 1024x768";
$l_button["res_1024"]["width"] = 100;

$l_button["res_1280"]["value"] = "1280x960";
$l_button["res_1280"]["alt"]   = "Aseta 1280x960";
$l_button["res_1280"]["width"] = 100;

$l_button["res_1600"]["value"] = "1600x1200";
$l_button["res_1600"]["alt"]   = "Aseta 1600x1200";
$l_button["res_1600"]["width"] = 100;

$l_button["apply_current_editor_dimension"]["value"] = "Aseta valitut mitat";
$l_button["apply_current_editor_dimension"]["alt"]   = "Aseta valitut mitat";
$l_button["apply_current_editor_dimension"]["width"] = 175;

$l_button["res_500"]["value"] = "500x300";
$l_button["res_500"]["alt"]   = "Aseta 500x300";
$l_button["res_500"]["width"] = 100;

$l_button["res_700"]["value"] = "700x320";
$l_button["res_700"]["alt"]   = "Aseta 700x320";
$l_button["res_700"]["width"] = 100;

$l_button["res_960"]["value"] = "960x420";
$l_button["res_960"]["alt"]   = "Aseta 960x420";
$l_button["res_960"]["width"] = 100;

$l_button["res_1300"]["value"] = "1300x650";
$l_button["res_1300"]["alt"]   = "Aseta 1300x650";
$l_button["res_1300"]["width"] = 100;


/*****************************************************************************
 * Rebuild
 *****************************************************************************/

$l_button["rebuild"]["value"] = "Uudelleenrakennus";
$l_button["rebuild"]["alt"]   = "Start rebuild...";
$l_button["rebuild"]["width"] = 100;

/*****************************************************************************
 * UPDATE
 *****************************************************************************/

$l_button["demoversion"]["value"] = "Demoversio";
$l_button["demoversion"]["alt"]   = "Demoversio";
$l_button["demoversion"]["width"] = 100;

$l_button["register"]["value"] = "Rekisteri";
$l_button["register"]["alt"]   = "Rekisteri";
$l_button["register"]["width"] = 100;

$l_button["backup"]["value"] = "Varmuuskopioi";
$l_button["backup"]["alt"]   = "Ota varmuuskopio";
$l_button["backup"]["width"] = 100;

$l_button["search"]["value"] = "Hae";
$l_button["search"]["alt"]   = "Hae";
$l_button["search"]["width"] = 100;

/*****************************************************************************
 * Backup
 *****************************************************************************/

$l_button["restore_backup"]["value"] = "Palauta varmuuskopio";
$l_button["restore_backup"]["alt"]   = "Palauta varmuuskopiosta";
$l_button["restore_backup"]["width"] = 180;

$l_button["make_backup"]["value"] = "Luo varmuuskopio";
$l_button["make_backup"]["alt"]   = "Luo varmuuskopio";
$l_button["make_backup"]["width"] = 150;

$l_button["delete_backup"]["value"] = "Poista varmuuskopio";
$l_button["delete_backup"]["alt"]   = "Poista varmuuskopiotiedosto";
$l_button["delete_backup"]["width"] = 150;

/*****************************************************************************
 * Thumbnails
 *****************************************************************************/

$l_button["edit_all_thumbs"]["value"] = "Muokkaa pikkukuvia...";
$l_button["edit_all_thumbs"]["alt"]   = "Muokkaa pikkukuvia";
$l_button["edit_all_thumbs"]["width"] = 150;

/*****************************************************************************
 * Navigation
 *****************************************************************************/
$l_button["new_item"]["value"] = "Uusi linkki";
$l_button["new_item"]["alt"]   = "Uusi linkki";
$l_button["new_item"]["width"] = 200;

$l_button["new_folder"]["value"] = "Uusi kansio";
$l_button["new_folder"]["alt"]   = "Uusi kansio";
$l_button["new_folder"]["width"] = 200;

/*****************************************************************************
 * Logbuch Formmail
 *****************************************************************************/
$l_button["clear_log"]["value"] = "Tyhjenn loki";
$l_button["clear_log"]["alt"] = "Tyhjenn loki";
$l_button["clear_log"]["width"] = 120;

$l_button["logbook"]["value"] = "Loki";
$l_button["logbook"]["alt"]   = "Nyt lokikirja";
$l_button["logbook"]["width"] = 100;

/*****************************************************************************
 * Info
 *****************************************************************************/
$l_button["revert_published"]["value"] = "Palauta julkaistu versio";
$l_button["revert_published"]["alt"] = "Hylk muutokset ja palauta julkaistu versio.";
$l_button["revert_published"]["width"] = 240;

?>