/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
define(["require","exports","./Enum/Severity","jquery","moment","nprogress","./Modal","./Notification","./Utility/MessageUtility"],(function(e,t,i,s,a,r,o,n,l){"use strict";var d;Object.defineProperty(t,"__esModule",{value:!0}),function(e){e.OVERRIDE="replace",e.RENAME="rename",e.SKIP="cancel",e.USE_EXISTING="useExisting"}(d||(d={}));class p{constructor(e){this.askForOverride=[],this.percentagePerFile=1,this.dragFileIntoDocument=e=>(e.stopPropagation(),e.preventDefault(),s(e.currentTarget).addClass("drop-in-progress"),this.showDropzone(),!1),this.dragAborted=e=>(e.stopPropagation(),e.preventDefault(),s(e.currentTarget).removeClass("drop-in-progress"),!1),this.ignoreDrop=e=>(e.stopPropagation(),e.preventDefault(),this.dragAborted(e),!1),this.handleDrop=e=>{this.ignoreDrop(e),this.processFiles(e.originalEvent.dataTransfer.files),this.$dropzone.removeClass("drop-status-ok")},this.fileInDropzone=()=>{this.$dropzone.addClass("drop-status-ok")},this.fileOutOfDropzone=()=>{this.$dropzone.removeClass("drop-status-ok")},this.$body=s("body"),this.$element=s(e);const t=void 0!==this.$element.data("dropzoneTrigger");this.$trigger=s(this.$element.data("dropzoneTrigger")),this.defaultAction=this.$element.data("defaultAction")||d.SKIP,this.$dropzone=s("<div />").addClass("dropzone").hide(),this.irreObjectUid=this.$element.data("fileIrreObject");const i=this.$element.data("dropzoneTarget");this.irreObjectUid&&0!==this.$element.nextAll(i).length?(this.dropZoneInsertBefore=!0,this.$dropzone.insertBefore(i)):(this.dropZoneInsertBefore=!1,this.$dropzone.insertAfter(i)),this.$dropzoneMask=s("<div />").addClass("dropzone-mask").appendTo(this.$dropzone),this.fileInput=document.createElement("input"),this.fileInput.setAttribute("type","file"),this.fileInput.setAttribute("multiple","multiple"),this.fileInput.setAttribute("name","files[]"),this.fileInput.classList.add("upload-file-picker"),this.$body.append(this.fileInput),this.$fileList=s(this.$element.data("progress-container")),this.fileListColumnCount=s("thead tr:first th",this.$fileList).length,this.filesExtensionsAllowed=this.$element.data("file-allowed"),this.fileDenyPattern=this.$element.data("file-deny-pattern")?new RegExp(this.$element.data("file-deny-pattern"),"i"):null,this.maxFileSize=parseInt(this.$element.data("max-file-size"),10),this.target=this.$element.data("target-folder"),this.browserCapabilities={fileReader:"undefined"!=typeof FileReader,DnD:"draggable"in document.createElement("span"),Progress:"upload"in new XMLHttpRequest},this.browserCapabilities.DnD?(this.$body.on("dragover",this.dragFileIntoDocument),this.$body.on("dragend",this.dragAborted),this.$body.on("drop",this.ignoreDrop),this.$dropzone.on("dragenter",this.fileInDropzone),this.$dropzoneMask.on("dragenter",this.fileInDropzone),this.$dropzoneMask.on("dragleave",this.fileOutOfDropzone),this.$dropzoneMask.on("drop",e=>this.handleDrop(e)),this.$dropzone.prepend('<div class="dropzone-hint"><div class="dropzone-hint-media"><div class="dropzone-hint-icon"></div></div><div class="dropzone-hint-body"><h3 class="dropzone-hint-title">'+TYPO3.lang["file_upload.dropzonehint.title"]+'</h3><p class="dropzone-hint-message">'+TYPO3.lang["file_upload.dropzonehint.message"]+"</p></div></div>").click(()=>{this.fileInput.click()}),s("<span />").addClass("dropzone-close").click(this.hideDropzone).appendTo(this.$dropzone),0===this.$fileList.length&&(this.$fileList=s("<table />").attr("id","typo3-filelist").addClass("table table-striped table-hover upload-queue").html("<tbody></tbody>").hide(),this.dropZoneInsertBefore?this.$fileList.insertAfter(this.$dropzone):this.$fileList.insertBefore(this.$dropzone),this.fileListColumnCount=7),this.fileInput.addEventListener("change",()=>{this.processFiles(Array.apply(null,this.fileInput.files))}),this.bindUploadButton(!0===t?this.$trigger:this.$element)):console.warn("Browser has no Drag and drop capabilities; cannot initialize DragUploader")}showDropzone(){this.$dropzone.show()}hideDropzone(e){e.stopPropagation(),e.preventDefault(),this.$dropzone.hide()}processFiles(e){this.queueLength=e.length,this.$fileList.is(":visible")||this.$fileList.show(),r.start(),this.percentagePerFile=1/e.length;const t=[];s.each(e,(e,i)=>{t[parseInt(e,10)]=s.ajax({url:TYPO3.settings.ajaxUrls.file_exists,data:{fileName:i.name,fileTarget:this.target},cache:!1,success:e=>{void 0!==e.uid?(this.askForOverride.push({original:e,uploaded:i,action:this.irreObjectUid?d.USE_EXISTING:d.SKIP}),r.inc(this.percentagePerFile)):new h(this,i,d.SKIP)}})}),s.when.apply(s,t).done(()=>{this.drawOverrideModal(),r.done()}),this.fileInput.value=""}bindUploadButton(e){e.click(e=>{e.preventDefault(),this.fileInput.click(),this.showDropzone()})}decrementQueueLength(){this.queueLength>0&&(this.queueLength--,0===this.queueLength&&s.ajax({url:TYPO3.settings.ajaxUrls.flashmessages_render,cache:!1,success:e=>{s.each(e,(e,t)=>{n.showMessage(t.title,t.message,t.severity)})}}))}drawOverrideModal(){const e=Object.keys(this.askForOverride).length;if(0===e)return;const t=s("<div/>").append(s("<p/>").text(TYPO3.lang["file_upload.existingfiles.description"]),s("<table/>",{class:"table"}).append(s("<thead/>").append(s("<tr />").append(s("<th/>"),s("<th/>").text(TYPO3.lang["file_upload.header.originalFile"]),s("<th/>").text(TYPO3.lang["file_upload.header.uploadedFile"]),s("<th/>").text(TYPO3.lang["file_upload.header.action"])))));for(let i=0;i<e;++i){const e=s("<tr />").append(s("<td />").append(""!==this.askForOverride[i].original.thumbUrl?s("<img />",{src:this.askForOverride[i].original.thumbUrl,height:40}):s(this.askForOverride[i].original.icon)),s("<td />").html(this.askForOverride[i].original.name+" ("+g.fileSizeAsString(this.askForOverride[i].original.size)+")<br>"+a.unix(this.askForOverride[i].original.mtime).format("YYYY-MM-DD HH:mm")),s("<td />").html(this.askForOverride[i].uploaded.name+" ("+g.fileSizeAsString(this.askForOverride[i].uploaded.size)+")<br>"+a(this.askForOverride[i].uploaded.lastModified?this.askForOverride[i].uploaded.lastModified:this.askForOverride[i].uploaded.lastModifiedDate).format("YYYY-MM-DD HH:mm")),s("<td />").append(s("<select />",{class:"form-control t3js-actions","data-override":i}).append(this.irreObjectUid?s("<option/>").val(d.USE_EXISTING).text(TYPO3.lang["file_upload.actions.use_existing"]):"",s("<option />",{selected:this.defaultAction===d.SKIP}).val(d.SKIP).text(TYPO3.lang["file_upload.actions.skip"]),s("<option />",{selected:this.defaultAction===d.RENAME}).val(d.RENAME).text(TYPO3.lang["file_upload.actions.rename"]),s("<option />",{selected:this.defaultAction===d.OVERRIDE}).val(d.OVERRIDE).text(TYPO3.lang["file_upload.actions.override"]))));t.find("table").append("<tbody />").append(e)}const r=o.confirm(TYPO3.lang["file_upload.existingfiles.title"],t,i.SeverityEnum.warning,[{text:s(this).data("button-close-text")||TYPO3.lang["file_upload.button.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:s(this).data("button-ok-text")||TYPO3.lang["file_upload.button.continue"]||"Continue with selected actions",btnClass:"btn-warning",name:"continue"}],["modal-inner-scroll"]);r.find(".modal-dialog").addClass("modal-lg"),r.find(".modal-footer").prepend(s("<span/>").addClass("form-inline").append(s("<label/>").text(TYPO3.lang["file_upload.actions.all.label"]),s("<select/>",{class:"form-control t3js-actions-all"}).append(s("<option/>").val("").text(TYPO3.lang["file_upload.actions.all.empty"]),this.irreObjectUid?s("<option/>").val(d.USE_EXISTING).text(TYPO3.lang["file_upload.actions.all.use_existing"]):"",s("<option/>",{selected:this.defaultAction===d.SKIP}).val(d.SKIP).text(TYPO3.lang["file_upload.actions.all.skip"]),s("<option/>",{selected:this.defaultAction===d.RENAME}).val(d.RENAME).text(TYPO3.lang["file_upload.actions.all.rename"]),s("<option/>",{selected:this.defaultAction===d.OVERRIDE}).val(d.OVERRIDE).text(TYPO3.lang["file_upload.actions.all.override"]))));const n=this;r.on("change",".t3js-actions-all",(function(){const e=s(this).val();""!==e?r.find(".t3js-actions").each((t,i)=>{const a=s(i),r=parseInt(a.data("override"),10);a.val(e).prop("disabled","disabled"),n.askForOverride[r].action=a.val()}):r.find(".t3js-actions").removeProp("disabled")})).on("change",".t3js-actions",(function(){const e=s(this),t=parseInt(e.data("override"),10);n.askForOverride[t].action=e.val()})).on("button.clicked",(function(e){"cancel"===e.target.name?(n.askForOverride=[],o.dismiss()):"continue"===e.target.name&&(s.each(n.askForOverride,(e,t)=>{t.action===d.USE_EXISTING?g.addFileToIrre(n.irreObjectUid,t.original):t.action!==d.SKIP&&new h(n,t.uploaded,t.action)}),n.askForOverride=[],o.dismiss())})).on("hidden.bs.modal",()=>{this.askForOverride=[]})}}class h{constructor(e,t,i){if(this.dragUploader=e,this.file=t,this.override=i,this.$row=s("<tr />").addClass("upload-queue-item uploading"),this.$iconCol=s("<td />").addClass("col-icon").appendTo(this.$row),this.$fileName=s("<td />").text(t.name).appendTo(this.$row),this.$progress=s("<td />").attr("colspan",this.dragUploader.fileListColumnCount-2).appendTo(this.$row),this.$progressContainer=s("<div />").addClass("upload-queue-progress").appendTo(this.$progress),this.$progressBar=s("<div />").addClass("upload-queue-progress-bar").appendTo(this.$progressContainer),this.$progressPercentage=s("<span />").addClass("upload-queue-progress-percentage").appendTo(this.$progressContainer),this.$progressMessage=s("<span />").addClass("upload-queue-progress-message").appendTo(this.$progressContainer),0===s("tbody tr.upload-queue-item",this.dragUploader.$fileList).length?(this.$row.prependTo(s("tbody",this.dragUploader.$fileList)),this.$row.addClass("last")):this.$row.insertBefore(s("tbody tr.upload-queue-item:first",this.dragUploader.$fileList)),this.$iconCol.html('<span class="t3-icon t3-icon-mimetypes t3-icon-other-other">&nbsp;</span>'),this.dragUploader.maxFileSize>0&&this.file.size>this.dragUploader.maxFileSize)this.updateMessage(TYPO3.lang["file_upload.maxFileSizeExceeded"].replace(/\{0\}/g,this.file.name).replace(/\{1\}/g,g.fileSizeAsString(this.dragUploader.maxFileSize))),this.$row.addClass("error");else if(this.dragUploader.fileDenyPattern&&this.file.name.match(this.dragUploader.fileDenyPattern))this.updateMessage(TYPO3.lang["file_upload.fileNotAllowed"].replace(/\{0\}/g,this.file.name)),this.$row.addClass("error");else if(this.checkAllowedExtensions()){this.updateMessage("- "+g.fileSizeAsString(this.file.size));const e=new FormData;e.append("data[upload][1][target]",this.dragUploader.target),e.append("data[upload][1][data]","1"),e.append("overwriteExistingFiles",this.override),e.append("redirect",""),e.append("upload_1",this.file);const t=s.extend(!0,{},s.ajaxSettings,{url:TYPO3.settings.ajaxUrls.file_process,contentType:!1,processData:!1,data:e,cache:!1,type:"POST",success:e=>this.uploadSuccess(e),error:e=>this.uploadError(e)});t.xhr=()=>{const e=s.ajaxSettings.xhr();return e.upload.addEventListener("progress",e=>this.updateProgress(e)),e},this.upload=s.ajax(t)}else this.updateMessage(TYPO3.lang["file_upload.fileExtensionExpected"].replace(/\{0\}/g,this.dragUploader.filesExtensionsAllowed)),this.$row.addClass("error")}updateMessage(e){this.$progressMessage.text(e)}removeProgress(){this.$progress&&this.$progress.remove()}uploadStart(){this.$progressPercentage.text("(0%)"),this.$progressBar.width("1%"),this.dragUploader.$trigger.trigger("uploadStart",[this])}uploadError(e){this.updateMessage(TYPO3.lang["file_upload.uploadFailed"].replace(/\{0\}/g,this.file.name));const t=s(e.responseText);t.is("t3err")?this.$progressPercentage.text(t.text()):this.$progressPercentage.text("("+e.statusText+")"),this.$row.addClass("error"),this.dragUploader.decrementQueueLength(),this.dragUploader.$trigger.trigger("uploadError",[this,e])}updateProgress(e){const t=Math.round(e.loaded/e.total*100)+"%";this.$progressBar.outerWidth(t),this.$progressPercentage.text(t),this.dragUploader.$trigger.trigger("updateProgress",[this,t,e])}uploadSuccess(e){e.upload&&(this.dragUploader.decrementQueueLength(),this.$row.removeClass("uploading"),this.$fileName.text(e.upload[0].name),this.$progressPercentage.text(""),this.$progressMessage.text("100%"),this.$progressBar.outerWidth("100%"),e.upload[0].icon&&this.$iconCol.html('<a href="#" class="t3js-contextmenutrigger" data-uid="'+e.upload[0].id+'" data-table="sys_file">'+e.upload[0].icon+"&nbsp;</span></a>"),this.dragUploader.irreObjectUid?(g.addFileToIrre(this.dragUploader.irreObjectUid,e.upload[0]),setTimeout(()=>{this.$row.remove(),0===s("tr",this.dragUploader.$fileList).length&&(this.dragUploader.$fileList.hide(),this.dragUploader.$trigger.trigger("uploadSuccess",[this,e]))},3e3)):setTimeout(()=>{this.showFileInfo(e.upload[0]),this.dragUploader.$trigger.trigger("uploadSuccess",[this,e])},3e3))}showFileInfo(e){this.removeProgress();for(let e=7;e<this.dragUploader.fileListColumnCount;e++)s("<td />").text("").appendTo(this.$row);s("<td />").text(e.extension.toUpperCase()).appendTo(this.$row),s("<td />").text(e.date).appendTo(this.$row),s("<td />").text(g.fileSizeAsString(e.size)).appendTo(this.$row);let t="";e.permissions.read&&(t+='<strong class="text-danger">'+TYPO3.lang["permissions.read"]+"</strong>"),e.permissions.write&&(t+='<strong class="text-danger">'+TYPO3.lang["permissions.write"]+"</strong>"),s("<td />").html(t).appendTo(this.$row),s("<td />").text("-").appendTo(this.$row)}checkAllowedExtensions(){if(!this.dragUploader.filesExtensionsAllowed)return!0;const e=this.file.name.split(".").pop(),t=this.dragUploader.filesExtensionsAllowed.split(",");return-1!==s.inArray(e.toLowerCase(),t)}}class g{static fileSizeAsString(e){const t=e/1024;let i="";return i=t>1024?(t/1024).toFixed(1)+" MB":t.toFixed(1)+" KB",i}static addFileToIrre(e,t){const i={objectGroup:e,table:"sys_file",uid:t.uid};l.MessageUtility.send(i)}static init(){const e=this.options;s.fn.extend({dragUploader:function(e){return this.each((t,i)=>{const a=s(i);let r=a.data("DragUploaderPlugin");r||a.data("DragUploaderPlugin",r=new p(i)),"string"==typeof e&&r[e]()})}}),s(()=>{s(".t3js-drag-uploader").dragUploader(e)})}}t.initialize=function(){g.init(),void 0!==TYPO3.settings&&void 0!==TYPO3.settings.RequireJS&&void 0!==TYPO3.settings.RequireJS.PostInitializationModules&&void 0!==TYPO3.settings.RequireJS.PostInitializationModules["TYPO3/CMS/Backend/DragUploader"]&&s.each(TYPO3.settings.RequireJS.PostInitializationModules["TYPO3/CMS/Backend/DragUploader"],(t,i)=>{e([i])})},t.initialize()}));