/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
define(["require","exports","./Enum/Severity","jquery","./Icons","./Severity","TYPO3/CMS/Core/SecurityUtility","bootstrap"],(function(t,e,a,n,i,s,l){"use strict";var o,d,r,c;!function(t){t.modal=".t3js-modal",t.content=".t3js-modal-content",t.title=".t3js-modal-title",t.close=".t3js-modal-close",t.body=".t3js-modal-body",t.footer=".t3js-modal-footer",t.iframe=".t3js-modal-iframe",t.iconPlaceholder=".t3js-modal-icon-placeholder"}(o||(o={})),function(t){t.small="small",t.default="default",t.medium="medium",t.large="large",t.full="full"}(d||(d={})),function(t){t.default="default",t.light="light",t.dark="dark"}(r||(r={})),function(t){t.default="default",t.ajax="ajax",t.iframe="iframe"}(c||(c={}));class u{constructor(t){this.sizes=d,this.styles=r,this.types=c,this.currentModal=null,this.instances=[],this.$template=n('<div class="t3js-modal modal fade"><div class="modal-dialog"><div class="t3js-modal-content modal-content"><div class="modal-header"><button class="t3js-modal-close close"><span aria-hidden="true"><span class="t3js-modal-icon-placeholder" data-icon="actions-close"></span></span><span class="sr-only"></span></button><h4 class="t3js-modal-title modal-title"></h4></div><div class="t3js-modal-body modal-body"></div><div class="t3js-modal-footer modal-footer"></div></div></div></div>'),this.defaultConfiguration={type:c.default,title:"Information",content:"No content provided, please check your <code>Modal</code> configuration.",severity:a.SeverityEnum.notice,buttons:[],style:r.default,size:d.default,additionalCssClasses:[],callback:n.noop(),ajaxCallback:n.noop(),ajaxTarget:null},this.securityUtility=t,n(document).on("modal-dismiss",this.dismiss),this.initializeMarkupTrigger(document)}dismiss(){this.currentModal&&this.currentModal.modal("hide")}confirm(t,e,i=a.SeverityEnum.warning,l=[],o){return 0===l.length&&l.push({text:n(this).data("button-close-text")||TYPO3.lang["button.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:n(this).data("button-ok-text")||TYPO3.lang["button.ok"]||"OK",btnClass:"btn-"+s.getCssClass(i),name:"ok"}),this.advanced({title:t,content:e,severity:i,buttons:l,additionalCssClasses:o,callback:t=>{t.on("button.clicked",t=>{"cancel"===t.target.getAttribute("name")?n(t.currentTarget).trigger("confirm.button.cancel"):"ok"===t.target.getAttribute("name")&&n(t.currentTarget).trigger("confirm.button.ok")})}})}loadUrl(t,e=a.SeverityEnum.info,n,i,s,l){return this.advanced({type:c.ajax,title:t,severity:e,buttons:n,ajaxCallback:s,ajaxTarget:l,content:i})}show(t,e,n=a.SeverityEnum.info,i,s){return this.advanced({type:c.default,title:t,content:e,severity:n,buttons:i,additionalCssClasses:s})}advanced(t){return t.type="string"==typeof t.type&&t.type in c?t.type:this.defaultConfiguration.type,t.title="string"==typeof t.title?t.title:this.defaultConfiguration.title,t.content="string"==typeof t.content||"object"==typeof t.content?t.content:this.defaultConfiguration.content,t.severity=void 0!==t.severity?t.severity:this.defaultConfiguration.severity,t.buttons=t.buttons||this.defaultConfiguration.buttons,t.size="string"==typeof t.size&&t.size in d?t.size:this.defaultConfiguration.size,t.style="string"==typeof t.style&&t.style in r?t.style:this.defaultConfiguration.style,t.additionalCssClasses=t.additionalCssClasses||this.defaultConfiguration.additionalCssClasses,t.callback="function"==typeof t.callback?t.callback:this.defaultConfiguration.callback,t.ajaxCallback="function"==typeof t.ajaxCallback?t.ajaxCallback:this.defaultConfiguration.ajaxCallback,t.ajaxTarget="string"==typeof t.ajaxTarget?t.ajaxTarget:this.defaultConfiguration.ajaxTarget,this.generate(t)}setButtons(t){const e=this.currentModal.find(o.footer);if(t.length>0){e.empty();for(let a=0;a<t.length;a++){const i=t[a],s=n("<button />",{class:"btn"});s.html("<span>"+this.securityUtility.encodeHtml(i.text,!1)+"</span>"),i.active&&s.addClass("t3js-active"),""!==i.btnClass&&s.addClass(i.btnClass),""!==i.name&&s.attr("name",i.name),i.action?s.on("click",()=>{e.find("button").not(s).addClass("disabled"),i.action.execute(s.get(0)).then(()=>{this.currentModal.modal("hide")})}):i.trigger&&s.on("click",i.trigger),i.dataAttributes&&Object.keys(i.dataAttributes).length>0&&Object.keys(i.dataAttributes).map(t=>{s.attr("data-"+t,i.dataAttributes[t])}),i.icon&&s.prepend('<span class="t3js-modal-icon-placeholder" data-icon="'+i.icon+'"></span>'),e.append(s)}e.show(),e.find("button").on("click",t=>{n(t.currentTarget).trigger("button.clicked")})}else e.hide();return this.currentModal}initializeMarkupTrigger(t){n(t).on("click",".t3js-modal-trigger",t=>{t.preventDefault();const e=n(t.currentTarget),i=e.data("content")||"Are you sure?",l=void 0!==a.SeverityEnum[e.data("severity")]?a.SeverityEnum[e.data("severity")]:a.SeverityEnum.info;let o=e.data("url")||null;if(null!==o){const t=o.includes("?")?"&":"?";o=o+t+n.param({data:e.data()})}this.advanced({type:null!==o?c.ajax:c.default,title:e.data("title")||"Alert",content:null!==o?o:i,severity:l,buttons:[{text:e.data("button-close-text")||TYPO3.lang["button.close"]||"Close",active:!0,btnClass:"btn-default",trigger:()=>{this.currentModal.trigger("modal-dismiss")}},{text:e.data("button-ok-text")||TYPO3.lang["button.ok"]||"OK",btnClass:"btn-"+s.getCssClass(l),trigger:()=>{this.currentModal.trigger("modal-dismiss"),t.target.ownerDocument.location.href=e.data("href")||e.attr("href")}}]})})}generate(t){const e=this.$template.clone();if(t.additionalCssClasses.length>0)for(let a of t.additionalCssClasses)e.addClass(a);if(e.addClass("modal-type-"+t.type),e.addClass("modal-severity-"+s.getCssClass(t.severity)),e.addClass("modal-style-"+t.style),e.addClass("modal-size-"+t.size),e.attr("tabindex","-1"),e.find(o.title).text(t.title),e.find(o.close).on("click",()=>{e.modal("hide")}),"ajax"===t.type){const a=t.ajaxTarget?t.ajaxTarget:o.body,s=e.find(a);i.getIcon("spinner-circle",i.sizes.default,null,null,i.markupIdentifiers.inline).then(e=>{s.html('<div class="modal-loading">'+e+"</div>"),n.get(t.content,e=>{this.currentModal.find(a).empty().append(e),t.ajaxCallback&&t.ajaxCallback(),this.currentModal.trigger("modal-loaded")},"html")})}else"iframe"===t.type?(e.find(o.body).append(n("<iframe />",{src:t.content,name:"modal_frame",class:"modal-iframe t3js-modal-iframe"})),e.find(o.iframe).on("load",()=>{e.find(o.title).text(e.find(o.iframe).get(0).contentDocument.title)})):("string"==typeof t.content&&(t.content=n("<p />").html(this.securityUtility.encodeHtml(t.content))),e.find(o.body).append(t.content));return e.on("shown.bs.modal",t=>{const e=n(t.currentTarget);e.find(o.footer).find(".t3js-active").first().focus(),e.find(o.iconPlaceholder).each((t,e)=>{i.getIcon(n(e).data("icon"),i.sizes.small,null,null,i.markupIdentifiers.inline).then(t=>{this.currentModal.find(o.iconPlaceholder+"[data-icon="+n(t).data("identifier")+"]").replaceWith(t)})})}),e.on("hidden.bs.modal",t=>{if(this.instances.length>0){const t=this.instances.length-1;this.instances.splice(t,1),this.currentModal=this.instances[t-1]}e.trigger("modal-destroyed"),n(t.currentTarget).remove(),this.instances.length>0&&n("body").addClass("modal-open")}),e.on("show.bs.modal",e=>{this.currentModal=n(e.currentTarget),this.setButtons(t.buttons),this.instances.push(this.currentModal)}),e.on("modal-dismiss",t=>{n(t.currentTarget).modal("hide")}),t.callback&&t.callback(e),e.modal()}}let f=null;try{parent&&parent.window.TYPO3&&parent.window.TYPO3.Modal?(parent.window.TYPO3.Modal.initializeMarkupTrigger(document),f=parent.window.TYPO3.Modal):top&&top.TYPO3.Modal&&(top.TYPO3.Modal.initializeMarkupTrigger(document),f=top.TYPO3.Modal)}catch(t){}return f||(f=new u(new l),TYPO3.Modal=f),f}));