/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class SyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 1L;
    private DefaultStyledDocument doc;
    private Element rootElement;
    private int commentPos = -1;
    private int processingInstructionPos = -1;
    private int weTagPos = -1;
    private int defaultTagPos = -1;
    private int scriptTagPos = -1;
    private MutableAttributeSet piAttributeSet;
    private MutableAttributeSet normalAttributeSet;
    private MutableAttributeSet commentAttributeSet;
    private MutableAttributeSet weAttributeSet;
    private MutableAttributeSet defaultAttributeSet;
    private MutableAttributeSet weAttributeAttributeSet;
    private MutableAttributeSet defaultAttributeAttributeSet;
    public static final int TAG_PI = 1;
    public static final int TAG_WE = 2;
    public static final int TAG_COMMENT = 3;
    public static final int TAG_DEFAULT = 4;
    public static final int TAG_SCRIPT = 5;
    private Editor applet;
    private Pattern attribDelimiter;
    private EditorPanel panel;
    private Parameter parameter = Parameter.getInstance();

    public SyntaxDocument(Editor applet, EditorPanel panel) {
        this.panel = panel;
        this.applet = applet;
        this.doc = this;
        this.rootElement = this.doc.getDefaultRootElement();
        this.putProperty("__EndOfLine__", "\n");
        this.piAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.piAttributeSet, new Color(Integer.parseInt(this.parameter.getPiColor(), 16)));
        this.normalAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normalAttributeSet, new Color(Integer.parseInt(this.parameter.getNormalColor(), 16)));
        this.commentAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.commentAttributeSet, new Color(Integer.parseInt(this.parameter.getCommentColor(), 16)));
        this.weAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.weAttributeSet, new Color(Integer.parseInt(this.parameter.getWeTagColor(), 16)));
        this.defaultAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.defaultAttributeSet, new Color(Integer.parseInt(this.parameter.getHTMLTagColor(), 16)));
        this.weAttributeAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.weAttributeAttributeSet, new Color(Integer.parseInt(this.parameter.getWeAttributeColor(), 16)));
        this.defaultAttributeAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.defaultAttributeAttributeSet, new Color(Integer.parseInt(this.parameter.getHTMLAttributeColor(), 16)));
        this.attribDelimiter = Pattern.compile(" [^ >]+");
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        this.panel.repaint();
        String content = this.doc.getText(0, this.doc.getLength());
        if (this.applet.isCodeSet && !this.applet.isHot() && !this.applet.cmpCode.equals(content)) {
            this.applet.setHot(true);
        }
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.processLinesBefore(content, startLine);
        for (int i = startLine; i <= endLine; ++i) {
            this.processLine(content, i);
        }
        this.processLinesAfter(content, endLine);
    }

    private void processLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset() - 1;
        int piStart = this.getLastPiStart(content, offset);
        int piEnd = this.getLastPiEnd(content, offset);
        int commentStart = this.getLastCommentStart(content, offset);
        int commentEnd = this.getLastCommentEnd(content, offset);
        int defaultStart = this.getLastDefaultStart(content, offset);
        int defaultEnd = this.getLastDefaultEnd(content, offset);
        int scriptStart = this.getLastScriptStartTag(content, offset);
        int scriptEnd = this.getLastScriptEndTag(content, offset);
        this.setWeTagPos(-1);
        this.setProcessingInstructionPos(piStart > piEnd ? piStart : -1);
        this.setCommentPos(commentStart > commentEnd ? commentStart : -1);
        this.setScriptTagPos(scriptStart > scriptEnd ? scriptStart : -1);
        this.setDefaultTagPos(defaultStart > defaultEnd ? defaultStart : -1);
    }

    private void processLine(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        while (startOffset <= endOffset) {
            startOffset = this.highlightTokkens(content, startOffset, endOffset);
        }
    }

    private void processLinesAfter(String content, int endLine) throws BadLocationException {
        int numLines = this.rootElement.getElementCount();
        for (int _line = endLine + 1; _line < numLines; ++_line) {
            Element branch = this.rootElement.getElement(_line);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes().copyAttributes();
            this.processLine(content, _line);
            if (_line + 1 >= numLines || !as.equals(leaf.getAttributes())) continue;
            return;
        }
    }

    private int highlightTokkens(String content, int startOffset, int endOffset) {
        int[] startTag = this.getNextStartTag(content, startOffset);
        if (startTag[0] > startOffset && startTag[0] < endOffset) {
            this.highlightTokken(content, startOffset, startTag[0]);
            return startTag[0];
        }
        if (startTag[0] == -1 || startTag[0] >= endOffset) {
            return this.highlightTokken(content, startOffset, endOffset);
        }
        if (startTag[0] == startOffset) {
            switch (startTag[1]) {
                case 1: {
                    this.setProcessingInstructionPos(startTag[0]);
                    return this.highlightTokken(content, startOffset, endOffset);
                }
                case 2: {
                    this.setWeTagPos(startTag[0]);
                    return this.highlightTokken(content, startOffset, endOffset);
                }
                case 3: {
                    this.setCommentPos(startTag[0]);
                    return this.highlightTokken(content, startOffset, endOffset);
                }
                case 5: {
                    this.setScriptTagPos(startTag[0]);
                    return this.highlightTokken(content, startOffset, endOffset);
                }
            }
            this.setDefaultTagPos(startTag[0]);
            return this.highlightTokken(content, startOffset, endOffset);
        }
        return endOffset + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int highlightTokken(String content, int startTokken, int endTokken) {
        if (this.getProcessingInstructionPos() > -1) {
            int _pos = this.getNextPiEnd(content, startTokken);
            if (_pos != -1 && _pos <= endTokken) {
                this.setProcessingInstructionPos(-1);
                this.doc.setCharacterAttributes(startTokken, _pos - startTokken, this.piAttributeSet, false);
                return _pos;
            }
            this.doc.setCharacterAttributes(startTokken, endTokken - startTokken, this.piAttributeSet, false);
            return endTokken + 1;
        }
        if (this.getWeTagPos() > -1) {
            int _pos = this.getNextDefaultEnd(content, startTokken);
            if (_pos != -1 && _pos <= endTokken) {
                this.setWeTagPos(-1);
                this.doc.setCharacterAttributes(startTokken, _pos - startTokken, this.weAttributeSet, false);
                this.highlightAttributes(content, startTokken, _pos, this.weAttributeAttributeSet);
                return _pos;
            }
            this.doc.setCharacterAttributes(startTokken, endTokken - startTokken, this.weAttributeSet, false);
            this.highlightAttributes(content, startTokken, endTokken, this.weAttributeAttributeSet);
            return endTokken + 1;
        }
        if (this.getCommentPos() > -1) {
            int _pos = this.getNextCommentEnd(content, startTokken);
            if (_pos != -1 && _pos <= endTokken) {
                this.setCommentPos(-1);
                this.doc.setCharacterAttributes(startTokken, _pos - startTokken, this.commentAttributeSet, false);
                return _pos;
            }
            this.doc.setCharacterAttributes(startTokken, endTokken - startTokken, this.commentAttributeSet, false);
            return endTokken + 1;
        }
        if (this.getScriptTagPos() > -1) {
            int _pos = this.getLastScriptEndTag(content, startTokken);
            if (_pos != -1 && _pos <= endTokken) {
                this.setScriptTagPos(-1);
                this.doc.setCharacterAttributes(startTokken, _pos - startTokken, this.normalAttributeSet, false);
                return _pos;
            }
            this.doc.setCharacterAttributes(startTokken, endTokken - startTokken, this.normalAttributeSet, false);
            return endTokken + 1;
        }
        if (this.getDefaultTagPos() <= -1) {
            this.doc.setCharacterAttributes(startTokken, endTokken - startTokken, this.normalAttributeSet, false);
            this.setProcessingInstructionPos(-1);
            this.setDefaultTagPos(-1);
            this.setCommentPos(-1);
            this.setWeTagPos(-1);
            return endTokken + 1;
        }
        int[] _nextStartTag = this.getNextStartTag(content, startTokken + 1);
        int _nextEndpos = this.getNextDefaultEnd(content, startTokken);
        if (!(_nextStartTag[0] <= -1 || _nextStartTag[1] != 1 && _nextStartTag[1] != 2 || _nextStartTag[0] >= _nextEndpos && _nextEndpos != -1)) {
            this.doc.setCharacterAttributes(startTokken, _nextStartTag[0] - startTokken, this.defaultAttributeSet, false);
            this.highlightAttributes(content, startTokken, _nextStartTag[0], this.defaultAttributeAttributeSet);
            return _nextStartTag[0];
        }
        if (_nextEndpos != -1 && _nextEndpos <= endTokken) {
            this.setDefaultTagPos(-1);
            this.doc.setCharacterAttributes(startTokken, _nextEndpos - startTokken, this.defaultAttributeSet, false);
            this.highlightAttributes(content, startTokken, _nextEndpos, this.defaultAttributeAttributeSet);
            return _nextEndpos;
        }
        this.doc.setCharacterAttributes(startTokken, endTokken - startTokken, this.defaultAttributeSet, false);
        this.highlightAttributes(content, startTokken, endTokken, this.defaultAttributeAttributeSet);
        this.doc.setCharacterAttributes(startTokken, endTokken - startTokken, this.defaultAttributeSet, false);
        return endTokken + 1;
    }

    private void highlightAttributes(String content, int startTokken, int endTokken, MutableAttributeSet attribSet) {
        String tokken = content.substring(startTokken, endTokken);
        Matcher quote = this.attribDelimiter.matcher(tokken);
        while (quote.find()) {
            int start = quote.start();
            int end = quote.end();
            this.doc.setCharacterAttributes(startTokken + start, end - start, attribSet, false);
        }
    }

    protected String addMatchingBrace(int offset) throws BadLocationException {
        String temp;
        StringBuffer whiteSpace = new StringBuffer();
        int line = this.rootElement.getElementIndex(offset);
        int i = this.rootElement.getElement(line).getStartOffset();
        while ((temp = this.doc.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        return "{\n" + whiteSpace.toString() + "\t\n" + whiteSpace.toString() + "}";
    }

    private int[] getNextStartTag(String content, int startOffset) {
        int[] out = new int[]{-1, 0};
        int pos = content.indexOf("<", startOffset);
        if (pos > -1) {
            out[0] = pos;
            try {
                out[1] = content.substring(pos, pos + 2).equals("<?") ? 1 : (content.substring(pos, pos + 4).equals("<!--") ? 3 : (content.substring(pos, pos + 4).equals("<we:") || content.substring(pos, pos + 5).equals("</we:") ? 2 : 4));
            }
            catch (StringIndexOutOfBoundsException e) {
                out[1] = 4;
            }
        }
        return out;
    }

    private int getLastDefaultEnd(String content, int offset) {
        int i = content.lastIndexOf(">", offset);
        while (i > -1) {
            if (content.substring(Math.max(0, i - 1), i).equals("?>") || content.substring(Math.max(0, i - 3), i).equals("-->")) {
                i = content.lastIndexOf(">", i - 1);
                continue;
            }
            return i + 1;
        }
        return -1;
    }

    private int getLastDefaultStart(String content, int offset) {
        int i = content.lastIndexOf("<", offset);
        while (i > -1) {
            if (content.substring(i, Math.min(i + 2, content.length())).equals("<?") || content.substring(i, Math.min(i + 4, content.length())).equals("<we:") || content.substring(i, Math.min(i + 5, content.length())).equals("</we:") || content.substring(i, Math.min(i + 4, content.length())).equals("<!--")) {
                i = content.lastIndexOf("<", i - 1);
                continue;
            }
            return i;
        }
        return -1;
    }

    private int getLastPiEnd(String content, int offset) {
        int _pos = content.lastIndexOf("?>", offset);
        if (_pos > -1) {
            return _pos + 2;
        }
        return -1;
    }

    private int getLastPiStart(String content, int offset) {
        return content.lastIndexOf("<?", offset);
    }

    private int getLastScriptStartTag(String content, int offset) {
        return content.toLowerCase().lastIndexOf("<script");
    }

    private int getLastScriptEndTag(String content, int offset) {
        int _pos = content.toLowerCase().lastIndexOf("</script>", offset);
        if (_pos > -1) {
            return _pos + 9;
        }
        return -1;
    }

    private int getLastCommentEnd(String content, int offset) {
        int _pos = content.lastIndexOf("-->", offset);
        if (_pos > -1) {
            return _pos + 3;
        }
        return -1;
    }

    private int getLastCommentStart(String content, int offset) {
        return content.lastIndexOf("<!--", offset);
    }

    private int getNextDefaultEnd(String content, int offset) {
        int i = content.indexOf(">", offset);
        while (i > -1) {
            if (content.substring(Math.max(0, i - 1), i).equals("?>") || content.substring(Math.max(0, i - 3), i).equals("-->")) {
                i = content.indexOf(">", i + 1);
                continue;
            }
            return i + 1;
        }
        return -1;
    }

    private int getNextCommentEnd(String content, int offset) {
        int _pos = content.indexOf("-->", offset);
        if (_pos > -1) {
            return _pos + 3;
        }
        return -1;
    }

    private int getNextPiEnd(String content, int offset) {
        int _pos = content.indexOf("?>", offset);
        if (_pos > -1) {
            return _pos + 2;
        }
        return -1;
    }

    public int getProcessingInstructionPos() {
        return this.processingInstructionPos;
    }

    public void setProcessingInstructionPos(int processingInstructionPos) {
        this.processingInstructionPos = processingInstructionPos;
    }

    public int getWeTagPos() {
        return this.weTagPos;
    }

    public void setWeTagPos(int weTagPos) {
        this.weTagPos = weTagPos;
    }

    public int getDefaultTagPos() {
        return this.defaultTagPos;
    }

    public void setDefaultTagPos(int defaultTagPos) {
        this.defaultTagPos = defaultTagPos;
    }

    public int getCommentPos() {
        return this.commentPos;
    }

    public void setCommentPos(int commentPos) {
        this.commentPos = commentPos;
    }

    public void setScriptTagPos(int scriptTagPos) {
        this.scriptTagPos = scriptTagPos;
    }

    public int getScriptTagPos() {
        return this.scriptTagPos;
    }

    public void debugSelf() {
        System.out.println("we: " + this.getWeTagPos() + "; pi: " + this.getProcessingInstructionPos() + "; cm: " + this.getCommentPos() + "; def: " + this.getDefaultTagPos());
    }
}

