/*
 * Decompiled with CFR 0.152.
 */
package com.livinge.spellchecker.engine;

import com.livinge.spellchecker.engine.Base64Coder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CopyUtility {
    public static void copy(InputStream fis, String filename) throws IOException {
        try {
            int len;
            int buffersize = 2048;
            byte[] buffer = new byte[buffersize];
            DataOutputStream output = new DataOutputStream(new FileOutputStream(new File(filename)));
            while ((len = fis.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public static long copyPart(String input, String output, long offset, long size) throws IOException {
        long allBytesRead = 0L;
        try {
            FileInputStream fis = new FileInputStream(new File(input));
            fis.skip(offset);
            int buffersize = 8192;
            int bytesRead = 0;
            if ((long)buffersize > size) {
                buffersize = Integer.parseInt(Long.toString(size));
            }
            byte[] buffer = new byte[buffersize];
            FileOutputStream fos = new FileOutputStream(new File(output));
            while ((bytesRead = fis.read(buffer, 0, buffersize)) != -1) {
                if (allBytesRead + (long)bytesRead >= size) break;
                fos.write(buffer, 0, bytesRead);
                allBytesRead += (long)bytesRead;
            }
            fos.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException();
        }
        return allBytesRead;
    }

    protected String getDefaultEncoding() {
        OutputStreamWriter out = new OutputStreamWriter(new ByteArrayOutputStream());
        return out.getEncoding();
    }

    public static void copy(URL url, String filename) throws IOException {
        try {
            try {
                InputStream is = url.openStream();
                CopyUtility.copy(is, filename);
            }
            catch (IOException ix) {
                ix.printStackTrace();
                throw new IOException();
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new IOException();
        }
    }

    public static Vector extract(ZipInputStream zipFile, String base) throws IOException {
        Vector<String> entries = new Vector<String>();
        try {
            ZipEntry ze = zipFile.getNextEntry();
            while (ze != null) {
                CopyUtility.copy(zipFile, String.valueOf(base) + ze.getName());
                entries.add(ze.getName());
                zipFile.closeEntry();
                ze = zipFile.getNextEntry();
            }
            zipFile.close();
            return entries;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public static void saveToFile(String filename, String text, boolean encoded, String charset) {
        try {
            File f;
            if (encoded) {
                text = Base64Coder.decode(text);
            }
            if (!(f = new File(filename)).exists()) {
                f.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(filename);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)os, charset));
            out.write(text);
            ((Writer)out).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void copyTextFile(File from, File to, String fromEnc, String toEnc, String cropFrom) {
        try {
            String s;
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(from), fromEnc));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new DataOutputStream(new FileOutputStream(to)), toEnc));
            while ((s = input.readLine()) != null) {
                int ind;
                if (cropFrom != null && (ind = s.indexOf(cropFrom)) > 0) {
                    s = s.substring(0, ind);
                }
                s = String.valueOf(s) + "\n";
                out.write(s);
            }
            input.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pack(File zipFile, List files) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
            zos.setMethod(8);
            String f = "";
            Iterator i = files.iterator();
            while (i.hasNext()) {
                int buffersize;
                f = i.next().toString();
                File file = new File(f);
                long crc = CopyUtility.getCRC(new File(f));
                int n = buffersize = 8192;
                byte[] buff = new byte[buffersize];
                ZipEntry entry = new ZipEntry(file.getName());
                entry.setSize(file.length());
                entry.setTime(file.lastModified());
                entry.setCrc(crc);
                zos.putNextEntry(entry);
                FileInputStream fis = new FileInputStream(file);
                long sum = 0L;
                while ((n = fis.read(buff, 0, buffersize)) != -1) {
                    zos.write(buff, 0, n);
                    sum += (long)n;
                }
                fis.close();
                zos.closeEntry();
            }
            zos.flush();
            zos.close();
        }
        catch (Exception fn) {
            fn.printStackTrace();
        }
    }

    public static long getCRC(File file) {
        byte[] buff = new byte[1000];
        CRC32 crc32 = new CRC32();
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            while ((n = fis.read(buff)) > -1) {
                crc32.update(buff, 0, n);
            }
            fis.close();
        }
        catch (Exception fn) {
            fn.printStackTrace();
        }
        return crc32.getValue();
    }
}

