/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpellDictionaryDisk
extends SpellDictionaryASpell {
    protected static final String DIRECTORY_WORDS = "words";
    protected static final String DIRECTORY_DB = "db";
    protected static final String FILE_CONTENTS = "contents";
    protected static final String FILE_DB = "words.db";
    protected static final String FILE_INDEX = "words.idx";
    private static final int INDEX_SIZE_MAX = 200;
    protected File base;
    protected File words;
    protected File db;
    protected Map index;
    protected boolean ready;
    protected List indexCodeCache = null;
    protected String defEncoding;

    public SpellDictionaryDisk(File base, File phonetic, boolean block, String enc) throws FileNotFoundException, IOException {
        super(phonetic, enc);
        this.defEncoding = enc;
        this.ready = false;
        this.base = base;
        this.words = new File(base, DIRECTORY_WORDS);
        this.db = new File(base, DIRECTORY_DB);
        if (!this.base.exists()) {
            throw new FileNotFoundException("Couldn't find required path '" + this.base + "'");
        }
        if (!this.words.exists()) {
            throw new FileNotFoundException("Couldn't find required path '" + this.words + "'");
        }
        if (!this.db.exists()) {
            this.db.mkdirs();
        }
    }

    protected void buildNewDictionaryDatabase() throws FileNotFoundException, IOException {
        File sortedFile = this.buildSortedFile();
        this.buildCodeDb(sortedFile);
        sortedFile.delete();
        this.buildContentsFile();
    }

    public void addWord(String word) {
        throw new UnsupportedOperationException("addWord not yet implemented (sorry)");
    }

    public List getWords(String code) {
        Vector<String> words = new Vector<String>();
        int[] posLen = this.getStartPosAndLen(code);
        if (posLen != null) {
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.db, FILE_DB)), this.defEncoding));
                input.skip(posLen[0]);
                char[] bytes = new char[posLen[1]];
                input.read(bytes, 0, posLen[1]);
                input.close();
                String data = new String(bytes);
                String[] lines = SpellDictionaryDisk.split(data, "\n");
                int i = 0;
                while (i < lines.length) {
                    String[] s = SpellDictionaryDisk.split(lines[i], ",");
                    if (s[0].equals(code)) {
                        words.addElement(s[1]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return words;
    }

    public boolean isReady() {
        return this.ready;
    }

    private boolean newDictionaryFiles() throws FileNotFoundException, IOException {
        ArrayList<FileSize> contents = new ArrayList<FileSize>();
        File c = new File(this.db, FILE_CONTENTS);
        if (c.exists()) {
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(c));
                    while ((line = reader.readLine()) != null) {
                        String[] s = SpellDictionaryDisk.split(line, ",");
                        contents.add(new FileSize(s[0], Integer.parseInt(s[1])));
                    }
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        boolean changed = false;
        File[] wordFiles = this.words.listFiles();
        if (contents.size() != wordFiles.length) {
            changed = true;
        } else {
            int i = 0;
            while (i < wordFiles.length) {
                FileSize fs = new FileSize(wordFiles[i].getName(), wordFiles[i].length());
                if (!contents.contains(fs)) {
                    changed = true;
                    break;
                }
                ++i;
            }
        }
        return changed;
    }

    private File buildSortedFile() throws FileNotFoundException, IOException {
        ArrayList<String> w = new ArrayList<String>();
        File[] wordFiles = this.words.listFiles();
        int i = 0;
        while (i < wordFiles.length) {
            String word;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(wordFiles[i]), this.defEncoding));
            while ((word = r.readLine()) != null) {
                if (word.equals("")) continue;
                w.add(word.trim());
            }
            r.close();
            ++i;
        }
        Collections.sort(w);
        File file = File.createTempFile("jazzy", "sorted");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.defEncoding));
        String prev = null;
        int i2 = 0;
        while (i2 < w.size()) {
            String word = (String)w.get(i2);
            if (prev == null || !prev.equals(word)) {
                writer.write(word);
                writer.newLine();
            }
            prev = word;
            ++i2;
        }
        writer.close();
        return file;
    }

    private void buildCodeDb(File sortedWords) throws FileNotFoundException, IOException {
        String word;
        ArrayList<CodeWord> codeList = new ArrayList<CodeWord>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sortedWords), this.defEncoding));
        while ((word = reader.readLine()) != null) {
            codeList.add(new CodeWord(this.getCode(word), word));
        }
        reader.close();
        Collections.sort(codeList);
        ArrayList<Object[]> index = new ArrayList<Object[]>();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.db, FILE_DB)), this.defEncoding));
        String currentCode = null;
        int currentPosition = 0;
        int currentLength = 0;
        int i = 0;
        while (i < codeList.size()) {
            CodeWord cw = (CodeWord)codeList.get(i);
            String thisCode = cw.getCode();
            thisCode = this.getIndexCode(thisCode, codeList);
            String toWrite = String.valueOf(cw.getCode()) + "," + cw.getWord() + "\n";
            byte[] bytes = toWrite.getBytes();
            if (currentCode == null) {
                currentCode = thisCode;
            }
            if (!currentCode.equals(thisCode)) {
                index.add(new Object[]{currentCode, new int[]{currentPosition, currentLength}});
                currentPosition += currentLength;
                currentLength = bytes.length;
                currentCode = thisCode;
            } else {
                currentLength += bytes.length;
            }
            out.write(new String(bytes));
            ++i;
        }
        out.close();
        if (currentCode != null && currentPosition != 0 && currentLength != 0) {
            index.add(new Object[]{currentCode, new int[]{currentPosition, currentLength}});
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.db, FILE_INDEX)), this.defEncoding));
        int i2 = 0;
        while (i2 < index.size()) {
            Object[] o = (Object[])index.get(i2);
            writer.write(o[0].toString());
            writer.write(",");
            writer.write(String.valueOf(((int[])o[1])[0]));
            writer.write(",");
            writer.write(String.valueOf(((int[])o[1])[1]));
            writer.newLine();
            ++i2;
        }
        writer.close();
    }

    private void buildContentsFile() throws IOException {
        File[] wordFiles = this.words.listFiles();
        if (wordFiles.length > 0) {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.db, FILE_CONTENTS)));
            int i = 0;
            while (i < wordFiles.length) {
                writer.write(wordFiles[i].getName());
                writer.write(",");
                writer.write(String.valueOf(wordFiles[i].length()));
                writer.newLine();
                ++i;
            }
            writer.close();
        } else {
            new File(this.db, FILE_CONTENTS).delete();
        }
    }

    protected void loadIndex() throws IOException {
        String line;
        this.index = new HashMap();
        File idx = new File(this.db, FILE_INDEX);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(idx), this.defEncoding));
        while ((line = reader.readLine()) != null) {
            String[] fields = SpellDictionaryDisk.split(line, ",");
            this.index.put(fields[0], new int[]{Integer.parseInt(fields[1]), Integer.parseInt(fields[2])});
        }
        reader.close();
    }

    protected int[] getStartPosAndLen(String code) {
        while (code.length() > 0) {
            int[] posLen = (int[])this.index.get(code);
            if (posLen == null) {
                code = code.substring(0, code.length() - 1);
                continue;
            }
            return posLen;
        }
        return null;
    }

    protected String getIndexCode(String code, List codes) {
        String newCode;
        if (this.indexCodeCache == null) {
            this.indexCodeCache = new ArrayList();
        }
        if (code.length() <= 1) {
            return code;
        }
        int i = 0;
        while (i < this.indexCodeCache.size()) {
            String c = (String)this.indexCodeCache.get(i);
            if (code.startsWith(c)) {
                return c;
            }
            ++i;
        }
        int foundSize = -1;
        boolean cacheable = false;
        int z = 1;
        while (z < code.length()) {
            String thisCode = code.substring(0, z);
            int count = 0;
            int i2 = 0;
            while (i2 < codes.size()) {
                CodeWord cw;
                if (i2 == 0 && (i2 = Collections.binarySearch(codes, new CodeWord(thisCode, ""))) < 0) {
                    i2 = 0;
                }
                if ((cw = (CodeWord)codes.get(i2)).getCode().startsWith(thisCode) ? ++count > 200 : cw.getCode().compareTo(thisCode) > 0) break;
                ++i2;
            }
            if (count <= 200) {
                cacheable = true;
                foundSize = z;
                break;
            }
            ++z;
        }
        String string = newCode = foundSize == -1 ? code : code.substring(0, foundSize);
        if (cacheable) {
            this.indexCodeCache.add(newCode);
        }
        return newCode;
    }

    protected static String[] split(String input, String delimiter) {
        StringTokenizer st = new StringTokenizer(input, delimiter);
        int count = st.countTokens();
        String[] out = new String[count];
        int i = 0;
        while (i < count) {
            out[i] = st.nextToken();
            ++i;
        }
        return out;
    }

    protected class CodeWord
    implements Comparable {
        private String code;
        private String word;

        public CodeWord(String code, String word) {
            this.code = code;
            this.word = word;
        }

        public String getCode() {
            return this.code;
        }

        public String getWord() {
            return this.word;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CodeWord)) {
                return false;
            }
            CodeWord codeWord = (CodeWord)o;
            return this.word.equals(codeWord.word);
        }

        public int hashCode() {
            return this.word.hashCode();
        }

        public int compareTo(Object o) {
            return this.code.compareTo(((CodeWord)o).getCode());
        }
    }

    private class FileSize {
        private String filename;
        private long size;

        public FileSize(String filename, long size) {
            this.filename = filename;
            this.size = size;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileSize)) {
                return false;
            }
            FileSize fileSize = (FileSize)o;
            if (this.size != fileSize.size) {
                return false;
            }
            return this.filename.equals(fileSize.filename);
        }

        public int hashCode() {
            int result = this.filename.hashCode();
            result = (int)((long)(29 * result) + this.size);
            return result;
        }
    }
}

