<?php
	header('Content-type: application/json');
	require "init.inc.php";
	$output = array();
	$output['error'] = strlen($error) ? 1:0;
	$output['errorMsg'] = $error;
	if (!strlen($error)) {
		if (isset($_POST['item'])) {
			$itemid = isset($_POST['item']) ? $_POST['item'] : null;
			$imgType = isset($_POST['imgtype']) ? $_POST['imgtype'] : "info";
			$i = 0;
			$uriParts = explode('/',$_SERVER['REQUEST_URI']);
			$imgDir = "http://";
			$imgDir .=  $_SERVER['HTTP_HOST'];
			while ($uriParts[$i] != "plugins") 
				$imgDir .= $uriParts[$i++] . '/';
			
			$baseUrl = $imgDir;
			$imgDir .=  _SRV_WEB_IMAGES;
			$imgDir .=  $imgType . '/';

			$table_products = TABLE_PRODUCTS;
			$table_products_description = TABLE_PRODUCTS_DESCRIPTION;
			$table_products_price_special = TABLE_PRODUCTS_PRICE_SPECIAL;
			$table_media = TABLE_MEDIA;
			$table_media_link = TABLE_MEDIA_LINK;
			$table_seo_url = TABLE_SEO_URL;
			$table_tax_rates = TABLE_TAX_RATES;
			$sql_item = "	SELECT 	 $table_products_description.products_name
									,$table_products_description.products_description
									,$table_products_description.products_short_description
									,$table_products.products_price
									,$table_products_price_special.specials_price
									,$table_seo_url.url_text
									,$table_products.products_image
									,$table_media.file
									,$table_tax_rates.tax_rate
							FROM $table_products
							LEFT OUTER JOIN $table_products_description
								ON $table_products.products_id = $table_products_description.products_id
							LEFT OUTER JOIN $table_products_price_special
								ON $table_products_price_special.products_id = $table_products.products_id
							LEFT OUTER JOIN $table_seo_url
								ON $table_seo_url.link_id = $table_products.products_id
							LEFT OUTER JOIN $table_media_link
								ON $table_media_link.link_id = $table_products.products_id
							LEFT OUTER JOIN $table_media
								ON $table_media.id = $table_media_link.m_id
							LEFT OUTER JOIN $table_tax_rates
								ON $table_tax_rates.tax_class_id = $table_products.products_tax_class_id								
							WHERE $table_products.products_id = $itemid
								AND $table_seo_url.link_type = 1";

			$res = $db->getAll($sql_item);

			$images = array();
			if (count($res)) {
				if ($res[0]['products_image'] != null)
					$images[] = $imgDir . $res[0]['products_image'];
				foreach ($res as $row) {
					if ($row['file'] != null)
						$images[] = $imgDir . $row['file'];
				}
			}

			if (count($res)) {
				$output['itemID'] = intval($itemid);
				$output['name'] = is_null($res[0]['products_name']) ? "" : $res[0]['products_name'];
				$output['description'] = is_null($res[0]['products_description']) ? "" : $res[0]['products_description'];
				$output['short_description'] = is_null($res[0]['products_short_description']) ? "" : $res[0]['products_short_description'];
				$output['oldPrice'] = is_null($res[0]['products_price']) ? "" : floatval($res[0]['products_price']);
				$output['newPrice'] = is_null($res[0]['specials_price']) ? $output['oldPrice'] : floatval($res[0]['specials_price']);
				$output['url'] = $baseUrl;
				$output['link'] = is_null($res[0]['url_text']) ? "" : $res[0]['url_text'];
				$output['images'] = count($images) > 0 ? array_unique($images) : "";
				$output['taxRate'] = is_null($res[0]['tax_rate']) ? "" : $res[0]['tax_rate'];
			}
			else {
				$output['error'] = 1;
				$output['errorMsg'] = "Item not found";
			}
		}
		else {
			$output['error'] = 1;
			$output['errorMsg'] = "Item not specified";
		}
	}
	
	echo json_encode($output);