<?php
/**
 * PHP-Ext Library
 * http://php-ext.googlecode.com
 * @author Sergei Walter <sergeiw[at]gmail[dot]com>
 * @copyright 2008 Sergei Walter
 * @license http://www.gnu.org/licenses/lgpl.html
 * @link http://php-ext.googlecode.com
 * 
 * Reference for Ext JS: http://extjs.com
 * 
 */
/**
 * @see PhpExt_Container
 */
include_once 'PhpExt/Container.php';
/**
 * @see PhpExt_Toolbar_Toolbar
 */
include_once 'PhpExt/Toolbar/Toolbar.php';

/**
 * @see PhpExt_ButtonCollection
 */
include_once 'PhpExt/ButtonCollection.php';
/**
 * @see PhpExt_ToolConfigObjectCollection
 */
include_once 'PhpExt/ToolConfigObjectCollection.php';

/**
 * @package PhpExt 
 */
class PhpExt_Panel extends PhpExt_Container 
{
    // AnimCollapse
    /**
     * True to animate the transition when the panel is collapsed, false to skip the animation (defaults to true if the Ext.Fx class is available, otherwise false).
     * @param boolean $value
     * @return PhpExt_Panel
     */
    public function setAnimCollapse($value) {
    	$this->setExtConfigProperty("animCollapse", $value);
    	return $this;
    }	
    /**
     * True to animate the transition when the panel is collapsed, false to skip the animation (defaults to true if the Ext.Fx class is available, otherwise false).
     * @return boolean
     */
    public function getAnimCollapse() {
    	return $this->getExtConfigProperty("animCollapse");
    }
    
    // ApplyTo
    /**
     * The id of the node, a DOM node or an existing Element corresponding to a DIV that is already present in the document that specifies some panel-specific structural markup. When applyTo is used, constituent parts of the panel can be specified by CSS class name within the main element, and the panel will automatically create those components from that markup. Any required components not specified in the markup will be autogenerated if necessary. The following class names are supported (baseCls will be replaced by BaseCssClass):
     * <pre>
     * baseCls + '-header'
     * baseCls + '-header-text'
     * baseCls + '-bwrap'
     * baseCls + '-tbar'
     * baseCls + '-body'
     * baseCls + '-bbar'
     * baseCls + '-footer'
     * </pre>
     * Using this config, a call to render() is not required. If applyTo is specified, any value passed for renderTo will be ignored and the target element's parent node will automatically be used as the panel's container.
     * 
     * @param string|DOMNode|Element $value
     * @return PhpExt_Panel
     */
    public function setApplyTo($value) {
    	return parent::setApplyTo($value);
    }	
    /**
     * The id of the node, a DOM node or an existing Element corresponding to a DIV that is already present in the document that specifies some panel-specific structural markup. When applyTo is used, constituent parts of the panel can be specified by CSS class name within the main element, and the panel will automatically create those components from that markup. Any required components not specified in the markup will be autogenerated if necessary. The following class names are supported (baseCls will be replaced by BaseCssClass):
     * <pre>
     * baseCls + '-header'
     * baseCls + '-header-text'
     * baseCls + '-bwrap'
     * baseCls + '-tbar'
     * baseCls + '-body'
     * baseCls + '-bbar'
     * baseCls + '-footer'
     * </pre>
     * Using this config, a call to render() is not required. If applyTo is specified, any value passed for renderTo will be ignored and the target element's parent node will automatically be used as the panel's container.
     * 
     * @return string|DOMNode|Element
     */
    public function getApplyTo() {
    	return parent::getApplyTo();
    }
    
    
	// AutoLoad
	/**
	 * 
	 * @param $value PhpExt_AutoLoadConfigObject
	 * @return PhpExt_Panel
	 */
	public function setAutoLoad($value) {
		$this->setExtConfigProperty("autoLoad", $value);
		return $this;
	}	
	/**
	 * 
	 * @return PhpExt_AutoLoadConfigObject
	 */
	public function getAutoLoad() {
		return $this->getExtConfigProperty("autoLoad");
	}
	
    // AutoScroll
    /**
     * True to use overflow:'auto' on the panel's body element and show scroll bars automatically when necessary, false to clip any overflowing content (defaults to false).
     * @param boolean $value
     * @return PhpExt_Panel
     */
    public function setAutoScroll($value) {
    	$this->setExtConfigProperty("autoScroll", $value);
    	return $this;
    }	
    /**
     * True to use overflow:'auto' on the panel's body element and show scroll bars automatically when necessary, false to clip any overflowing content (defaults to false).
     * @return boolean
     */
    public function getAutoScroll() {
    	return $this->getExtConfigProperty("autoScroll");
    }
	
	// BaseCssClass
	/**
	 * The base CSS class to apply to this panel's element (defaults to 'x-panel').
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setBaseCssClass($value) {
		$this->setExtConfigProperty("baseCls", $value);
		return $this;
	}	
	/**
	 * The base CSS class to apply to this panel's element (defaults to 'x-panel').
	 * @return string
	 */
	public function getBaseCssClass() {
		return $this->getExtConfigProperty("baseCls");
	}
	public $BaseCssClass = null;
	
	// BottomToolbar    
    /**
     * @var PhpExt_Toolbar_Toolbar
     */
    protected $_bottomToolbar;
    /**
     * The bottom toolbar of the panel. This is a PhpExt_Toolbar_Toolbar object or any of its descendants. To access the bottom toolbar after javascript render, use getBottomToolbar.
     * @param PhpExt_Toolbar_Toolbar $value
     * @return PhpExt_Panel
     */
    public function setBottomToolbar(PhpExt_Toolbar_Toolbar $value) {
		$this->_bottomToolbar = $value;
		$this->_extConfigProperties['bbar'] = $this->_bottomToolbar;
		return $this;
	}
	/**
	 * The bottom toolbar of the panel. This is a PhpExt_Toolbar_Toolbar object or any of its descendants. To access the bottom toolbar after javascript render, use getBottomToolbar.
	 * @return PhpExt_Toolbar_Toolbar
	 */
	public function getBottomToolbar() {
		return $this->_bottomToolbar;
	}

	// BodyBorder
	/**
	 * True to display an interior border on the body element of the panel, false to hide it (defaults to true). This only applies when border == true. If border == true and bodyBorder == false, the border will display as a 1px wide inset border, giving the entire body element an inset appearance.
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setBodyBorder($value) {
		$this->setExtConfigProperty("bodyBorder", $value);
		return $this;
	}	
	/**
	 * True to display an interior border on the body element of the panel, false to hide it (defaults to true). This only applies when border == true. If border == true and bodyBorder == false, the border will display as a 1px wide inset border, giving the entire body element an inset appearance.
	 * @return boolean
	 */
	public function getBodyBorder() {
		return $this->getExtConfigProperty("bodyBorder");
	}

	// BodyStyle
	/**
	 * Custom CSS styles to be applied to the body element in the format expected by Ext.Element.applyStyles (defaults to null).
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setBodyStyle($value) {
		$this->setExtConfigProperty("bodyStyle", $value);
		return $this;
	}	
	/**
	 * Custom CSS styles to be applied to the body element in the format expected by Ext.Element.applyStyles (defaults to null).
	 * @return string
	 */
	public function getBodyStyle() {
		return $this->getExtConfigProperty("bodyStyle");
	}
	
	
	// Border
	/**
	 * True to display the borders of the panel's body element, false to hide them (defaults to true). By default, the border is a 2px wide inset border, but this can be further altered by setting bodyBorder to false.
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setBorder($value) {
		$this->setExtConfigProperty("border", $value);
		return $this;
	}	
	/**
	 * True to display the borders of the panel's body element, false to hide them (defaults to true). By default, the border is a 2px wide inset border, but this can be further altered by setting bodyBorder to false.
	 * @return boolean
	 */
	public function getBorder() {
		return $this->getExtConfigProperty("border");
	}
	
	// ButtonAlign
	/**
	 * The alignment of any buttons added to this panel. Valid values are:
	 * - PhpExt_Ext::EXT_HALIGN_LEFT	  
	 * - PhpExt_Ext::EXT_HALIGN_RIGHT
	 * - PhpExt_Ext::EXT_HALIGN_CENTER
	 * Defaults to PhpExt_Ext::EXT_HALIGN_RIGHT
	 * 
	 * @uses PhpExt_Ext::EXT_HALIGN_LEFT	  
	 * @uses PhpExt_Ext::EXT_HALIGN_RIGHT
	 * @uses PhpExt_Ext::EXT_HALIGN_CENTER
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setButtonAlign($value) {
		$this->setExtConfigProperty("buttonAlign", $value);
		return $this;
	}	
	/**
	 * 
	 * @return string
	 */
	public function getButtonAlign() {
		return $this->getExtConfigProperty("buttonAlign");
	}
	
	// Buttons
    /**
	 * A collection of PhpExt_Button Objects
	 * 
	 * @var PhpExt_ButtonCollection
	 */
	protected $_buttons = null;
	/**
	 * 
	 * @return PhpExt_ButtonCollection
	 */
	public function getButtons() {
		return $this->_buttons;
	}
	
	// CollapseFirst
	/**
	 * True to make sure the collapse/expand toggle button always renders first (to the left of) any other tools in the panel's title bar, false to render it last (defaults to true).
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setCollapseFirst($value) {
		$this->setExtConfigProperty("collapseFirst", $value);
		return $this;
	}	
	/**
	 * True to make sure the collapse/expand toggle button always renders first (to the left of) any other tools in the panel's title bar, false to render it last (defaults to true).
	 * @return boolean
	 */
	public function getCollapseFirst() {
		return $this->getExtConfigProperty("collapseFirst");
	}
	
	// Collapsed
	/**
	 * True to render the panel collapsed, false to render it expanded (defaults to false).
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setCollapsed($value) {
		$this->setExtConfigProperty("collapsed", $value);
		return $this;
	}	
	/**
	 * True to render the panel collapsed, false to render it expanded (defaults to false).
	 * @return boolean
	 */
	public function getCollapsed() {
		return $this->getExtConfigProperty("collapsed");
	}	
	
	// CollapsedCssClass
	/**
	 * A CSS class to add to the panel's element after it has been collapsed (defaults to 'x-panel-collapsed').
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setCollapsedCssClass($value) {
		$this->setExtConfigProperty("collapsedCls", $value);
		return $this;
	}	
	/**
	 * A CSS class to add to the panel's element after it has been collapsed (defaults to 'x-panel-collapsed').
	 * @return string
	 */
	public function getCollapsedCssClass() {
		return $this->getExtConfigProperty("collapsedCls");
	}
	
	// Collapsible
	/**
	 * True to make the panel collapsible and have the expand/collapse toggle button automatically rendered into the header tool button area, false to keep the panel statically sized with no button (defaults to false).
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setCollapsible($value) {
		$this->setExtConfigProperty("collapsible", $value);
		return $this;
	}	
	/**
	 * True to make the panel collapsible and have the expand/collapse toggle button automatically rendered into the header tool button area, false to keep the panel statically sized with no button (defaults to false).
	 * @return boolean
	 */
	public function getCollapsible() {
		return $this->getExtConfigProperty("collapsible");
	}
	
	// ContentElement
	/**
	 * The id of an existing HTML node to use as the panel's body content (defaults to '').
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setContentElement($value) {
		$this->setExtConfigProperty("contentEl", $value);
		return $this;
	}	
	/**
	 * The id of an existing HTML node to use as the panel's body content (defaults to '').
	 * @return string
	 */
	public function getContentElement() {
		return $this->getExtConfigProperty("contentEl");
	}
	
	// Draggable
	/**
	 * True to enable dragging of this Panel (defaults to false). For custom drag/drop implementations, an Ext.Panel.DD config could also be passed in this config instead of true, although Ext.Panel.DD is an internal, undocumented class.
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setDraggable($value) {
		$this->setExtConfigProperty("draggable", $value);
		return $this;
	}	
	/**
	 * True to enable dragging of this Panel (defaults to false). For custom drag/drop implementations, an Ext.Panel.DD config could also be passed in this config instead of true, although Ext.Panel.DD is an internal, undocumented class.
	 * @return boolean
	 */
	public function getDraggable() {
		return $this->getExtConfigProperty("draggable");
	}

	// Elements
	/**
	 * A comma-delimited list of panel elements to initialize when the panel is rendered. Normally, this list will be generated automatically based on the items added to the panel at config time, but sometimes it might be useful to make sure a structural element is rendered even if not specified at config time (for example, you may want to add a button or toolbar dynamically after the panel has been rendered). Adding those elements to this list will allocate the required placeholders in the panel when it is rendered. Valid values are
     * 
     * header
     * tbar (top bar)
     * body
     * bbar (bottom bar)
     * footer
     * 
     * Defaults to 'body'.
     * 
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setElements($value) {
		$this->setExtConfigProperty("elements", $value);
		return $this;
	}	
	/**
	 * A comma-delimited list of panel elements to initialize when the panel is rendered. Normally, this list will be generated automatically based on the items added to the panel at config time, but sometimes it might be useful to make sure a structural element is rendered even if not specified at config time (for example, you may want to add a button or toolbar dynamically after the panel has been rendered). Adding those elements to this list will allocate the required placeholders in the panel when it is rendered. Valid values are
     * 
     * header
     * tbar (top bar)
     * body
     * bbar (bottom bar)
     * footer
     * 
     * Defaults to 'body'.
     * 
	 * @return string
	 */
	public function getElements() {
		return $this->getExtConfigProperty("elements");
	}

	// Floating
	/**
	 * True to float the panel (absolute position it with automatic shimming and shadow), false to display it inline where it is rendered (defaults to false). Note that by default, setting floating to true will cause the panel to display at negative offsets so that it is hidden -- because the panel is absolute positioned, the position must be set explicitly after render (e.g., myPanel.setPosition(100,100);). Also, when floating a panel you should always assign a fixed width, otherwise it will be auto width and will expand to fill to the right edge of the viewport.
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setFloating($value) {
		$this->setExtConfigProperty("floating", $value);
		return $this;
	}	
	/**
	 * True to float the panel (absolute position it with automatic shimming and shadow), false to display it inline where it is rendered (defaults to false). Note that by default, setting floating to true will cause the panel to display at negative offsets so that it is hidden -- because the panel is absolute positioned, the position must be set explicitly after render (e.g., myPanel.setPosition(100,100);). Also, when floating a panel you should always assign a fixed width, otherwise it will be auto width and will expand to fill to the right edge of the viewport.
	 * @return boolean
	 */
	public function getFloating() {
		return $this->getExtConfigProperty("floating");
	}
	
	// Footer
	/**
	 * True to create the footer element explicitly, false to skip creating it. By default, when footer is not specified, if one or more buttons have been added to the panel the footer will be created automatically, otherwise it will not.
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setFooter($value) {
		$this->setExtConfigProperty("footer", $value);
		return $this;
	}	
	/**
	 * True to create the footer element explicitly, false to skip creating it. By default, when footer is not specified, if one or more buttons have been added to the panel the footer will be created automatically, otherwise it will not.
	 * @return boolean
	 */
	public function getFooter() {
		return $this->getExtConfigProperty("footer");
	}
	
	// Frame
	/**
	 * True to render the panel with custom rounded borders, false to render with plain 1px square borders (defaults to false).
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setFrame($value) {
		$this->setExtConfigProperty("frame", $value);
		return $this;
	}	
	/**
	 * True to render the panel with custom rounded borders, false to render with plain 1px square borders (defaults to false).
	 * @return boolean
	 */
	public function getFrame() {
		return $this->getExtConfigProperty("frame");
	}
	
	// Header
	/**
	 * True to create the header element explicitly, false to skip creating it. By default, when header is not specified, if a title is set the header will be created automatically, otherwise it will not. If a title is set but header is explicitly set to false, the header will not be rendered.
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setHeader($value) {
		$this->setExtConfigProperty("header", $value);
		return $this;
	}	
	/**
	 * True to create the header element explicitly, false to skip creating it. By default, when header is not specified, if a title is set the header will be created automatically, otherwise it will not. If a title is set but header is explicitly set to false, the header will not be rendered.
	 * @return boolean
	 */
	public function getHeader() {
		return $this->getExtConfigProperty("header");
	}
	
	// HeaderAsText
	/**
	 * True to display the panel title in the header, false to hide it (defaults to true).
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setHeaderAsText($value) {
		$this->setExtConfigProperty("headerAsText", $value);
		return $this;
	}	
	/**
	 * True to display the panel title in the header, false to hide it (defaults to true).
	 * @return boolean
	 */
	public function getHeaderAsText() {
		return $this->getExtConfigProperty("headerAsText");
	}
	
	// HideCollapseTool
	/**
	 * True to hide the expand/collapse toggle button when collapsible = true, false to display it (defaults to false).
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setHideCollapseTool($value) {
		$this->setExtConfigProperty("hideCollapseTool", $value);
		return $this;
	}	
	/**
	 * True to hide the expand/collapse toggle button when collapsible = true, false to display it (defaults to false).
	 * @return boolean
	 */
	public function getHideCollapseTool() {
		return $this->getExtConfigProperty("hideCollapseTool");
	}
	
	// Html
	/**
	 * An HTML fragment, or a DomHelper specification to use as the panel's body content (defaults to '').
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setHtml($value) {
		$this->setExtConfigProperty("html", $value);
		return $this;
	}	
	/**
	 * An HTML fragment, or a DomHelper specification to use as the panel's body content (defaults to '').
	 * @return string
	 */
	public function getHtml() {
		return $this->getExtConfigProperty("html");
	}
	
	// IconCssClass
	/**
	 * A CSS class that will provide a background image to be used as the panel header icon (defaults to '').
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setIconCssClass($value) {
		$this->setExtConfigProperty("iconCls", $value);
		return $this;
	}	
	/**
	 * A CSS class that will provide a background image to be used as the panel header icon (defaults to '').
	 * @return string
	 */
	public function getIconCssClass() {
		return $this->getExtConfigProperty("iconCls");
	}

	// Keys
	/**
	 * A KeyMap config object (in the format expected by Ext.KeyMap.addBinding used to assign custom key handling to this panel (defaults to null).
	 * @param string $value
	 * @return PhpExt_Panel
	 */
	public function setKeys($value) {
		$this->setExtConfigProperty("keys", $value);
		return $this;
	}	
	/**
	 * A KeyMap config object (in the format expected by Ext.KeyMap.addBinding used to assign custom key handling to this panel (defaults to null).
	 * @return string
	 */
	public function getKeys() {
		return $this->getExtConfigProperty("keys");
	}

	// MaskDisabled
	/**
	 * True to mask the panel when it is disabled, false to not mask it (defaults to true). 
	 * Either way, the panel will always tell its contained elements to disable themselves when it is disabled, 
	 * but masking the panel can provide an additional visual cue that the panel is disabled.
	 * @param boolean $value
	 * @return PhpExt_Panel
	 */
	public function setMaskDisabled($value) {
		$this->setExtConfigProperty("maskDisabled", $value);
		return $this;
	}	
	/**
	 * True to mask the panel when it is disabled, false to not mask it (defaults to true). 
	 * Either way, the panel will always tell its contained elements to disable themselves when it is disabled, 
	 * but masking the panel can provide an additional visual cue that the panel is disabled.
	 * @return boolean
	 */
	public function getMaskDisabled() {
		return $this->getExtConfigProperty("maskDisabled");
	}

	// MinButtonWidth
	/**
	 * Minimum width in pixels of all buttons in this panel (defaults to 75)
	 * @param integer $value
	 * @return PhpExt_Panel
	 */
	public function setMinButtonWidth($value) {
		$this->setExtConfigProperty("minButtonWidth", $value);
		return $this;
	}	
	/**
	 * Minimum width in pixels of all buttons in this panel (defaults to 75)
	 * @return integer
	 */
	public function getMinButtonWidth() {
		return $this->getExtConfigProperty("minButtonWidth");
	}
 
    // Shadow
    /**
     * True (or a valid PhpExt_Shadow.Mode value) to display a shadow behind the panel, false to display no shadow (defaults to 'PhpExt_MODE_SIDES'). Note that this option only applies when floating = true.
     * @param boolean $value
     * @return PhpExt_Panel
     */
    public function setShadow($value) {
    	$this->setExtConfigProperty("shadow", $value);
    	return $this;
    }	
    /**
     * True (or a valid PhpExt_Shadow.Mode value) to display a shadow behind the panel, false to display no shadow (defaults to 'PhpExt_MODE_SIDES'). Note that this option only applies when floating = true.
     * @return boolean
     */
    public function getShadow() {
    	return $this->getExtConfigProperty("shadow");
    }
	
	// ShadowOffset
	/**
	 * The number of pixels to offset the shadow if displayed (defaults to 4). Note that this option only applies when floating = true.
	 * @param integer $value
	 * @return PhpExt_Panel
	 */
	public function setShadowOffset($value) {
		$this->setExtConfigProperty("shadowOffset", $value);
		return $this;
	}	
	/**
	 * The number of pixels to offset the shadow if displayed (defaults to 4). Note that this option only applies when floating = true.
	 * @return integer
	 */
	public function getShadowOffset() {
		return $this->getExtConfigProperty("shadowOffset");
	}
    

    // Shim
    /**
     * False to disable the iframe shim in browsers which need one (defaults to true). Note that this option only applies when floating = true.
     * @param boolean $value
     * @return PhpExt_Panel
     */
    public function setShim($value) {
    	$this->setExtConfigProperty("shim", $value);
    	return $this;
    }	
    /**
     * False to disable the iframe shim in browsers which need one (defaults to true). Note that this option only applies when floating = true.
     * @return boolean
     */
    public function getShim() {
    	return $this->getExtConfigProperty("shim");
    }
	
	// TopToolbar
	/**
	 * 
	 * @var PhpExt_Toolbar_Toolbar
	 */
	protected $_topToolbar = null;
    /**
     * The top toolbar of the panel. This is a PhpExt_Toolbar_Toolbar object or any of its descendants.
     * @param PhpExt_Toolbar_Toolbar $value
     * @return PhpExt_Panel
     */
    public function setTopToolbar(PhpExt_Toolbar_Toolbar $value) {
		$this->_topToolbar = $value;
		$this->_extConfigProperties['tbar'] = $this->_topToolbar;
		return $this;
	}	
	/**
	 * The top toolbar of the panel. This is a PhpExt_Toolbar_Toolbar object or any of its descendants.
	 * @return PhpExt_Toolbar_Toolbar
	 */
	public function getTopToolbar() {
		return $this->_topToolbar;
	}
	
    // Title
    /**
     * The title text to display in the panel header (defaults to ''). When a title is specified the header element will automatically be created and displayed unless header is explicitly set to false. If you don't want to specify a title at config time, but you may want one later, you must either specify a non-empty title (a blank space ' ' will do) or header:true so that the container element will get created.
     * @param string $value
     * @return PhpExt_Panel
     */
    public function setTitle($value) {
    	$this->setExtConfigProperty("title", $value);
    	return $this;
    }	
    /**
     * The title text to display in the panel header (defaults to ''). When a title is specified the header element will automatically be created and displayed unless header is explicitly set to false. If you don't want to specify a title at config time, but you may want one later, you must either specify a non-empty title (a blank space ' ' will do) or header:true so that the container element will get created.
     * @return string
     */
    public function getTitle() {
    	return $this->getExtConfigProperty("title");
    }	

    // TitleCollapse
    /**
     * True to allow expanding and collapsing the panel (when collapsible = true) by clicking anywhere in the header bar, false to allow it only by clicking to tool button (defaults to false).
     * @param boolean $value 
     * @return PhpExt_Panel
     */
    public function setTitleCollapse($value) {
    	$this->setExtConfigProperty("titleCollapse", $value);
    	return $this;
    }	
    /**
     * True to allow expanding and collapsing the panel (when collapsible = true) by clicking anywhere in the header bar, false to allow it only by clicking to tool button (defaults to false).
     * @return boolean
     */
    public function getTitleCollapse() {
    	return $this->getExtConfigProperty("titleCollapse");
    }
    
    // LoadMask
    /**
     * The id of the DOM Element which servers as loading mask to show loading messages
     * @param string $value 
     * @return PhpExt_Panel
     */
    public function setLoadMask($value) {
    	$this->setExtConfigProperty("loadMask", $value);
    	return $this;
    }	
    /**
     * The id of the DOM Element which servers as loading mask to show loading messages
     * @return string
     */
    public function getLoadMask() {
    	return $this->getExtConfigProperty("loadMask");
    }

    // Tools
    /**
 	* @var PhpExt_ToolConfigObjectCollection
 	*/
    protected $_tools;	
    /**
     * A {@link PhpExt_ToolConfigObjectCollection} of tool buttons to be added to the header tool area.
     * Note that apart from the toggle tool which is provided when a panel is collapsible, these tools only provide the visual button. Any required functionality must be provided by adding handlers that implement the necessary behavior.
     * @return PhpExt_ToolConfigObjectCollection
     */
    public function getTools() {
    	return $this->getExtConfigProperty("tools");
    }
    
    /**
     * A {@link PhpExt_ToolConfigObject} to add to the tools collection
     * @param PhpExt_ToolConfigObject $tool
     * @param string $name Optional key to locate the tool on the collection
     * @return PhpExt_Panel
     */
    public function addTool($tool, $name = null) {
        $this->_tools->add($tool, $name);
        return $this;
    }
	
	
	public function __construct() {
		parent::__construct();
		$this->setExtClassInfo("Ext.Panel","panel");
		
		$validProps = array(
		    "animCollapse",
		    "applyTo",
		    "autoLoad",
		    "autoScroll",
		    "baseCls",
		    "bbar",
		    "bodyBorder",
		    "bodyStyle",
		    "border",
		    "buttonAlign",
		    "buttons",
		    "collapseFirst",
		    "collapsed",
		    "collapsedCls",
		    "collapsible",
		    "contentEl",
		    "draggable",
		    "elements",
		    "floating",
		    "footer",
		    "frame",
		    "header",
		    "headerAsText",
		    "hideCollapseTool",
		    "html",
		    "iconCls",
		    "keys",
		    "maskDisabled",
		    "minButtonWidth",
		    "shadow",
		    "shadowOffset",
		    "shim",
		    "tbar",
		    "title",
		    "titleCollapse",
		    "tools" 
		);
		$this->addValidConfigProperties($validProps);

		$this->_bottomToolbar = new PhpExt_Toolbar_Toolbar();
		$this->_extConfigProperties['bbar'] = $this->_bottomToolbar;
		$this->_buttons = new PhpExt_ButtonCollection();
		$this->_extConfigProperties['buttons'] = $this->_buttons;		
		$this->_topToolbar = new PhpExt_Toolbar_Toolbar();
		$this->_extConfigProperties['tbar'] = $this->_topToolbar;
		$this->_tools = new PhpExt_ToolConfigObjectCollection();
		$this->_tools->setForceArray(true);
		$this->_extConfigProperties['tools'] = $this->_tools;
	}

    protected function getConfigParams($lazy = false) {        
		if ($this->_bottomToolbar->getItems()->getCount() == 0 && !$this->_bottomToolbar->getMustRender())
		    $this->setExtConfigProperty("bbar", null);
		if ($this->_topToolbar->getItems()->getCount() == 0 && !$this->_topToolbar->getMustRender())
		    $this->setExtConfigProperty("tbar", null);
		if ($this->_tools->getCount() == 0)
		    $this->setExtConfigProperty("tools", null);
		
		return parent::getConfigParams($lazy);
	}
	
	/**
	 * Adds a button to the footer
	 *
	 * @param PhpExt_Button $field
	 * @return PhpExt_Button
	 */
	public function addButton($button) {
		$this->_buttons->add($button);
		return $button;
	}
		
}

