<?php
/*
 #########################################################################
#                       xt:Commerce  4.1 Shopsoftware
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# Copyright 2007-2011 xt:Commerce International Ltd. All Rights Reserved.
# This file may not be redistributed in whole or significant part.
# Content of this file is Protected By International Copyright Laws.
#
# ~~~~~~ xt:Commerce  4.1 Shopsoftware IS NOT FREE SOFTWARE ~~~~~~~
#
# http://www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# @version $Id$
# @copyright xt:Commerce International Ltd., www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# xt:Commerce International Ltd., Kafkasou 9, Aglantzia, CY-2112 Nicosia
#
# office@xt-commerce.com
#
#########################################################################
*/

class WizardErrorHandler extends Singleton {
	
	protected $_outputErrros = DISPLAY_ERRORS;
	
	protected function __construct() {
		set_error_handler(array($this, 'handle'));
		parent::__construct();
	}
	
	/**
	 * Set if the errors should be outputed to the browser or logged to file
	 * @param boolean $bool
	 * @return WizardErrorHandler
	 */
	public function setOutputErros($bool) {
		$this->_outputErrros = (bool)$bool;
		return $this;
	}
	
	/**
	 * Error handling function
	 * @param int $errno
	 * @param string $errstr
	 * @param string $errfile
	 * @param int $errline
	 * @param array $errcontext
	 * @return void|boolean
	 */
	public function handle($errno, $errstr, $errfile, $errline, $errcontext) {
		if (!(error_reporting() & $errno)) {
			// This error code is not included in error_reporting
			return;
		}
		
		$time = date('Y-m-d h:i:s');
		$stop = false;
		switch ($errno) {
			case E_USER_ERROR:
				$msg = "[$time] Error [$errno] $errstr. Fatal error on line $errline in file $errfile\n";
				$stop = true;
       		break;
			case E_USER_WARNING:
				$msg = "[$time] WARNING [$errno] $errstr. Error ocurred in $errfile on line $errline\n";
			break;
		
			case E_USER_NOTICE:
				$msg = "[$time] NOTICE [$errno] $errstr. Error ocurred in $errfile on line $errline\n";
			break;
		
			default:
				$msg = "[$time] Unknown error type: [$errno] $errstr. Error ocurred in $errfile on line $errline\n";
			break;
		}
		
		if ($this->_outputErrros) {
			echo $msg;
		} else {
			WizardLogger::getInstance()->log($msg);
		}
		
		if ($stop) {
			//@TODO Stop the wizard
			exit(1);
		}
		
		/* Don't execute PHP internal error handler */
		return true;
	}
	
	/**
	 * @return WizardErrorHandler
	 */
	public static function getInstance() {
		return parent::getInstance();
	}
}