<?php
/*
 #########################################################################
#                       xt:Commerce  4.1 Shopsoftware
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# Copyright 2007-2011 xt:Commerce International Ltd. All Rights Reserved.
# This file may not be redistributed in whole or significant part.
# Content of this file is Protected By International Copyright Laws.
#
# ~~~~~~ xt:Commerce  4.1 Shopsoftware IS NOT FREE SOFTWARE ~~~~~~~
#
# http://www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# @version $Id$
# @copyright xt:Commerce International Ltd., www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# xt:Commerce International Ltd., Kafkasou 9, Aglantzia, CY-2112 Nicosia
#
# office@xt-commerce.com
#
#########################################################################
*/

interface IExecutableScript {
	
	/**
	 * Array of pages available for this script
	 */
	public function getPages();
	
	/**
	 * Check if there is next page
	 * @param string $currentPage
	 */
	public function hasNextPage($currentPage);
	
	/**
	 * Get next page
	 * @param WizardPage $currentPage
	 */
	public function getNextPage($currentPage);
	
	/**
	 * Get page
	 * @param WizardPage $currentPage
	 */
	public function getPage($currentPage);
	
	/**
	 * Get the type of the wizard that this script is for.
	 * Returns Wizard::WIZARD_TYPE_INSTALL or Wizard::WIZARD_TYPE_UPDATE
	 */
	public function getWizardType();
	
	/**
	 * Needed only for update scripts. Needed to determine if the script can be applied
	 * to the current shop version
	 */
	public function getAppliableShopVersion();
	
	/**
	 * Get unique id for this script.
	 */
	public function getUniqueId();
	
	/**
	 * Get script title that will be show in the listing
	 */
	public function getScriptTitle();
}