<?php
/*
 #########################################################################
 #                       xt:Commerce  4.1 Shopsoftware
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # Copyright 2007-2011 xt:Commerce International Ltd. All Rights Reserved.
 # This file may not be redistributed in whole or significant part.
 # Content of this file is Protected By International Copyright Laws.
 #
 # ~~~~~~ xt:Commerce  4.1 Shopsoftware IS NOT FREE SOFTWARE ~~~~~~~
 #
 # http://www.xt-commerce.com
 #
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # @version $Id$
 # @copyright xt:Commerce International Ltd., www.xt-commerce.com
 #
 # ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 #
 # xt:Commerce International Ltd., Kafkasou 9, Aglantzia, CY-2112 Nicosia
 #
 # office@xt-commerce.com
 #
 #########################################################################
 */


$root_dir = dirname(__FILE__);
$root_dir = str_replace('xtWizard','',$root_dir);

$sys_dir = $_SERVER['SCRIPT_NAME'];
$sys_dir = substr($sys_dir, 0, strripos($sys_dir, '/')+1);
$sys_dir = str_replace('xtWizard/', '', $sys_dir);

define('_SRV_WEBROOT',$root_dir);
define('_SRV_WEB', $sys_dir);

define('_DIR_SEPERATOR',DIRECTORY_SEPARATOR );


$ini_folders = array();
$ini_folders[]='';
$ini_folders[]='xtWizard';
$ini_folders[]='xtAdmin';
$ini_folders[]='plugins'.DIRECTORY_SEPARATOR .'xt_payments';
$ini_folders[]='plugins'.DIRECTORY_SEPARATOR .'xt_payments'.DIRECTORY_SEPARATOR .'templates';
$ini_folders[]='plugins'.DIRECTORY_SEPARATOR .'xt_payments'.DIRECTORY_SEPARATOR .'pages';
$ini_folders[]='plugins'.DIRECTORY_SEPARATOR .'magnalister';
$ini_folders[]='plugins'.DIRECTORY_SEPARATOR .'xt_customers_online_tracking';
$ini_folders[]='plugins'.DIRECTORY_SEPARATOR .'xt_customers_online_tracking' . DIRECTORY_SEPARATOR . 'pages';
$ini_folders[]='xtFramework'.DIRECTORY_SEPARATOR .'library'.DIRECTORY_SEPARATOR .'tiny_mce'.DIRECTORY_SEPARATOR .'plugins'.DIRECTORY_SEPARATOR .'advimage';



// check if there is an ioncube loader installed

include 'functions/ioncube_wizzard.php';

function loaderInfo() {

    $info = required_loader();

    $download_url = IONCUBE_DOWNLOADS_SERVER.'/ioncube_loaders_'.$info['oscode'].'_'.$info['arch'].'.zip';
    $info['download_url']=$download_url;
    return $info;

}

function generateIniFile($dir) {

    $dir = _SRV_WEBROOT.$dir;
    $zend_lines = zend_extension_lines(_SRV_WEBROOT.'ioncube');

	// Strato session.save_path
	if (strpos(_SRV_WEBROOT, '/strato/') !== FALSE)
		$zend_lines .= "\n\nsession.save_path = \"/home/strato/www/my/www.my-Shop.com/htdocs/cache/\"";

    if (@is_writeable($dir)) {
        // check if file exists
        if (file_exists($dir._DIR_SEPERATOR.'php.ini')) {
            $content = file_get_contents($dir._DIR_SEPERATOR.'php.ini');
            // ioncube line there ?

            // check if writeable
            if (!is_writeable($dir._DIR_SEPERATOR.'php.ini')) {
                return false;
            } else {
                if (!strstr($content,'ioncube_loader')) {
                    $fh = @fopen($dir._DIR_SEPERATOR.'php.ini',"a+");
                    if ($fh !== false) {
                        foreach ($zend_lines as $line) {
                            fwrite($fh,$line . PHP_EOL);
                        }
                    }
                    fclose($fh);
                    return true;
                }
            }
            return true;
        } else {
            $fh = @fopen($dir._DIR_SEPERATOR.'php.ini',"wb");
            if ($fh !== false) {
                foreach ($zend_lines as $line) {
                    fwrite($fh,$line . PHP_EOL);
                }
            }
            fclose($fh);
            return true;
        }
    } else {
        return $zend_lines;
    }


}


function showPage($step=1) {
    global $ini_folders;

    switch ($step) {

        case '1': // show info only + instructions to download loaders, reload button
        case '2':

            $loader_info = loaderInfo();

            $target_path = _SRV_WEB.'ioncube';

            $file_control = _SRV_WEBROOT.'ioncube/'.$loader_info['file'];

            // check if uploaded
            $next_step = false;
            if ($step=='2') {
            if (file_exists($file_control)) {

                echo '<ul class="info_success"><li class="infoSuccess">Ioncube Loader wurde auf Ihrem Server gefunden!</li></ul>';
                $next_step = true;
            } else {
                echo '<ul class="info_error"><li class="infoError">Der Ioncube Loader <b>'.$file_control.'</b> wurde noch nicht auf Ihrem System gefunden, bitte überprüfen Sie untere Schritte.</li></ul>';
            }
            } else {
                echo '<ul class="info_error"><li class="infoError">Ioncube Loader ist auf Ihrem Server nicht installiert!</li></ul>';

            }


        if (!$next_step) {
                echo '<h2>Notwendige Schritte vor der Installation von xt:Commerce 4.1</h2>';

                echo '<h3>1. Download des IonCube Loaders</h3>';
                echo '<p>Laden Sie bitte den IonCube Loader für Ihr Betriebssystem ('.$loader_info['osname'].' '.$loader_info['arch'].')<p>';
                echo '<a href="'.$loader_info['download_url'].'" target="_blank" class="button">IonCube Downloaden</a>';
                echo '<h3>2. Upload auf Ihren Server</h3>';
                echo '<p>Entpacken Sie die .zip Datei und laden Sie das den Inhalt des Verzeichnisses <b>ioncube/</b> in das Verzeichnis <b>'.$target_path.'</b> auf Ihrem Server';

                echo '<h3>3. Korrekten Upload testen</h3>';
                echo '<a href="no-loader.php?step=2" class="button">Testen</a>';
        } else {
                echo '</br></br><a href="no-loader.php?step=3" class="button">IonCube Loader Installieren</a>';
        }


            break;

        case '3': //

            echo '<h2>Installation des IonCube Loaders über php.ini Datein</h2>';
            echo '<p>Das Installationsscript versucht nun folgende Installationsdatein zu erzeugen....</p>';

            // check if files/folders are writeable
            $writeable = true;
            foreach ($ini_folders as $id =>$dir) {
                $resp = generateIniFile($dir);
                if (is_array($resp)) {
                    echo '<ul class="info_error"><li class="infoError">Verzeichnis '._SRV_WEBROOT.$dir.' nicht beschreibbar</li></ul>';
                    $writeable = false;
                } else {
                    echo '<ul class="info_success"><li class="infoSuccess">Datei '.$dir.'/php.ini wurde angelegt</li></ul>';
                }
            }

            if (!$writeable) {

                echo '<h2>Setzen Sie schreibrechte für o.g. Verzeichnisse und laden die Seite neu</h2>';
                echo '<a href="no-loader.php?step=3" class="button">Erneut versuchen</a>';
            } else {
                echo '</br></br><a href="no-loader.php?step=4" class="button">IonCube Installation testen</a>';
            }



        break;


        case '4':

            if(extension_loaded('ionCube Loader')) {

                echo '<ul class="info_success"><li class="infoSuccess">IonCube Installation war erfolgreich!</li></ul>';
                echo '</br></br><a href="index.php" class="button">Weiter zur Shopinstallation</a>';
            } else {
                echo '<ul class="info_error"><li class="infoError">IonCube konnte nicht erfolgreich installiert werden!</li></ul>';
                echo '<p>Die angelegte php.ini Datei wird von Ihrem Hoster nicht verarbeitet, bitte kontaktieren Sie den xt:Commerce Support unter <a href="mail:helpdesk@xt-commerce.com">helpdesk@xt-commerce.com</a> um eine mögliche Lösung für Ihren Provider zu prüfen.</p>';
            }



            break;

    }



}

if (isset($_GET['step'])) {
    $step = (int)$_GET['step'];
} else {
    $step = '1';
}


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="de" lang="de">
<head>
    <link rel="stylesheet" type="text/css" href="<?php echo _SRV_WEB; ?>xtWizard/templates/css/installer.css" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <?php
    if (isset($link_next)) {
        ?>
        <meta http-equiv="refresh" content="2; URL=<?php echo $link_next; ?>">
    <?php
    }
    ?>
    <link rel="stylesheet" href="<?php echo _SRV_WEB; ?>xtWizard/templates/css/colorbox.css" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
    <script src="<?php echo _SRV_WEB; ?>xtWizard/templates/js/jquery.colorbox-min.js"></script>
    <script>
        $(document).ready(function(){
            $(".iframe").colorbox({iframe:true, width:"800px", height:"80%"});
            $(".inline").colorbox({inline:true, width:"50%"});
        });
    </script>
</head>
<body>
<div class="wrapper startpage">
    <div class="w2">
        <div class="w2-box">
            <div class="w3">
                <div id="header">
                    <strong class="logo"><a href="http://www.xt-commerce.com/">xtCommerce shopsoftware</a></strong>


                </div>

                <div id="main" class="home">
                    <h1>IonCube Loader Installation</h1>
                    <?php

                        showPage($step);

                    ?>
                </div>

                <div class="clear"></div>
            </div>
            <div id="footer">
                <div class="footer-inf">
                    <div class="txt">
                        <p>Copyright &copy; 2013 xt:Commerce GmbH / xt:Commerce International Ltd. - All Rights Reserved</p>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
    </div>
    <div class="clear"></div>
</div>
</body>
</html>