<?php
/*
 #########################################################################
#                       xt:Commerce  4.1 Shopsoftware
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# Copyright 2007-2011 xt:Commerce International Ltd. All Rights Reserved.
# This file may not be redistributed in whole or significant part.
# Content of this file is Protected By International Copyright Laws.
#
# ~~~~~~ xt:Commerce  4.1 Shopsoftware IS NOT FREE SOFTWARE ~~~~~~~
#
# http://www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# @version $Id$
# @copyright xt:Commerce International Ltd., www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# xt:Commerce International Ltd., Kafkasou 9, Aglantzia, CY-2112 Nicosia
#
# office@xt-commerce.com
#
#########################################################################
*/

defined('_VALID_CALL') or die('Direct Access is not allowed.');
$file =  _SRV_WEBROOT.'xtFramework/classes/class.product_sql_query.php';

class category_tree extends getCategorySQL_query {
    /**
     * Position before
     * @var string
     */
    const POSITION_BEFORE = 'above';
    
    /**
     * Position first child
     * @var string
     */
    const POSITION_FIRST_CHILD = 'first_child';
    
    /**
     * Position last child
     * @var string
     */
    const POSITION_LAST_CHILD = 'last_child';
    
    /**
     * Position after
     * @var string
     */
    const POSITION_AFTER = 'below';
    
    /**
     * Database adapter
     * @var object
     */
    protected static $_db = null;
    
    /**
     * Table name
     * @var string
     */
    protected $_table = TABLE_CATEGORIES;
    
    /**
     * Table description name
     * @var string
     */
    protected $_table_description = TABLE_CATEGORIES_DESCRIPTION;
    
    /**
     * Primary table column
     * @var string
     */
    protected $_primary_column = 'categories_id';
    
    /**
     * Categories left column name
     * @var string
     */
    protected $_column_left = 'categories_left';
    
    /**
     * Categories right column name
     * @var string
     */
    protected $_column_right = 'categories_right';
    
    /**
     * Categories parent_id
     * @var string
     */
    protected $_column_parent = 'parent_id';
    
    /**
     * @access private
     */
    protected $_nodeLevelName = 'level';
    
    /**
     * @access private
     */
    protected $_subNodesCountName = 'SubNodesCount';
    
    /**
     * @var array
     */
    protected $_joinConditions = array();
    
    /**
     * @var array
     */
    protected $_whereConditions = array();
    public static function setDbAdapter($db) 
    {
        self::$_db = $db;
    }
    
    /**
     * Get database adapter
     * @return object
     */
    public static function getDbAdapter() 
    {
        return self::$_db;
        
    }
    
    /**
     * Class constructor. If there is no defult database set it will initiliaze global
     * $db object.
     */
    public function __construct($_db) 
    {
        self::$_db = $_db;
        $this->setSQL_TABLE(TABLE_CATEGORIES . " AS c CROSS JOIN " . TABLE_CATEGORIES . " AS parent");
    }
    
   
    public function buildNestedSet($primaryKey = 'categories_id', $parentKey = 'parent_id', $leftKey = 'categories_left', $rightKey = 'categories_right')
    {
        $records = $this->getTree();
            
        list($left, $right) = $this->getNestedSet($records, $primaryKey);
            
        // Update the nested set
        foreach ($records as $row) {
            $key = $row[$primaryKey];
            if (($left[$key] != $row[$leftKey]) or ($right[$key] != $row[$rightKey])) {
                $values = array(
                        $leftKey => $left[$key],
                        $rightKey => $right[$key]
                );
                
                self::$_db->AutoExecute($this->_table, $values, 'UPDATE', $primaryKey."=".$key."");
            }
        }
    }
    
   
    /**
     * Get category three
     * @param string $categories_id
     * @param string $cached
     * @return array
     */
    public function getTree($cached = true)
    {
        global $language;
        static $tree_cache = array();
        
        if (empty($tree_cache) || !$cached) {
            $query = $this->getSQL_query();
                    
            $rs = self::$_db->Execute($query);
                        
            $return = array();
            if ($rs->RecordCount() > 0) {
            while(!$rs->EOF){
                $return[] = $rs->fields;
                $rs->MoveNext();
            }
                $rs->Close();
            }
            // Cache the result
            $return = $this->makeTree($return, $this->_primary_column, $this->_column_parent);
            $tree_cache = $return;
        }
        
        return $tree_cache;
    }
    
    function getSQL_query($cols = '') {
        global $xtPlugin;
        
        
        $this->setSQL_WHERE("and c.{$this->_column_left} BETWEEN parent.{$this->_column_left} AND parent.{$this->_column_right}");
        
        ($plugin_code = $xtPlugin->PluginCode('class.category_sql_query.php:getSQL_query_filter')) ? eval($plugin_code) : false;
         
        $this->getFilter();
        $this->getHooks();
       // $this->a_sql_cols = "," . join(',', $this->_selectTables) . $this->a_sql_cols;
        
        $sql = "
            SELECT
                COUNT(parent.{$this->_primary_column}) AS level, c.* 
                {$this->a_sql_cols} FROM {$this->a_sql_table}";
        if (is_data($this->a_sql_where))
            $sql.=' WHERE 1=1 '.$this->a_sql_where;
        $sql .= " GROUP BY c.{$this->_primary_column}, c.{$this->_column_left}, c.{$this->_column_right}";
        if (is_data($this->a_sql_sort))
            $sql.=' ORDER BY '.$this->a_sql_sort;
        if (is_data($this->a_sql_limit))
            $sql.=' LIMIT '.$this->a_sql_limit;
        
       
        $sql = str_replace(" c.categories_status = '1' and ","",$sql);
        
        return $sql;
    }

    protected function makeTree($rows, $idName, $parentIdName, $parent = 0, $level = 0)
    {
        $parentMap = array();
        foreach ($rows as $key => $row) {
            $parentId = (int)$row[$parentIdName];
            if (!isset($parentMap[$parentId]))
                $parentMap[$parentId] = array($key);
            else
                $parentMap[$parentId][] = $key;
        }
        
        return $this->recursiveMakeTree($rows, $parentMap, $idName, $parentIdName, 0, 1);
    }
    
    protected function recursiveMakeTree($rows, $parentMap, $idName, $parentIdName, $parent = 0, $level = 1)
    {
        $treeRows = array();
        
        if (!isset($parentMap[$parent]))
            return $treeRows;
            
        foreach ($parentMap[$parent] as $key) {
            $row = $rows[$key];
            
            //$row[$this->_nodeLevelName] = $level;
            if (isset($parentMap[$row[$idName]])) {
                $subTreeRows = $this->recursiveMakeTree($rows, $parentMap, $idName, $parentIdName, $row[$idName], $level+1);
                
                $row[$this->_subNodesCountName] = count($subTreeRows);
                $treeRows[] = $row;
                $treeRows = array_merge($treeRows, $subTreeRows);
            } else {
                $row[$this->_subNodesCountName] = 0;
                $treeRows[] = $row;
            }
        }
        return $treeRows;
    }
    
    
    /**
     * Returns the left and right values for the nested set
     *
     * @param array $records records
     * @param string $primaryKey the primary key
     * @return array returns 2 arrays with the left and right values
     */
    protected function getNestedSet($records, $primaryKey)
    {
        $left = array();
        $right = array();
            
        $level = 1;
        $current = 0;
        foreach ($records as $row) {
            if ($row['level'] == $level) {
                $current++;
            } elseif ($row['level'] < $level) {
                $current += $level - $row['level'] + 1;
            }
            $level = $row['level'];
    
            $left[$row[$primaryKey]] = $current;
            $current++;
            $right[$row[$primaryKey]] = $current + $row['SubNodesCount'] * 2;
        }
            
        return array($left, $right);
    }
}