<?php
set_time_limit ( 600 );
include_once _SRV_WEBROOT.'xtWizard/config.php';

class Update4110To42 extends ExecutableScript {

    /**
     * (non-PHPdoc)
     * @see IExecutableScript::getWizardType()
     */
    public function getWizardType() {
        return Wizard::WIZARD_TYPE_UPDATE;
    }
    
    /**
     * Needed only for update scripts. Needed to determine if the script can be applied
     * to the current shop version
    */
    
    public function getAppliableShopVersion() {
        return '4110';
    }
    
    /**
     * Get pages
     * @return string
     */
    protected function getPagesXml() {
        return file_get_contents(dirname(__FILE__) . DS . 'pages.xml');
    }
    
    /**
     * Index action - testing quesries
     * @param WizardPage $page
     */
    public function displayStartPage(WizardPage $page) {
        $this->InitialSQL($page);
    }
    
    
    
    
    /**
     * Update tables data for each store
     * @param WizardPage $page
     */
    public function displayStoreDataUpdatePage(WizardPage $page) {
        global $store_handler;
        
        $install_prefix = DB_PREFIX.'_';
		$tables_to_update = array(
            array('table'=>'categories_description','field'=>'categories_store_id','permissions'=>'categories_permission','master_key'=>'categories_id'),
            array('table'=>'content_elements','field'=>'content_store_id','permissions'=>'content_permission','master_key'=>'content_id'),
            array('table'=>'manufacturers_info','field'=>'manufacturers_store_id','permissions'=>'manufacturers_permission','master_key'=>'manufacturers_id'),
            array('table'=>'products_description','field'=>'products_store_id','permissions'=>'products_permission','master_key'=>'products_id'),
            array('table'=>'products_to_categories','field'=>'store_id','permissions'=>'products_permission','master_key'=>'products_id'),
            array('table'=>'seo_url','field'=>'store_id','permissions'=>'','master_key'=>'')
        );
        // Get all shop stores
        $allStores = $store_handler->getStores();
        $availableStores = array();
        foreach ($allStores as $storeData) {
            $availableStores[] = $storeData['id'];
        }
        // Get first store
        $firstStore = $availableStores[0];
        // Get current processd store
        $processedStoreId = getParamDefault('store', $firstStore);
        
        // Next store
        $nextStore = false;
        
        $currentStoreKey = array_search($processedStoreId, $availableStores);
        
        if (isset($availableStores[$currentStoreKey + 1])) {
            $nextStore = $availableStores[$currentStoreKey + 1];
        }
        
        foreach ($tables_to_update as $tableData) {
            $this->addControllerCommand(ControllerCommand::factory()
                ->setAction(function(ControllerCommand $command) use ($tableData,$current_store,$install_prefix, $processedStoreId, $firstStore, $nextStore) {
                    try{
                        if ($processedStoreId == $firstStore) {
                            $command->getExecutableScript()->updateStoreData($install_prefix, $tableData['table'], $tableData['field'], $processedStoreId, $command, $nextStore);
                        } else {
                            $limit = getParamDefault('limit', 0);
                            $step = ROWS_PER_ACTION;
                            $res =  $command->getExecutableScript()->CopyStoreDta($tableData['table'], $firstStore, $processedStoreId, $tableData['field'], $command,$install_prefix, $limit, $step, $tableData);
                            if ( !is_int($res)){
                                 
                                $command->setErrorMessage("<span class='msg-error'>" . TEXT_FAILED_STORE_DATA. " [". $processedStoreId ."]: " . $res . "</span><br/>");
                                return false;
                            }
                        }
                        
                        // Return to current page of there is one more store
                        if ($nextStore !== false) {
                            $command->getExecutableScript()->setNextPageUrl(Wizard::getInstance()->buildUrl(array('store' => $nextStore, Wizard::PARAM_PAGE => Wizard::getInstance()->getCurrentPage())));
                        }
                    }catch (Exception $e){
                        $allowed_error_codes = array(1062,1061,1060,1050,1091,1054);                        
                        
                        if (in_array($e->getCode(),$allowed_error_codes)) {
                            $command->setErrorMessage("<span class='msg-skipped'>" .TEXT_FAILED_STORE_DATA. " [". $processedStoreId ."]:  " . $e->getMessage() . "</span><br/>");
                        }else{
                            $command->setErrorMessage("<span class='msg-error'>" .TEXT_FAILED_STORE_DATA. " [". $processedStoreId ."]: " . $e->getMessage() . "</span><br/>");
                            return false;
                        }
                    }
                    return true;
                    })
                    ->setDescription(TEXT_UPDATING_DATA_STORE. ' [ '.$processedStoreId.' ]: table: '.$tableData['table']. "<br/>")
                    ->setAbortOnError(true)
            );
        }
        
        $page->assignTemplateVar('processing', _TEXT_UPDATING_DATA_STORES,true);
        $this->execAsyncAction($page);
        
    }
    
    public function updateStoreData($install_prefix, $table, $field, $current_store, $command) {
        $idb = Wizard::getInstance()->getDatabaseObject();
        $val = "UPDATE ". $install_prefix. $table ." SET ".$field." = ".$current_store." WHERE ".$field."=0";
        $idb->Execute($val);
    }
    
    public function CopyStoreDta($table, $source, $target, $field, $command, $install_prefix, $limit, $step, $tableData){
        $idb = Wizard::getInstance()->getDatabaseObject();
		$add_where = '';
        $add_table = '';
        if ($tableData['permissions']!=''){
            $add_table = " LEFT JOIN ".$install_prefix.$tableData['permissions']." pm ON pm.pid = t.".$tableData['master_key']." and pgroup='shop_".$target."'";
            if(_SYSTEM_GROUP_PERMISSIONS=='blacklist'){
                $add_where = " and pm.permission IS NULL";
            }elseif(_SYSTEM_GROUP_PERMISSIONS=='whitelist'){
                $add_where = " and pm.permission = 1";
            } 
        }
        
       
        $rs = $idb->Execute("SELECT * FROM ".$install_prefix. $table. " t ".$add_table." 
                             WHERE t.".$field ." = ". $source." ".$add_where."
                             LIMIT ".$limit.",".$step);
        
        $a = new stdClass();
        if ($rs->RecordCount()>0){
             while(!$rs->EOF){
                $insert_data = $rs->fields;
                $insert_data[$field] = $target;
                
                try{
                   $a = $idb->AutoExecute($install_prefix.$table, $insert_data);
                }catch (Exception $e){
                    $allowed_error_codes = array(1062,1061,1060,1050,1091,1054); 
                    
                    if (in_array($e->getCode(),$allowed_error_codes)) {
                        $command->setErrorMessage("<span class='msg-skipped'>" . TEXT_FAILED_STORE_DATA. " [". $target ."]:  " . $e->getMessage() . "</span><br/>");
                    }else{
                        $command->setErrorMessage("<span class='msg-error'>" . TEXT_FAILED_STORE_DATA. " [". $target ."]: " . $e->getMessage() . "</span><br/>");
                        return $e->getCode();
                    }
                }
             $rs->MoveNext();
            }
            // One step back. Increase the limit
            $command->getExecutableScript()->setNextOffset($command->getExecutableScript()->getNextOffset()-1);
            $command->addCommandParam('limit', $limit + $step);
            $total = $rs->_numOfRows + $limit;
            $command->setErrorMessage("<span class='msg-success'>" . TEXT_UPDATING_DATA_STORE_EXECUTED.' [ '.$target.' ]: table: '.$table. " (Execute rows: {$total})</span><br/>");
        } else {
            // Reset the limit
            $command->addCommandParam('limit', 0);
            $command->setErrorMessage("<span class='msg-success'>" . TEXT_UPDATING_DATA_STORE_EXECUTED.' [ '.$target.' ]: table: '.$table. ". Finishng processing table: {$tableData['table']}</span><br/>");
        }
        
        
        return  (int)$more;
    }

/**
     * Rebuild categries data
     * @param WizardPage $page
     */
    public function rebuildCategoryTree(WizardPage $page) {
        global $store_handler;
        $filename =  dirname(__FILE__) . DS .'/category_tree.php';
        if (file_exists($filename)){
            include_once $filename;
           
            $this->addControllerCommand(ControllerCommand::factory()
                    ->setAction(function(ControllerCommand $command) use ($table,$field,$current_store,$install_prefix) {
                        $idb = Wizard::getInstance()->getDatabaseObject();
                       
                        try{
                            $tree = new category_tree($idb);
                            $tree->buildNestedSet();
                            $command->setErrorMessage("<span class='msg-success'>" .TEXT_SUCCESS_REBIULD_CATETGORIES. "</span><br/>");
                        }catch (Exception $e){
                            $command->setErrorMessage("<span class='msg-error'>" .TEXT_FAILED_REBIULD_CATETGORIES. ": " . $e->getMessage() . "</span><br/>");
                            return false;
                        }
                        return true;
                    })
                    ->setDescription(TEXT_REBUILDING_CATEGORIES. "<br/>")
                    ->setAbortOnError(true)
                );
        }
        $page->assignTemplateVar('processing',TEXT_REBUILDING_CATEGORIES,true);
        $this->execAsyncAction($page);
        
    }
    /**
     * Complete action
     * @param WizardPage $page
     */
    public function displayFinishtPage(WizardPage $page) {
        
        $idb = Wizard::getInstance()->getDatabaseObject();
        $rs = $idb->Execute("UPDATE ". DB_PREFIX.'_config'. " SET config_value  = '4.2.00' WHERE config_key = '_SYSTEM_VERSION'");
            
        $url = Wizard::getInstance()->buildUrl(array(
                Wizard::PARAM_SCRIPT => 'StartPageScript',
                Wizard::PARAM_PAGE => 'update',
        ));
        // Redirect to update page
        Wizard::getInstance()->redirect($url);
    }
    
    protected function getFirstStoreID($idb,$prefix){
        $idb->Execute("SELECT * FROM ". $prefix ."_stores ORDER BY shop_id LIMIT 0,1");
        $idb->fileds['shop_id'];
    }
    
    protected function _getFileContent($filename) {
        $handle = fopen($filename, 'rb');
        $content = fread($handle, filesize($filename));
        fclose($handle);
        return $content;
    }
    
    public function _installSQL( $idb, $filename, $prefix='', $language_code='',$store_id='') {
        $query = '';
        // open sql
        $filename = dirname(__FILE__) . DS .$filename;
        $sql_content = $this->_getFileContent($filename);
        // replace windows linefeeds
        $sql_content = str_replace("\r\n","\n",$sql_content);
        $queries = array();
        $chars = strlen($sql_content);
        for ($i = 0; $i < $chars; $i++) {
            // check if char is ; and next \n
            if ($sql_content[$i]==';' && $sql_content[$i+1]=="\n") {
                $query .= $sql_content[$i];
                $queries[] = $query;
                $query = '';
                $i++;
            } else {
                if ($sql_content[$i]=='-' && $sql_content[$i+1]=='-') {
                    // skip to next \n
                    for ($ii=$i;$ii<$chars;$ii++) {
    
                        if ($sql_content[$ii]=="\n") {
                            break;
                        } else {
                            $i++;
                        }
    
                    }
                } else {
                    if (!isset($query)) $query='';
                    $query.=$sql_content[$i];
                }
            }
        }
        
        foreach ($queries as $key => $val) {
            $query = trim($val);
            $query = str_replace('##_',$prefix,$query);
            if ($store_id!='') $query = str_replace('**_REPLACE_STORE_ID_**',$store_id,$query);
            
            // ok, now search vor OTHER INSERT INTO statements, and break them up
            if (substr($query,0,6)=='INSERT') {
                $check_qry = substr($query,7);
                
                if (strstr($check_qry,'INSERT')) {
                    $qry = explode('INSERT',$check_qry);
                    foreach ($qry as $k => $v) {
                        $queries[]='INSERT '.$v;
                    }
                    unset ($queries[$key]);
                } else {
                    $queries[$key]=$query;
                }
            } else {
                $queries[$key]=$query;
            }
        }
        return $queries;
        
    }

    function InitialSQL(WizardPage $page){
        
        //$script = new Update4110To42();
        $install_prefix = DB_PREFIX.'_';
        $res = $this->_installSQL(Wizard::getInstance()->getDatabaseObject(), 'update.sql', $install_prefix,'');
        
        foreach ($res as $key => $val) {
            $this->addControllerCommand(ControllerCommand::factory()
                ->setAction(function(ControllerCommand $command) use ($val) {
                    $idb = Wizard::getInstance()->getDatabaseObject();
                    try{
                        $idb->Execute($val);
                    }catch (Exception $e){
                        /*'1060 - Duplicate column name','1062 - Duplicate entry', '1050- table alredy exists','1091 - primary key can not be dropped'*/
                        $allowed_error_codes = array(1062,1061,1060,1050,1091,1054); 
                        if (in_array($e->getCode(),$allowed_error_codes)) {
                            $command->setErrorMessage("<span class='msg-skipped'>".TEXT_QUERY_SKIPPED."  " . $e->getMessage() . "</span><br/>");
                        }else{
                            $command->setErrorMessage("<span class='msg-error'>".TEXT_QUERY_FAILED." " . $e->getMessage() . "</span><br/>");
                            return false;
                        }
                    }
                        
                    return true;
                })
                ->setDescription(TEXT_EXECUTING_QUERY.$val . "<br/>")
                ->setAbortOnError(true)
            );
            
        }
		
		$this->addControllerCommand(ControllerCommand::factory()
                ->setAction(function(ControllerCommand $command) use ($install_prefix) {
                    $idb = Wizard::getInstance()->getDatabaseObject();
                    $res = $command->getExecutableScript()->_installSQL(Wizard::getInstance()->getDatabaseObject(), 'update_tax_rates.sql', $install_prefix);
                    foreach ($res as $key => $val) {
                        try{
                            $idb->Execute($val);
                        }catch (Exception $e){
                            /*'1060 - Duplicate column name','1062 - Duplicate entry', '1050- table alredy exists','1091 - primary key can not be dropped'*/
                            $allowed_error_codes = array(1062,1061,1060,1050,1091,1054); 
                            if (in_array($e->getCode(),$allowed_error_codes)) {
                                $command->setErrorMessage("<span class='msg-skipped'>".TEXT_QUERY_SKIPPED."  " . $e->getMessage() . "</span><br/>");
                            }else{
                                $command->setErrorMessage("<span class='msg-error'>".TEXT_QUERY_FAILED." " . $e->getMessage() . "</span><br/>");
                                return false;
                            }
                        }
                        }
                    return true;
                })
                ->setDescription(TEXT_UPDATING_TAX_RATES . "<br/>")
                ->setAbortOnError(true)
            );
			
        global $store_handler,$language;
    
        $install_prefix = DB_PREFIX.'_';
        foreach ($store_handler->getStores() as $store){
            $res = $this->_installSQL(Wizard::getInstance()->getDatabaseObject(), 'update_each_store.sql', $install_prefix,'',$store['id']);    
            foreach ($res as $key => $val) {
                $this->addControllerCommand(ControllerCommand::factory()
                    ->setAction(function(ControllerCommand $command) use ($val) {
                        $idb = Wizard::getInstance()->getDatabaseObject();
                        try{
                            $idb->Execute($val);
                        }catch (Exception $e){
                            /*'1060 - Duplicate column name','1062 - Duplicate entry', '1050- table alredy exists','1091 - primary key can not be dropped'*/
                            $allowed_error_codes = array(1062,1061,1060,1050,1091,1054); 
                            if (in_array($e->getCode(),$allowed_error_codes)) {
                                $command->setErrorMessage("<span class='msg-skipped'>".TEXT_QUERY_SKIPPED."  " . $e->getMessage() . "</span><br/>");
                            }else{
                                $command->setErrorMessage("<span class='msg-error'>".TEXT_QUERY_FAILED." " . $e->getMessage() . "</span><br/>");
                                return false;
                            }
                        }
                            
                        return true;
                    })
                    ->setDescription(TEXT_EXECUTING_QUERY.$val . "<br/>")
                    ->setAbortOnError(true)
                );
            }
        }
		
		$lng = $this->_getLanguageList(Wizard::getInstance()->getDatabaseObject(), '', '', DB_PREFIX.'_');
		foreach ($store_handler->getStores() as $store){
            foreach ($lng as $key => $val){
                $this->addControllerCommand(ControllerCommand::factory()
                    ->setAction(function(ControllerCommand $command) use ($val,$store,$install_prefix) {
                        $idb = Wizard::getInstance()->getDatabaseObject();
                        try{
                            $sql = "INSERT INTO ".$install_prefix."language_content (translated,language_code,language_key,language_value,class)
                                    VALUES('1','".$val["code"]."','TEXT_CAT_STORE".$store['id']."',
                                    (SELECT shop_title FROM ".$install_prefix."stores WHERE shop_id='".$store['id']."'),'admin');";
                            $idb->Execute($sql);
                        }catch (Exception $e){
                            /*'1060 - Duplicate column name','1062 - Duplicate entry', '1050- table alredy exists','1091 - primary key can not be dropped'*/
                            $allowed_error_codes = array(1062,1061,1060,1050,1091,1054); 
                            if (in_array($e->getCode(),$allowed_error_codes)) {
                                $command->setErrorMessage("<span class='msg-skipped'>".TEXT_QUERY_SKIPPED."  " . $e->getMessage() . "</span><br/>");
                            }else{
                                $command->setErrorMessage("<span class='msg-error'>".TEXT_QUERY_FAILED." " . $e->getMessage() . "</span><br/>");
                                return false;
                            }
                        }
                            
                        return true;
                    })
                    ->setDescription(TEXT_UPDATING_STORE_TEXT_VALUES . "<br/>")
                    ->setAbortOnError(false)
                );
            }
        }
		
        $countries = array(
            array("code"=>"AF","name"=>"Afghanistan","d_code"=>"0093"),
            array("code"=>"AL","name"=>"Albania","d_code"=>"00355"),
            array("code"=>"DZ","name"=>"Algeria","d_code"=>"00213"),
            array("code"=>"AS","name"=>"American Samoa","d_code"=>"001684"),
            array("code"=>"AD","name"=>"Andorra","d_code"=>"00376"),
            array("code"=>"AO","name"=>"Angola","d_code"=>"00244"),
            array("code"=>"AI","name"=>"Anguilla","d_code"=>"001264"),
            array("code"=>"AG","name"=>"Antigua","d_code"=>"001268"),
            array("code"=>"AR","name"=>"Argentina","d_code"=>"0054"),
            array("code"=>"AM","name"=>"Armenia","d_code"=>"00374"),
            array("code"=>"AW","name"=>"Aruba","d_code"=>"00297"),
            array("code"=>"AU","name"=>"Australia","d_code"=>"0061"),
            array("code"=>"AT","name"=>"Austria","d_code"=>"0043"),
            array("code"=>"AZ","name"=>"Azerbaijan","d_code"=>"00994"),
            array("code"=>"BH","name"=>"Bahrain","d_code"=>"00973"),
            array("code"=>"BD","name"=>"Bangladesh","d_code"=>"00880"),
            array("code"=>"BB","name"=>"Barbados","d_code"=>"001246"),
            array("code"=>"BY","name"=>"Belarus","d_code"=>"00375"),
            array("code"=>"BE","name"=>"Belgium","d_code"=>"0032"),
            array("code"=>"BZ","name"=>"Belize","d_code"=>"00501"),
            array("code"=>"BJ","name"=>"Benin","d_code"=>"00229"),
            array("code"=>"BM","name"=>"Bermuda","d_code"=>"001441"),
            array("code"=>"BT","name"=>"Bhutan","d_code"=>"00975"),
            array("code"=>"BO","name"=>"Bolivia","d_code"=>"00591"),
            array("code"=>"BA","name"=>"Bosnia and Herzegovina","d_code"=>"00387"),
            array("code"=>"BW","name"=>"Botswana","d_code"=>"00267"),
            array("code"=>"BR","name"=>"Brazil","d_code"=>"0055"),
            array("code"=>"IO","name"=>"British Indian Ocean Territory","d_code"=>"00246"),
            array("code"=>"VG","name"=>"British Virgin Islands","d_code"=>"001284"),
            array("code"=>"BN","name"=>"Brunei","d_code"=>"00673"),
            array("code"=>"BG","name"=>"Bulgaria","d_code"=>"00359"),
            array("code"=>"BF","name"=>"Burkina Faso","d_code"=>"00226"),
            array("code"=>"MM","name"=>"Burma Myanmar" ,"d_code"=>"0095"),
            array("code"=>"BI","name"=>"Burundi","d_code"=>"00257"),
            array("code"=>"KH","name"=>"Cambodia","d_code"=>"00855"),
            array("code"=>"CM","name"=>"Cameroon","d_code"=>"00237"),
            array("code"=>"CA","name"=>"Canada","d_code"=>"001"),
            array("code"=>"CV","name"=>"Cape Verde","d_code"=>"00238"),
            array("code"=>"KY","name"=>"Cayman Islands","d_code"=>"001345"),
            array("code"=>"CF","name"=>"Central African Republic","d_code"=>"00236"),
            array("code"=>"TD","name"=>"Chad","d_code"=>"00235"),
            array("code"=>"CL","name"=>"Chile","d_code"=>"0056"),
            array("code"=>"CN","name"=>"China","d_code"=>"0086"),
            array("code"=>"CO","name"=>"Colombia","d_code"=>"0057"),
            array("code"=>"KM","name"=>"Comoros","d_code"=>"00269"),
            array("code"=>"CK","name"=>"Cook Islands","d_code"=>"00682"),
            array("code"=>"CR","name"=>"Costa Rica","d_code"=>"00506"),
            array("code"=>"CI","name"=>"Côte d'Ivoire" ,"d_code"=>"00225"),
            array("code"=>"HR","name"=>"Croatia","d_code"=>"00385"),
            array("code"=>"CU","name"=>"Cuba","d_code"=>"0053"),
            array("code"=>"CY","name"=>"Cyprus","d_code"=>"00357"),
            array("code"=>"CZ","name"=>"Czech Republic","d_code"=>"00420"),
            array("code"=>"CD","name"=>"Democratic Republic of Congo","d_code"=>"00243"),
            array("code"=>"DK","name"=>"Denmark","d_code"=>"0045"),
            array("code"=>"DJ","name"=>"Djibouti","d_code"=>"00253"),
            array("code"=>"DM","name"=>"Dominica","d_code"=>"001767"),
            array("code"=>"DO","name"=>"Dominican Republic","d_code"=>"001809,001829,001849"),
            array("code"=>"EC","name"=>"Ecuador","d_code"=>"00593"),
            array("code"=>"EG","name"=>"Egypt","d_code"=>"0020"),
            array("code"=>"SV","name"=>"El Salvador","d_code"=>"00503"),
            array("code"=>"GQ","name"=>"Equatorial Guinea","d_code"=>"00240"),
            array("code"=>"ER","name"=>"Eritrea","d_code"=>"00291"),
            array("code"=>"EE","name"=>"Estonia","d_code"=>"00372"),
            array("code"=>"ET","name"=>"Ethiopia","d_code"=>"00251"),
            array("code"=>"FK","name"=>"Falkland Islands","d_code"=>"00500"),
            array("code"=>"FO","name"=>"Faroe Islands","d_code"=>"00298"),
            array("code"=>"FM","name"=>"Federated States of Micronesia","d_code"=>"00691"),
            array("code"=>"FJ","name"=>"Fiji","d_code"=>"00679"),
            array("code"=>"FI","name"=>"Finland","d_code"=>"00358"),
            array("code"=>"FR","name"=>"France","d_code"=>"0033"),
            array("code"=>"GF","name"=>"French Guiana","d_code"=>"00594"),
            array("code"=>"PF","name"=>"French Polynesia","d_code"=>"00689"),
            array("code"=>"GA","name"=>"Gabon","d_code"=>"00241"),
            array("code"=>"GE","name"=>"Georgia","d_code"=>"00995"),
            array("code"=>"DE","name"=>"Germany","d_code"=>"0049"),
            array("code"=>"GH","name"=>"Ghana","d_code"=>"00233"),
            array("code"=>"GI","name"=>"Gibraltar","d_code"=>"00350"),
            array("code"=>"GR","name"=>"Greece","d_code"=>"0030"),
            array("code"=>"GL","name"=>"Greenland","d_code"=>"00299"),
            array("code"=>"GD","name"=>"Grenada","d_code"=>"001473"),
            array("code"=>"GP","name"=>"Guadeloupe","d_code"=>"00590"),
            array("code"=>"GU","name"=>"Guam","d_code"=>"001671"),
            array("code"=>"GT","name"=>"Guatemala","d_code"=>"00502"),
            array("code"=>"GN","name"=>"Guinea","d_code"=>"00224"),
            array("code"=>"GW","name"=>"Guinea-Bissau","d_code"=>"00245"),
            array("code"=>"GY","name"=>"Guyana","d_code"=>"00592"),
            array("code"=>"HT","name"=>"Haiti","d_code"=>"00509"),
            array("code"=>"HN","name"=>"Honduras","d_code"=>"00504"),
            array("code"=>"HK","name"=>"Hong Kong","d_code"=>"00852"),
            array("code"=>"HU","name"=>"Hungary","d_code"=>"0036"),
            array("code"=>"IS","name"=>"Iceland","d_code"=>"00354"),
            array("code"=>"IN","name"=>"India","d_code"=>"0091"),
            array("code"=>"ID","name"=>"Indonesia","d_code"=>"0062"),
            array("code"=>"IR","name"=>"Iran","d_code"=>"0098"),
            array("code"=>"IQ","name"=>"Iraq","d_code"=>"00964"),
            array("code"=>"IE","name"=>"Ireland","d_code"=>"00353"),
            array("code"=>"IL","name"=>"Israel","d_code"=>"00972"),
            array("code"=>"IT","name"=>"Italy","d_code"=>"0039"),
            array("code"=>"JM","name"=>"Jamaica","d_code"=>"001876"),
            array("code"=>"JP","name"=>"Japan","d_code"=>"0081"),
            array("code"=>"JO","name"=>"Jordan","d_code"=>"00962"),
            array("code"=>"KZ","name"=>"Kazakhstan","d_code"=>"007"),
            array("code"=>"KE","name"=>"Kenya","d_code"=>"00254"),
            array("code"=>"KI","name"=>"Kiribati","d_code"=>"00686"),
            array("code"=>"XK","name"=>"Kosovo","d_code"=>"00381"),
            array("code"=>"KW","name"=>"Kuwait","d_code"=>"00965"),
            array("code"=>"KG","name"=>"Kyrgyzstan","d_code"=>"00996"),
            array("code"=>"LA","name"=>"Laos","d_code"=>"00856"),
            array("code"=>"LV","name"=>"Latvia","d_code"=>"00371"),
            array("code"=>"LB","name"=>"Lebanon","d_code"=>"00961"),
            array("code"=>"LS","name"=>"Lesotho","d_code"=>"00266"),
            array("code"=>"LR","name"=>"Liberia","d_code"=>"00231"),
            array("code"=>"LY","name"=>"Libya","d_code"=>"00218"),
            array("code"=>"LI","name"=>"Liechtenstein","d_code"=>"00423"),
            array("code"=>"LT","name"=>"Lithuania","d_code"=>"00370"),
            array("code"=>"LU","name"=>"Luxembourg","d_code"=>"00352"),
            array("code"=>"MO","name"=>"Macau","d_code"=>"00853"),
            array("code"=>"MK","name"=>"Macedonia","d_code"=>"00389"),
            array("code"=>"MG","name"=>"Madagascar","d_code"=>"00261"),
            array("code"=>"MW","name"=>"Malawi","d_code"=>"00265"),
            array("code"=>"MY","name"=>"Malaysia","d_code"=>"0060"),
            array("code"=>"MV","name"=>"Maldives","d_code"=>"00960"),
            array("code"=>"ML","name"=>"Mali","d_code"=>"00223"),
            array("code"=>"MT","name"=>"Malta","d_code"=>"00356"),
            array("code"=>"MH","name"=>"Marshall Islands","d_code"=>"00692"),
            array("code"=>"MQ","name"=>"Martinique","d_code"=>"00596"),
            array("code"=>"MR","name"=>"Mauritania","d_code"=>"00222"),
            array("code"=>"MU","name"=>"Mauritius","d_code"=>"00230"),
            array("code"=>"YT","name"=>"Mayotte","d_code"=>"00262"),
            array("code"=>"MX","name"=>"Mexico","d_code"=>"0052"),
            array("code"=>"MD","name"=>"Moldova","d_code"=>"00373"),
            array("code"=>"MC","name"=>"Monaco","d_code"=>"00377"),
            array("code"=>"MN","name"=>"Mongolia","d_code"=>"00976"),
            array("code"=>"ME","name"=>"Montenegro","d_code"=>"00382"),
            array("code"=>"MS","name"=>"Montserrat","d_code"=>"001664"),
            array("code"=>"MA","name"=>"Morocco","d_code"=>"00212"),
            array("code"=>"MZ","name"=>"Mozambique","d_code"=>"00258"),
            array("code"=>"NA","name"=>"Namibia","d_code"=>"00264"),
            array("code"=>"NR","name"=>"Nauru","d_code"=>"00674"),
            array("code"=>"NP","name"=>"Nepal","d_code"=>"00977"),
            array("code"=>"NL","name"=>"Netherlands","d_code"=>"0031"),
            array("code"=>"AN","name"=>"Netherlands Antilles","d_code"=>"00599"),
            array("code"=>"NC","name"=>"New Caledonia","d_code"=>"00687"),
            array("code"=>"NZ","name"=>"New Zealand","d_code"=>"0064"),
            array("code"=>"NI","name"=>"Nicaragua","d_code"=>"00505"),
            array("code"=>"NE","name"=>"Niger","d_code"=>"00227"),
            array("code"=>"NG","name"=>"Nigeria","d_code"=>"00234"),
            array("code"=>"NU","name"=>"Niue","d_code"=>"00683"),
            array("code"=>"NF","name"=>"Norfolk Island","d_code"=>"00672"),
            array("code"=>"KP","name"=>"North Korea","d_code"=>"00850"),
            array("code"=>"MP","name"=>"Northern Mariana Islands","d_code"=>"001670"),
            array("code"=>"NO","name"=>"Norway","d_code"=>"0047"),
            array("code"=>"OM","name"=>"Oman","d_code"=>"00968"),
            array("code"=>"PK","name"=>"Pakistan","d_code"=>"0092"),
            array("code"=>"PW","name"=>"Palau","d_code"=>"00680"),
            array("code"=>"PS","name"=>"Palestine","d_code"=>"00970"),
            array("code"=>"PA","name"=>"Panama","d_code"=>"00507"),
            array("code"=>"PG","name"=>"Papua New Guinea","d_code"=>"00675"),
            array("code"=>"PY","name"=>"Paraguay","d_code"=>"00595"),
            array("code"=>"PE","name"=>"Peru","d_code"=>"0051"),
            array("code"=>"PH","name"=>"Philippines","d_code"=>"0063"),
            array("code"=>"PL","name"=>"Poland","d_code"=>"0048"),
            array("code"=>"PT","name"=>"Portugal","d_code"=>"00351"),
            array("code"=>"PR","name"=>"Puerto Rico","d_code"=>"001787,001939"),
            array("code"=>"QA","name"=>"Qatar","d_code"=>"00974"),
            array("code"=>"CG","name"=>"Republic of the Congo","d_code"=>"00242"),
            array("code"=>"RE","name"=>"Réunion" ,"d_code"=>"00262"),
            array("code"=>"RO","name"=>"Romania","d_code"=>"0040"),
            array("code"=>"RU","name"=>"Russia","d_code"=>"007"),
            array("code"=>"RW","name"=>"Rwanda","d_code"=>"00250"),
            array("code"=>"BL","name"=>"Saint Barthélemy" ,"d_code"=>"00590"),
            array("code"=>"SH","name"=>"Saint Helena","d_code"=>"00290"),
            array("code"=>"KN","name"=>"Saint Kitts and Nevis","d_code"=>"001869"),
            array("code"=>"MF","name"=>"Saint Martin","d_code"=>"00590"),
            array("code"=>"PM","name"=>"Saint Pierre and Miquelon","d_code"=>"00508"),
            array("code"=>"VC","name"=>"Saint Vincent and the Grenadines","d_code"=>"001784"),
            array("code"=>"WS","name"=>"Samoa","d_code"=>"00685"),
            array("code"=>"SM","name"=>"San Marino","d_code"=>"00378"),
            array("code"=>"ST","name"=>"São Tomé and Príncipe" ,"d_code"=>"00239"),
            array("code"=>"SA","name"=>"Saudi Arabia","d_code"=>"00966"),
            array("code"=>"SN","name"=>"Senegal","d_code"=>"00221"),
            array("code"=>"RS","name"=>"Serbia","d_code"=>"00381"),
            array("code"=>"SC","name"=>"Seychelles","d_code"=>"00248"),
            array("code"=>"SL","name"=>"Sierra Leone","d_code"=>"00232"),
            array("code"=>"SG","name"=>"Singapore","d_code"=>"0065"),
            array("code"=>"SK","name"=>"Slovakia","d_code"=>"00421"),
            array("code"=>"SI","name"=>"Slovenia","d_code"=>"00386"),
            array("code"=>"SB","name"=>"Solomon Islands","d_code"=>"00677"),
            array("code"=>"SO","name"=>"Somalia","d_code"=>"00252"),
            array("code"=>"ZA","name"=>"South Africa","d_code"=>"0027"),
            array("code"=>"KR","name"=>"South Korea","d_code"=>"0082"),
            array("code"=>"ES","name"=>"Spain","d_code"=>"0034"),
            array("code"=>"LK","name"=>"Sri Lanka","d_code"=>"0094"),
            array("code"=>"LC","name"=>"St. Lucia","d_code"=>"001758"),
            array("code"=>"SD","name"=>"Sudan","d_code"=>"00249"),
            array("code"=>"SR","name"=>"Suriname","d_code"=>"00597"),
            array("code"=>"SZ","name"=>"Swaziland","d_code"=>"00268"),
            array("code"=>"SE","name"=>"Sweden","d_code"=>"0046"),
            array("code"=>"CH","name"=>"Switzerland","d_code"=>"0041"),
            array("code"=>"SY","name"=>"Syria","d_code"=>"00963"),
            array("code"=>"TW","name"=>"Taiwan","d_code"=>"00886"),
            array("code"=>"TJ","name"=>"Tajikistan","d_code"=>"00992"),
            array("code"=>"TZ","name"=>"Tanzania","d_code"=>"00255"),
            array("code"=>"TH","name"=>"Thailand","d_code"=>"0066"),
            array("code"=>"BS","name"=>"The Bahamas","d_code"=>"001242"),
            array("code"=>"GM","name"=>"The Gambia","d_code"=>"00220"),
            array("code"=>"TL","name"=>"Timor-Leste","d_code"=>"00670"),
            array("code"=>"TG","name"=>"Togo","d_code"=>"00228"),
            array("code"=>"TK","name"=>"Tokelau","d_code"=>"00690"),
            array("code"=>"TO","name"=>"Tonga","d_code"=>"00676"),
            array("code"=>"TT","name"=>"Trinidad and Tobago","d_code"=>"001868"),
            array("code"=>"TN","name"=>"Tunisia","d_code"=>"00216"),
            array("code"=>"TR","name"=>"Turkey","d_code"=>"0090"),
            array("code"=>"TM","name"=>"Turkmenistan","d_code"=>"00993"),
            array("code"=>"TC","name"=>"Turks and Caicos Islands","d_code"=>"001649"),
            array("code"=>"TV","name"=>"Tuvalu","d_code"=>"00688"),
            array("code"=>"UG","name"=>"Uganda","d_code"=>"00256"),
            array("code"=>"UA","name"=>"Ukraine","d_code"=>"00380"),
            array("code"=>"AE","name"=>"United Arab Emirates","d_code"=>"00971"),
            array("code"=>"GB","name"=>"United Kingdom","d_code"=>"0044"),
            array("code"=>"US","name"=>"United States","d_code"=>"001"),
            array("code"=>"UY","name"=>"Uruguay","d_code"=>"00598"),
            array("code"=>"VI","name"=>"US Virgin Islands","d_code"=>"001340"),
            array("code"=>"UZ","name"=>"Uzbekistan","d_code"=>"00998"),
            array("code"=>"VU","name"=>"Vanuatu","d_code"=>"00678"),
            array("code"=>"VA","name"=>"Vatican City","d_code"=>"0039"),
            array("code"=>"VE","name"=>"Venezuela","d_code"=>"0058"),
            array("code"=>"VN","name"=>"Vietnam","d_code"=>"0084"),
            array("code"=>"WF","name"=>"Wallis and Futuna","d_code"=>"00681"),
            array("code"=>"YE","name"=>"Yemen","d_code"=>"00967"),
            array("code"=>"ZM","name"=>"Zambia","d_code"=>"00260"),
            array("code"=>"ZW","name"=>"Zimbabwe","d_code"=>"00263"),
            array("code"=>"CC","name"=>"Cocos (Keeling) Islands","d_code"=>"006189162"),
            array("code"=>"CX","name"=>"Christmas Island","d_code"=>"006189164"),
            array("code"=>"EH","name"=>"Western Sahara","d_code"=>"002125288,002125289"),
            array("code"=>"GS","name"=>"South Georgia and the South Sandwich Islands","d_code"=>"00500"),
            array("code"=>"PN","name"=>"Pitcairn","d_code"=>"0064"),
            array("code"=>"TP","name"=>"East Timor","d_code"=>"00670"),
            array("code"=>"ZR","name"=>"Zaire","d_code"=>"00243"));
            
           
            $install_prefix = DB_PREFIX.'_';
            $this->addControllerCommand(ControllerCommand::factory()
                ->setAction(function(ControllerCommand $command) use ($install_prefix,$countries) {
                    $idb = Wizard::getInstance()->getDatabaseObject();
                     for ($i=0;$i<count($countries);$i++){
                        try{
                            $query = "UPDATE ".$install_prefix."countries SET phone_prefix='".$countries[$i]['d_code']."' 
                                WHERE countries_iso_code_2 = '".$countries[$i]['code']."'";
                               
                            $idb->Execute($query);
                        }catch (Exception $e){
                            /*'1060 - Duplicate column name','1062 - Duplicate entry', '1050- table alredy exists','1091 - primary key can not be dropped'*/
                            $allowed_error_codes = array(1062,1061,1060,1050,1091,1054); 
                            if (in_array($e->getCode(),$allowed_error_codes)) {
                                $command->setErrorMessage("<span class='msg-skipped'>".TEXT_QUERY_SKIPPED."  " . $e->getMessage() . "</span><br/>");
                            }else{
                                $command->setErrorMessage("<span class='msg-error'>".TEXT_QUERY_FAILED." " . $e->getMessage() . "</span><br/>");
                                return false;
                            }
                        }
                    } 
                    return true;
                })
                ->setDescription(TEXT_UPDATING_COUNTRY_PHONE_PREFIX . "<br/>")
                ->setAbortOnError(true)
            );
            
    $page->assignTemplateVar('processing',TEXT_EXECUTING_DB_UPDATE_SCRIPT,true);
    $this->execAsyncAction($page,$params);
    }
    
	 public function _getLanguageList( $idb, $list_type = '',$index='', $prefix){
    
        if ($list_type!='all')
        $qry_where = " WHERE l.language_status = '1'";
    
        $record = $idb->Execute("SELECT * FROM " . $prefix . "languages l ".$qry_where." order by sort_order");
        while(!$record->EOF){
            $record->fields['id'] = $record->fields['code'];
            $record->fields['text'] = $record->fields['name'];
            $record->fields['icon'] = $record->fields['image'];
            $record->fields['edit'] = $record->fields['allow_edit'];
    
            if ($index=='') $data[] = $record->fields;
            if ($index=='code') $data[$record->fields['code']] = $record->fields;
            $record->MoveNext();
        }$record->Close();
    
        return $data;
    }
}

Wizard::getInstance()->registerScript(new Update4110To42());

    