/*
 #########################################################################
#                       xt:Commerce  4.1 Shopsoftware
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# Copyright 2007-2011 xt:Commerce International Ltd. All Rights Reserved.
# This file may not be redistributed in whole or significant part.
# Content of this file is Protected By International Copyright Laws.
#
# ~~~~~~ xt:Commerce  4.1 Shopsoftware IS NOT FREE SOFTWARE ~~~~~~~
#
# http://www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# @version $Id$
# @copyright xt:Commerce International Ltd., www.xt-commerce.com
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# xt:Commerce International Ltd., Kafkasou 9, Aglantzia, CY-2112 Nicosia
#
# office@xt-commerce.com
#
#########################################################################
*/
(function(window, $){
	
	var AsyncLoader = function(url) {
		// Base propertios
		this.AsyncUrl = url;
		this.Progress = 0;
		this.HasNext = true;
		this.Offset = 0;
		this.Interval = null;
		this.Loading = false;
		this.ExtraParams = {};
		
		// Dom elements
		this.ProgressBarId = "#ProgressBar";
		this.PanelLogClass = ".panel-log";
		this.CurrentOperationId = "#CurrentOperation";
		this.ButtonNextPage = ".btn-next-page";
		this.LoadingIcon = ".loading-icon";
		
		var self = this;
		
		this.setProgress = function(value) {
			$(self.ProgressBarId).css('width', value + "%");
			self.Progress = value;
		}
		
		this.setCurrentMessage = function(text) {
			$(self.CurrentOperationId).html(text);
		}
		
		this.addLog = function(html) {
			$(self.PanelLogClass).append(html).animate({ scrollTop: $('.panel-log')[0].scrollHeight}, 1000);
		}
		
		this.load = function() {
			self.Loading = true;
			params = {ajaxLoad : 1, offset : self.Offset, Progress : self.Progress};
			
			for (var i in self.ExtraParams) {
				if (self.ExtraParams.hasOwnProperty(i)) {
					params[i] = self.ExtraParams[i]; 
				}
			}
			$.ajax({
				type: "GET",
				url: self.AsyncUrl,
				data: params,
				dataType:'json',
				success: function(data) {
					self.Loading = false;
					self.Offset = data.Offset;
					self.HasNext = data.HasNext;
					self.addLog(data.LogMessages);
					self.setProgress(data.Progress);
					self.setCurrentMessage(data.CurrentMessage);
					self.ExtraParams = data.ExtraParams;
					$(self.ButtonNextPage).attr('href', data.NextUrl);
					
					if (!self.HasNext) {
						window.clearInterval(self.Interval);
						$(self.LoadingIcon).hide();
						$(self.ButtonNextPage).show();
					}
				}
			});
		}
		
		this.setProgress(this.Progress);
		this.Interval = window.setInterval(function(){
			if (self.Loading) {
				return;
			}
			self.load();
		}, 2000);
		self.load();
	}
	
	window.createAsyncLoader = function(url) {
		return new AsyncLoader(url);
	}
})(window, jQuery);