<?php
/*
 * pear channel-discover pear.php-tools.net
 * pear install pat/vfsStream-alpha
 */
//~ require_once 'vfsStream/vfsStream.php';
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc.inc');
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc_wrappers.inc');
require_once('../Klarna.php');

/**
 * TestCase for the new 4.1 changes.
 *
 * Test class for Klarna.
 * Generated by PHPUnit on 2011-02-23 at 14:45:33.
 */
class KlarnaMockTest extends PHPUnit_Framework_TestCase {

    /**
     * @var Klarna
     */
    protected $api;

    /**
     * @var array
     */
    protected $options;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        date_default_timezone_set('Europe/Stockholm');

        $this->options = array();
        $this->options['testing'] = array();

        //Add addresses for testing
        $this->options['testing']['addresses'] = array();
        $this->options['testing']['addresses'][] = new KlarnaAddr(
            'test@email.com',
            '',
            '0765260000',
            'Karl',
            'Lidin',
            '',
            'Junibacksg 42',
            '23634',
            'Hollviken',
            KlarnaCountry::SE,
            '',
            ''
        );
        //new KlarnaAddr($email, $telno, $cellno, $fname, $lname, $careof, $street, $zip, $city, $country, $houseNo, $houseExt)
        $this->options['testing']['addresses'][] = new KlarnaAddr(
            'test@email.com',
            '',
            '0765260000',
            'Karl',
            'Lidin',
            '',
            'Junibacksgatan 42',
            '23634',
            'Hollviken',
            KlarnaCountry::SE,
            '',
            ''
        );

        //Add invoice and reservation numbers.
        $this->options['testing']['invno'] = "41102100474908976";
        $this->options['testing']['rno']   = "178610";

        //Add pclasses
        $this->options['testing']['pclasses'] = array();
        //This pclass is not valid, since expire was yesterday.
        $this->options['testing']['pclasses'][] = array(
            //id
            390,
            //desc
            "Konto",
            //months
            24,
            //start fee
            0,
            //invoice fee
            2900,
            //interest rate
            2000,
            //min amount
            100,
            //country
            KlarnaCountry::SE,
            //type
            KlarnaPClass::ACCOUNT,
            //expire (unix timestamp always in GMT)
            date('Y-m-d', strtotime("-1 day" , time()))
        );
        //This pclass is valid, expire is tomorrow.
        $this->options['testing']['pclasses'][] = array(
            //id
            362,
            //desc
            "24 mn",
            //months
            24,
            //start fee
            29500,
            //invoice fee
            2900,
            //interest rate
            1000,
            //min amount
            100000,
            //country
            KlarnaCountry::SE,
            //type
            KlarnaPClass::CAMPAIGN,
            //expire (unix timestamp always in GMT)
            date('Y-m-d', strtotime("+1 day" , time()))
        );

        //Mock the Klarna xmlrpc_call so we can test it without making real calls to KO.
        $this->api = $this->getMock('Klarna', array('xmlrpc_call', 'sendStat'));

        //sendStat should never be called.
        $this->api->expects($this->never())->method('sendStat');

        $this->options['addr'] = new KlarnaAddr(
            'test@email.com',
            '',
            '0765260000',
            'Karl',
            'Lidin',
            '',
            'Junibacksg 42',
            '23634',
            'Hollviken',
            KlarnaCountry::SE,
            '',
            ''
        );

        $this->options['artarr'] = array(
            'qty' => 1,
            'artno' => "12345",
            'arttitle' => "boots",
            'price' => 195.50,
            'vat' => 25.0,
            'discount' => 0,
            'flags' => KlarnaFlags::INC_VAT
        );

        $this->options['invno'] = "41102100474908976";

        $this->options['rno'] = "178610";

        $this->options['pno'] = "430415-8399";

        $_SERVER['REMOTE_ADDR'] = "224.1.1.1";

        $this->api->config($eid = 1004, $secret = "123124", $country = KlarnaCountry::SE, $language = KlarnaLanguage::SV, $currency = KlarnaCurrency::SEK,
                $mode = Klarna::BETA, $pcStorage = 'json', $pcURI = dirname(__FILE__).'pclass.json', $ssl = true, $candice = true);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        unset($this->api, $this->options);
    }

    protected function setAddress($type = KlarnaFlags::IS_SHIPPING) {
        $this->api->setAddress($type, $this->options['addr']);
    }
    protected function addArticle() {
        $this->api->addArticle(
            $this->options['artarr']['qty'],
            $this->options['artarr']['artno'],
            $this->options['artarr']['arttitle'],
            $this->options['artarr']['price'],
            $this->options['artarr']['vat'],
            $this->options['artarr']['discount'],
            $this->options['artarr']['flags']
        );
    }
    protected function addArtNo() {
        $this->api->addArtNo(1, "12345");
    }
    protected function setCountry() {
        $this->api->setCountry(KlarnaCountry::SE);
        $this->api->setCurrency(KlarnaCurrency::SEK);
        $this->api->setLanguage(KlarnaLanguage::SV);
    }

    /*
     * @covers Klarna::addTransaction
     */
    public function testAddTransaction() {
        $this->api->expects($this->any())->
            method('xmlrpc_call')->
            with($this->logicalOr(
                $this->equalTo('add_invoice'),
                $this->equalTo('activate_reservation')
            ))->will($this->returnValue(
                array($this->options['testing']['invno'],KlarnaFlags::PENDING)
            )
        );

        $this->setCountry();
        $this->addArticle();
        $this->setAddress(); //Shipping is copied to billing.

        $ret = $this->api->addTransaction($pno = $this->options['pno'], $gender = null,
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $clear = true);

        //Make sure we got an array of size 2.
        PHPUnit_Framework_Assert::assertInternalType('array', $ret);
        PHPUnit_Framework_Assert::assertEquals(2, count($ret));

        //Make sure the first index is a string (invoice number)
        PHPUnit_Framework_Assert::assertInternalType('string', $ret[0]);

        //Make sure the last index is an integer (order status flag)
        PHPUnit_Framework_Assert::assertInternalType('int', $ret[1]);

        //Cover all the if-cases in addTransaction
        $this->addArticle();
        $this->setAddress(KlarnaFlags::IS_BILLING); //Billing is copied to shipping
        $this->api->addTransaction($pno = $this->options['pno'], $gender = KlarnaFlags::MALE,
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $clear = true);
    }

    /**
     * Dependency test / exception test
     *
     * @depends testAddTransaction
     * @covers Klarna::addTransaction
     * @expectedException KlarnaException
     */
    public function testAddTransactionExceptions() {
        try {
            //Test unset country
            $ret = $this->api->addTransaction($pno = $this->options['pno'], $gender = null,
                    $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $clear = true);
        }
        catch(KlarnaException $e) {
            try {
                //Test missing article
                $this->setCountry();
                $ret = $this->api->addTransaction($pno = $this->options['pno'], $gender = null,
                        $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $clear = true);
            }
            catch(KlarnaException $e) {
                try {
                    //Test missing address
                    $this->setCountry();
                    $this->addArticle();
                    $ret = $this->api->addTransaction($pno = $this->options['pno'], $gender = null,
                            $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $clear = true);
                }
                catch(KlarnaException $e) {
                    //Test wrong country on address
                    $this->options['addr']->setCountry('dk');
                    $this->setCountry();
                    $this->addArticle();
                    $this->setAddress();
                    $ret = $this->api->addTransaction($pno = $this->options['pno'], $gender = null,
                            $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $clear = true);
                }
                $this->fail('An expected exception has not been raised.');
            }
            $this->fail('An expected exception has not been raised.');
        }
        $this->fail('An expected exception has not been raised.');
    }

    /**
     * @covers Klarna::activateInvoice
     */
    public function testActivateInvoice() {
        $this->api->expects($this->any())->
            method('xmlrpc_call')->
            with($this->logicalOr(
                $this->equalTo('activate_invoice'),
                $this->equalTo('activate_part')
            ))->will($this->returnValue(
                $this->options['testing']['invno']
            )
        );

        $ret = $this->api->activateInvoice($this->options['invno']);

        //Make sure we got a string back.
        PHPUnit_Framework_Assert::assertInternalType('string', $ret);
    }

    /**
     * @covers Klarna::activatePart
     */
    public function testActivatePart() {
        $this->api->expects($this->any())->
            method('xmlrpc_call')->
            with($this->logicalOr(
                $this->equalTo('activate_invoice'),
                $this->equalTo('activate_part')
            ))->will($this->returnValue(
                $this->options['testing']['invno']
            )
        );

        $this->addArtNo();
        $ret = $this->api->activatePart($this->options['invno']);

        PHPUnit_Framework_Assert::assertInternalType('string', $ret);
    }

    /**
     * @depends testActivatePart
     * @covers Klarna::activatePart
     * @expectedException KlarnaException
     */
    public function testActivatePartException() {
        $this->api->activatePart($this->options['invno']);
    }

    /**
     * @covers Klarna::reserveAmount
     */
    public function testReserveAmount() {
        $this->api->expects($this->any())->
            method('xmlrpc_call')->
            with(
                $this->equalTo('reserve_amount')
            )->will($this->returnValue(
                array($this->options['testing']['invno'],KlarnaFlags::PENDING)
            )
        );

        $this->setCountry();
        $this->setAddress(KlarnaFlags::IS_BILLING);
        $this->setAddress(KlarnaFlags::IS_SHIPPING);
        $this->addArticle();
        $ret = $this->api->reserveAmount($pno = $this->options['pno'], $gender = null, $amount = $this->options['artarr']['price'],
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);

        //Make sure we got an array of size 2.
        PHPUnit_Framework_Assert::assertInternalType('array', $ret);
        PHPUnit_Framework_Assert::assertEquals(2, count($ret));

        //Make sure the first index is a string (invoice number)
        PHPUnit_Framework_Assert::assertInternalType('string', $ret[0]);

        //Make sure the last index is an integer (order status flag)
        PHPUnit_Framework_Assert::assertInternalType('int', $ret[1]);

        //Cover all the if-cases in reserveAmount
        $this->addArticle();
        $this->setAddress(KlarnaFlags::IS_BILLING);
        $this->setAddress(KlarnaFlags::IS_SHIPPING);
        $ret = $this->api->reserveAmount($pno = $this->options['pno'], $gender = KlarnaFlags::MALE, $amount = -1,
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
    }

    /**
     * Dependency test / exception test
     *
     * @depends testReserveAmount
     * @covers Klarna::reserveAmount
     * @expectedException KlarnaException
     */
    public function testReserveAmountExceptions() {
        try {
            //Test unset country
            $ret = $this->api->reserveAmount($pno = $this->options['pno'], $gender = null, $amount = $this->options['artarr']['price'],
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
        }
        catch(KlarnaException $e) {
            try {
                //Test missing article
                $this->setCountry();
                $ret = $this->api->reserveAmount($pno = $this->options['pno'], $gender = null, $amount = $this->options['artarr']['price'],
                    $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
            }
            catch(KlarnaException $e) {
                try {
                    //Test missing address
                    $this->setCountry();
                    $this->addArticle();
                    $ret = $this->api->reserveAmount($pno = $this->options['pno'], $gender = null, $amount = $this->options['artarr']['price'],
                        $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
                }
                catch(KlarnaException $e) {
                    try {
                        //Test wrong country on address
                        $this->options['addr']->setCountry('dk');
                        $this->setCountry();
                        $this->addArticle();
                        $this->setAddress(KlarnaFlags::IS_BILLING);
                        $this->setAddress(KlarnaFlags::IS_SHIPPING);
                        $ret = $this->api->reserveAmount($pno = $this->options['pno'], $gender = null, $amount = $this->options['artarr']['price'],
                            $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
                    }
                    catch(KlarnaException $e) {
                        //Test amount <= 0
                        $this->setCountry();
                        $this->addArticle();
                        $this->setAddress(KlarnaFlags::IS_BILLING);
                        $this->setAddress(KlarnaFlags::IS_SHIPPING);
                        $ret = $this->api->reserveAmount($pno = $this->options['pno'], $gender = null, $amount = 0,
                            $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
                    }
                    $this->fail('An expected exception has not been raised.');
                }
                $this->fail('An expected exception has not been raised.');
            }
            $this->fail('An expected exception has not been raised.');
        }
        $this->fail('An expected exception has not been raised.');
    }

    /**
     * @depends testReserveAmountExceptions
     * @covers Klarna::activateReservation
     */
    public function testActivateReservation() {
        $this->api->expects($this->any())->
            method('xmlrpc_call')->
            with($this->logicalOr(
                $this->equalTo('add_invoice'),
                $this->equalTo('activate_reservation')
            ))->will($this->returnValue(
                array($this->options['testing']['invno'],KlarnaFlags::PENDING)
            )
        );

        $this->setCountry();
        $this->setAddress(KlarnaFlags::IS_BILLING);
        $this->setAddress(KlarnaFlags::IS_SHIPPING);
        $this->addArticle();
        $ret = $this->api->activateReservation($pno = $this->options['pno'], $rno = $this->options['rno'], $gender = null, $ocr = null,
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = null, $clear = true);

        //Make sure we got an array of size 2.
        PHPUnit_Framework_Assert::assertInternalType('array', $ret);
        PHPUnit_Framework_Assert::assertEquals(2, count($ret));

        //Make sure the first index is a string (invoice number)
        PHPUnit_Framework_Assert::assertInternalType('string', $ret[0]);

        //Make sure the last index is an integer (order status flag)
        PHPUnit_Framework_Assert::assertInternalType('int', $ret[1]);

        //Cover all the if-cases in reserveAmount
        $this->addArticle();
        $this->setAddress(KlarnaFlags::IS_BILLING);
        $this->setAddress(KlarnaFlags::IS_SHIPPING);
        $ret = $this->api->activateReservation($pno = $this->options['pno'], $rno = $this->options['rno'], $gender = KlarnaFlags::MALE, $ocr = null,
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = null, $clear = true);
    }

    /**
     * Dependency test / exception test
     *
     * @depends testActivateReservation
     * @covers Klarna::activateReservation
     * @expectedException KlarnaException
     */
    public function testActivateReservationExceptions() {
        try {
            //Test unset country
            $ret = $this->api->reserveAmount($pno = $this->options['pno'], $rno = $this->options['rno'], $gender = null, $amount = $this->options['artarr']['price'],
                $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
        }
        catch(KlarnaException $e) {
            try {
                //Test missing article
                $this->setCountry();
                $ret = $this->api->reserveAmount($pno = $this->options['pno'], $rno = $this->options['rno'], $gender = null, $amount = $this->options['artarr']['price'],
                    $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
            }
            catch(KlarnaException $e) {
                try {
                    //Test missing address
                    $this->setCountry();
                    $this->addArticle();
                    $ret = $this->api->reserveAmount($pno = $this->options['pno'], $rno = $this->options['rno'], $gender = null, $amount = $this->options['artarr']['price'],
                        $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
                }
                catch(KlarnaException $e) {
                    try {
                        //Test wrong country on address
                        $this->options['addr']->setCountry('dk');
                        $this->setCountry();
                        $this->addArticle();
                        $this->setAddress(KlarnaFlags::IS_BILLING);
                        $this->setAddress(KlarnaFlags::IS_SHIPPING);
                        $ret = $this->api->reserveAmount($pno = $this->options['pno'], $rno = $this->options['rno'], $gender = null, $amount = $this->options['artarr']['price'],
                            $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
                    }
                    catch(KlarnaException $e) {
                        //Test no rno
                        $this->setCountry();
                        $this->addArticle();
                        $this->setAddress(KlarnaFlags::IS_BILLING);
                        $this->setAddress(KlarnaFlags::IS_SHIPPING);
                        $ret = $this->api->reserveAmount($pno = $this->options['pno'], $rno = null, $gender = null, $amount = $this->options['artarr']['price'],
                            $flags = KlarnaFlags::NO_FLAG, $pclass = KlarnaPClass::INVOICE, $encoding = null, $pin = "", $clear = true);
                    }
                }
                $this->fail('An expected exception has not been raised.');
            }
            $this->fail('An expected exception has not been raised.');
        }
        $this->fail('An expected exception has not been raised.');
    }

    /**
     * @covers Klarna::checkOrderStatus
     */
    public function testCheckOrderStatus() {
        $this->api->expects($this->any())->
            method('xmlrpc_call')->
            with(
                $this->equalTo('check_order_status')
            )->will($this->returnValue(
                array($this->options['testing']['invno'],KlarnaFlags::ACCEPTED)
            )
        );

        $ret = $this->api->checkOrderStatus($id = $this->options['rno'], $type = 1);

        //Make sure we got an array of size 2.
        PHPUnit_Framework_Assert::assertInternalType('array', $ret);
        PHPUnit_Framework_Assert::assertEquals(2, count($ret));

        //Make sure the first index is a string (invoice number)
        PHPUnit_Framework_Assert::assertInternalType('string', $ret[0]);

        //Make sure the last index is an integer (order status flag)
        PHPUnit_Framework_Assert::assertInternalType('int', $ret[1]);

        //Test so invoice type also goes through, without exceptions.
        $ret = $this->api->checkOrderStatus($id = $this->options['invno'], $type = 0);

        //Test so an invoice number can be sent as int.
        $ret = $this->api->checkOrderStatus($id = intval($this->options['invno']), $type = 1);
    }

    /**
     * @depends testCheckOrderStatus
     * @covers Klarna::checkOrderStatus
     * @expectedException KlarnaException
     */
    public function testCheckOrderStatusExceptions() {
        try {
            //Test no invno/rno
            $ret = $this->api->checkOrderStatus($id = "", $type = 0);
        }
        catch(KlarnaException $e) {
            //Test invalid type
            $ret = $this->api->checkOrderStatus($id = $this->options['invno'], $type = 3);
        }
        $this->fail('An expected exception has not been raised.');
    }

    /**
     * @covers Klarna::fetchPClasses
     */
    public function testGetPclasses() {
        $this->setCountry();
        $this->api->expects($this->any())->
            method('xmlrpc_call')->
            with(
                $this->equalTo('get_pclasses')
            )->will($this->returnValue(
                $this->options['testing']['pclasses']
            )
        );
        $this->api->fetchPClasses();
        $ret = $this->api->getPClasses();

        //Make sure we got an array of size 2.
        PHPUnit_Framework_Assert::assertInternalType('array', $ret);
        PHPUnit_Framework_Assert::assertEquals(1, count($ret));

        //Make sure we got PClass#362 and not #390.
        PHPUnit_Framework_Assert::assertEquals(362, current($ret)->getId());
    }
}
?>
