/*
 * Decompiled with CFR 0.152.
 */
import com.livinge.spellchecker.engine.BaseUtility;
import com.livinge.spellchecker.engine.CopyUtility;
import com.livinge.spellchecker.engine.SpellDictionaryEncDisk;
import com.livinge.spellchecker.engine.SpellSuggestion;
import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import java.applet.Applet;
import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public class LeSpellchecker
extends Applet
implements SpellCheckListener {
    private boolean initialized = false;
    protected SpellCheckEvent event;
    protected SpellChecker checker;
    private StringWordTokenizer tokens;
    protected int cursor = -1;
    protected Vector MisspelledList = new Vector();
    private static final int IGNORE_ALL_CAPS_WORD = 2;
    private static final int IGNORE_CAPPED_WORD = 4;
    private static final int IGNORE_MIXED_CASE = 8;
    private static final int IGNORE_MIXED_DIGITS = 16;
    private static final int REPORT_DOUBLED_WORD = 64;
    private static final int IGNORE_DOMAIN_NAMES = 65536;
    private static Hashtable configmap = new Hashtable();
    protected Hashtable baseMap = new Hashtable();
    protected SpellDictionaryEncDisk localDict;
    protected String userDictFilename = "myDict";
    protected SpellDictionaryHashMap userDict;
    protected boolean runThreads = true;
    protected CmdDispatcher Starter = new CmdDispatcher();
    protected String Cmd = "";
    protected String[] CmdArgs = new String[]{""};
    protected boolean startCheck = false;
    protected CheckerRun checkeR = new CheckerRun();
    protected String defEncoding = "UTF8";
    protected final int threadTick = 500;
    protected final int spellTimeout = 500;
    protected boolean working = true;
    protected boolean timeout = false;
    protected boolean debug = false;

    static {
        configmap.put(new Integer(16), "SPELL_IGNOREDIGITWORDS");
        configmap.put(new Integer(65536), "SPELL_IGNOREINTERNETADDRESS");
        configmap.put(new Integer(8), "SPELL_IGNOREMIXEDCASE");
        configmap.put(new Integer(64), "SPELL_IGNOREMULTIPLEWORDS");
        configmap.put(new Integer(4), "SPELL_IGNORESENTENCECAPTILIZATION");
        configmap.put(new Integer(2), "SPELL_IGNOREUPPERCASE");
    }

    public void init() {
        this.defEncoding = "UTF8";
        this.logMess("Init");
        this.logMess("Default encoding is set to: " + BaseUtility.getDefaultEncoding());
        final String dictionary = this.getParameter("dictionary");
        final String dictBase = this.getParameter("dictBase");
        try {
            String dp = this.getParameter("debug");
            if (dp.equals("on")) {
                this.debug = true;
            }
        }
        catch (Exception dp) {
            // empty catch block
        }
        System.setProperty("jazzy.config", "com.livinge.spellchecker.engine.SpellCheckConfiguration");
        this.checker = new SpellChecker();
        this.checker.setCache();
        try {
            this.baseMap = BaseUtility.createBase(dictionary);
            this.logMess("Local storage has been created");
        }
        catch (IllegalStateException ise) {
            ise.printStackTrace();
        }
        Thread t = new Thread(){

            public void run() {
                try {
                    LeSpellchecker.this.installDicts(dictionary, dictBase);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        this.Starter.start();
        this.checkeR.start();
        this.initialized = true;
        this.setWorking(false);
        this.logMess("Init complited");
    }

    protected void installDicts(String dict, String dictBase) {
        this.logMess("Seting up the dictionary for " + dict);
        String dictionary = String.valueOf(dict) + ".zip";
        String lds = this.baseMap.get("localDictBase").toString();
        String ldf = String.valueOf(lds) + dictionary;
        if (!new File(ldf).exists()) {
            this.logMess("Download dictionary:" + dictBase + dictionary);
            try {
                CopyUtility.copy(new URL(String.valueOf(dictBase) + dictionary), ldf);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (new File(ldf).exists() && !new File(String.valueOf(this.baseMap.get("localWordsDb").toString()) + "words.db").exists()) {
            this.extractAndCopy(ldf);
        }
        BaseUtility.createBaseFiles(this.baseMap);
        try {
            this.localDict = new SpellDictionaryEncDisk(new File(lds), new File(String.valueOf(lds) + dict + ".phonet"), true, this.defEncoding);
            this.checker.addDictionary(this.localDict);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setUserDict(dictBase);
        this.logMess("Dictionaries installed");
    }

    protected void extractAndCopy(String ldf) {
        String lds = this.baseMap.get("localDictBase").toString();
        this.logMess("Extract dictionary file: " + ldf);
        try {
            Vector ext = CopyUtility.extract(new ZipInputStream(new FileInputStream(ldf)), lds);
            Iterator j = ext.iterator();
            while (j.hasNext()) {
                String entry = j.next().toString();
                File f = new File(String.valueOf(lds) + entry);
                if (!f.exists()) continue;
                if (entry.equals("words.db") || entry.equals("words.idx") || entry.equals("contents")) {
                    f.renameTo(new File(String.valueOf(this.baseMap.get("localWordsDb").toString()) + entry));
                    continue;
                }
                if (entry.indexOf(".phonet") >= 0) continue;
                f.renameTo(new File(String.valueOf(this.baseMap.get("localWords").toString()) + entry));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void setUserDict(String dictBase) {
        long udfs = 0L;
        try {
            String user = this.getParameter("user").toString();
            this.userDictFilename = String.valueOf(user) + ".dict";
            udfs = Long.parseLong(this.getParameter("udSize").toString());
        }
        catch (Exception user) {
            // empty catch block
        }
        String lds = this.baseMap.get("localDictStorage").toString();
        String udfn = String.valueOf(lds) + this.userDictFilename;
        this.logMess("Seting up the user dictionary " + udfn);
        try {
            File uDictFile = new File(udfn);
            if (!uDictFile.exists() && !uDictFile.createNewFile()) {
                throw new IOException();
            }
            if (uDictFile.length() < udfs) {
                this.logMess("Download dictionary:" + dictBase + this.userDictFilename);
                try {
                    CopyUtility.copy(new URL(String.valueOf(dictBase) + this.userDictFilename), udfn);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            this.userDict = new SpellDictionaryHashMap(uDictFile);
            if (this.userDict != null) {
                this.checker.setUserDictionary(this.userDict);
            }
        }
        catch (IOException ex) {
            this.logMess(String.valueOf(this.hashCode()) + ": could not create user dict file in:" + udfn);
        }
        this.logMess("User dictionary installed");
    }

    protected void startDict(String dict) {
        this.checker.reset();
        this.checker.removeAllDictionaries();
        String dictBase = this.getParameter("dictBase");
        try {
            this.baseMap = BaseUtility.createBase(dict);
            this.logMess("Local storage has been be created");
        }
        catch (IllegalStateException ise) {
            ise.printStackTrace();
        }
        this.installDicts(dict, dictBase);
    }

    public void setDict(String dict) {
        this.Cmd = "startDict";
        this.CmdArgs[0] = dict;
    }

    public void setOptions(int options) {
        Configuration config = this.checker.getConfiguration();
        int i = 1;
        while (i <= 131072) {
            String key = (String)configmap.get(new Integer(i));
            if (key != null) {
                config.setBoolean(key, (options & i) > 0);
            }
            i <<= 1;
        }
    }

    protected void checkText(String text) {
        this.resetSuggestionList();
        this.checker.removeSpellCheckListener(this);
        this.checker.addSpellCheckListener(this);
        this.checker.reset();
        this.tokens = new StringWordTokenizer(text);
        this.startCheck = true;
        this.working = true;
        this.timeout = false;
    }

    public void check(String Text) {
        this.Cmd = "check";
        this.CmdArgs[0] = Text;
    }

    public void addWord(String word) {
        this.Cmd = "addWord";
        this.CmdArgs[0] = word;
    }

    public void addWords(String word) {
        this.Cmd = "addWords";
        this.CmdArgs[0] = word;
    }

    protected void logMess(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    public void destroy() {
        this.logMess("distroy");
        this.setWorking(false);
        this.runThreads = false;
        this.doSleep(2000);
    }

    public void paint(Graphics arg0) {
        super.paint(arg0);
    }

    public String getAppletInfo() {
        return "Spellchecker Plugin\nAuthor Slavko Tomcic";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"dictonary", "string", "the name of dictionary; should be saved as zip file in dictBase"}, {"dictBase", "string", "url where the dictionaries can be found"}};
        return pinfo;
    }

    public void spellingError(SpellCheckEvent event) {
        if (event != null) {
            boolean exists = false;
            for (SpellSuggestion element : this.MisspelledList) {
                if (!element.getMisspelledWord().equals(event.getInvalidWord())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.MisspelledList.add(new SpellSuggestion(event.getInvalidWord(), event.getWordContextPosition(), event.getSuggestions()));
                this.logMess("Misspelled: " + event.getInvalidWord());
            }
            this.timeOutChecking();
            if (!this.working) {
                event.cancel();
            }
        }
    }

    public boolean isReady() {
        return this.initialized;
    }

    public boolean isDictReady() {
        return this.localDict.isReady();
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    protected void timeOutChecking() {
        Thread t = new Thread(){

            public void run() {
                if (LeSpellchecker.this.runThreads) {
                    try {
                        2.sleep(500L);
                        LeSpellchecker.this.setTimeout(true);
                        LeSpellchecker.this.timeout = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
    }

    protected void setWorking(boolean value) {
        this.working = value;
    }

    public void setTimeout(boolean value) {
        this.timeout = value;
    }

    protected void doSleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetSuggestionList() {
        this.cursor = -1;
        this.MisspelledList = new Vector();
    }

    public boolean nextSuggestion() {
        if (this.hasNextSuggestion()) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    public boolean hasNextSuggestion() {
        return this.cursor + 1 < this.MisspelledList.size();
    }

    public String getMisspelledWord() {
        SpellSuggestion ss = (SpellSuggestion)this.MisspelledList.get(this.cursor);
        return ss.getMisspelledWord();
    }

    public int getMisspelledOffset() {
        SpellSuggestion ss = (SpellSuggestion)this.MisspelledList.get(this.cursor);
        return ss.getMisspelledOffset();
    }

    public String getSuggestions() {
        SpellSuggestion ss = (SpellSuggestion)this.MisspelledList.get(this.cursor);
        return ss.getSuggestions();
    }

    protected boolean deleteDic(String dict) {
        File dictDir = new File(String.valueOf(this.baseMap.get("localDictStorage").toString()) + dict);
        return this.delDir(dictDir);
    }

    protected boolean delDir(File dir) {
        if (dir.isDirectory()) {
            String[] childs = dir.list();
            int i = 0;
            while (i < childs.length) {
                if (!this.delDir(new File(dir, childs[i]))) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    class CmdDispatcher
    extends Thread {
        CmdDispatcher() {
        }

        public void run() {
            while (LeSpellchecker.this.runThreads) {
                if (LeSpellchecker.this.Cmd.equals("check")) {
                    LeSpellchecker.this.checkText(LeSpellchecker.this.CmdArgs[0]);
                    LeSpellchecker.this.Cmd = "";
                }
                if (LeSpellchecker.this.Cmd.equals("addWord")) {
                    LeSpellchecker.this.checker.addToDictionary(LeSpellchecker.this.CmdArgs[0]);
                    LeSpellchecker.this.Cmd = "";
                }
                if (LeSpellchecker.this.Cmd.equals("addWords")) {
                    String[] s = LeSpellchecker.this.CmdArgs[0].split(",");
                    int i = 0;
                    while (i < s.length) {
                        if (!s[i].equals("") && !s[i].equals(" ")) {
                            LeSpellchecker.this.checker.addToDictionary(s[i]);
                        }
                        ++i;
                    }
                    LeSpellchecker.this.Cmd = "";
                }
                if (LeSpellchecker.this.Cmd.equals("startDict")) {
                    LeSpellchecker.this.startDict(LeSpellchecker.this.CmdArgs[0]);
                    LeSpellchecker.this.Cmd = "";
                }
                LeSpellchecker.this.doSleep(500);
            }
        }
    }

    class CheckerRun
    extends Thread {
        CheckerRun() {
        }

        public void run() {
            while (LeSpellchecker.this.runThreads) {
                if (LeSpellchecker.this.startCheck) {
                    LeSpellchecker.this.startCheck = false;
                    LeSpellchecker.this.checker.checkSpelling(LeSpellchecker.this.tokens);
                    LeSpellchecker.this.setWorking(false);
                }
                LeSpellchecker.this.doSleep(500);
            }
        }
    }
}

