/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.Word;
import com.swabunga.spell.event.WordFinder;
import com.swabunga.spell.event.WordNotFoundException;
import java.text.BreakIterator;

public abstract class AbstractWordFinder
implements WordFinder {
    protected Word currentWord;
    protected Word nextWord;
    protected boolean startsSentence;
    protected String text;
    protected BreakIterator sentenceIterator;

    public AbstractWordFinder(String inText) {
        this.text = inText;
        this.setup();
    }

    public AbstractWordFinder() {
        this.text = "";
        this.setup();
    }

    public abstract Word next();

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.setup();
    }

    public Word current() {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        return this.currentWord;
    }

    public boolean hasNext() {
        return this.nextWord != null;
    }

    public void replace(String newWord) {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        StringBuffer sb = new StringBuffer(this.text.substring(0, this.currentWord.getStart()));
        sb.append(newWord);
        sb.append(this.text.substring(this.currentWord.getEnd()));
        int diff = newWord.length() - this.currentWord.getText().length();
        this.currentWord.setText(newWord);
        if (this.nextWord != null) {
            this.nextWord.setStart(this.nextWord.getStart() + diff);
        }
        this.text = sb.toString();
        this.sentenceIterator.setText(this.text);
        int start = this.currentWord.getStart();
        this.sentenceIterator.following(start);
        this.startsSentence = this.sentenceIterator.current() == start;
    }

    public boolean startsSentence() {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        return this.startsSentence;
    }

    public String toString() {
        return this.text;
    }

    protected void setSentenceIterator(Word wd) {
        int current = this.sentenceIterator.current();
        if (current == this.currentWord.getStart()) {
            this.startsSentence = true;
        } else {
            this.startsSentence = false;
            if (this.currentWord.getEnd() > current) {
                this.sentenceIterator.next();
            }
        }
    }

    protected boolean isWordChar(int posn) {
        boolean out = false;
        char curr = this.text.charAt(posn);
        if (posn == 0 || posn == this.text.length() - 1) {
            return Character.isLetterOrDigit(curr);
        }
        char prev = this.text.charAt(posn - 1);
        char next = this.text.charAt(posn + 1);
        switch (curr) {
            case '\'': 
            case '@': 
            case '_': {
                out = Character.isLetterOrDigit(prev) && Character.isLetterOrDigit(next);
                break;
            }
            case '.': {
                out = Character.isLetterOrDigit(prev) && (Character.isLetterOrDigit(next) || next == ' ' || next == ',' || next == ';' || next == ':');
                break;
            }
            default: {
                out = Character.isLetterOrDigit(curr);
            }
        }
        return out;
    }

    protected boolean isWordChar(char c) {
        boolean out = false;
        if (Character.isLetterOrDigit(c) || c == '\'' || c == '.') {
            out = true;
        }
        return out;
    }

    protected int ignore(int index, char startIgnore) {
        return this.ignore(index, new Character(startIgnore), null);
    }

    protected int ignore(int index, char startIgnore, char endIgnore) {
        return this.ignore(index, new Character(startIgnore), new Character(endIgnore));
    }

    protected int ignore(int index, Character startIgnore, Character endIgnore) {
        Character curChar;
        int newIndex = index;
        if (newIndex < this.text.length() && (curChar = new Character(this.text.charAt(newIndex))).equals(startIgnore)) {
            ++newIndex;
            while (newIndex < this.text.length()) {
                curChar = new Character(this.text.charAt(newIndex));
                if (endIgnore != null && curChar.equals(endIgnore)) {
                    ++newIndex;
                    break;
                }
                if (endIgnore == null && !Character.isLetterOrDigit(curChar.charValue())) break;
                ++newIndex;
            }
        }
        return newIndex;
    }

    protected int ignore(int index, String startIgnore, String endIgnore) {
        String seg;
        int newIndex = index;
        int len = this.text.length();
        int slen = startIgnore.length();
        int elen = endIgnore.length();
        if (newIndex + slen < len && (seg = this.text.substring(newIndex, newIndex + slen)).equals(startIgnore)) {
            newIndex += slen;
            while (newIndex != this.text.length() - elen) {
                String ss = this.text.substring(newIndex, newIndex + elen);
                if (ss.equals(endIgnore)) {
                    newIndex += elen;
                    break;
                }
                ++newIndex;
            }
        }
        return newIndex;
    }

    protected void init() {
        this.sentenceIterator = BreakIterator.getSentenceInstance();
        this.sentenceIterator.setText(this.text);
    }

    private void setup() {
        this.currentWord = new Word("", 0);
        this.nextWord = new Word("", 0);
        this.startsSentence = true;
        this.init();
        try {
            this.next();
        }
        catch (WordNotFoundException e) {
            this.currentWord = null;
            this.nextWord = null;
        }
    }
}

